/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;

public class MxCompositeData {
    private static final Map handlers = new HashMap();

    public static void setHandler(String type, Handler handler) {
        handlers.put(type, handler);
    }

    public static Object getValue(CompositeData data, String key) {
        Object value;
        Handler handler = (Handler)handlers.get(data.getCompositeType().getTypeName());
        if (handler != null && (value = handler.getObject(data, key)) != null) {
            return value;
        }
        return data.get(key);
    }

    static {
        MxCompositeData.setHandler("java.lang.management.MemoryUsage", new Handler(){

            public Object getObject(CompositeData data, String key) {
                if (key.equals("free")) {
                    Long committed = (Long)data.get("committed");
                    Long used = (Long)data.get("used");
                    return new Long(committed - used);
                }
                return null;
            }
        });
    }

    public static interface Handler {
        public Object getObject(CompositeData var1, String var2);
    }
}

