/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.logparse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.hyperic.hq.product.RtStat;
import org.hyperic.hq.product.logparse.LogParseInterface;

public abstract class BaseLogParser
implements LogParseInterface {
    protected ArrayList StatusDontLog = new ArrayList();
    protected ArrayList URLDontLog = new ArrayList();
    protected double timeMultiplier = 1.0;
    protected Log log = LogFactory.getLog(BaseLogParser.class);
    protected Integer id;
    protected int svcType;

    public abstract void initConfig(double var1, String var3);

    public Hashtable parseLog(String fname, String re, Integer ID, boolean collectIPs) throws IOException {
        return this.parseLog(fname, re, ID, 0, collectIPs);
    }

    public Hashtable parseLog(String fname, String re, Integer ID, int svcType, boolean collectIPs) throws IOException {
        return this.parseLog(fname, re, 0L, ID, collectIPs);
    }

    public Hashtable parseLog(String fname, String re, long len, Integer ID, boolean collectIPs) throws IOException {
        long[] parsedlen = new long[1];
        return this.parseLog(new File(fname), re, len, ID, 0, parsedlen, collectIPs);
    }

    public Hashtable parseLog(String fname, String re, long len, Integer ID, int svcType, long[] parsedlen, boolean collectIPs) throws IOException {
        return this.parseLog(new File(fname), re, len, ID, svcType, parsedlen, collectIPs);
    }

    public Hashtable parseLog(File f, String re, long len, Integer ID, int svcType, long[] parsedlen, boolean collectIPs) throws IOException {
        String currentLine;
        GlobCompiler gc = new GlobCompiler();
        Perl5Matcher pm = new Perl5Matcher();
        Hashtable<String, RtStat> urls = new Hashtable<String, RtStat>();
        BufferedReader in = new BufferedReader(new FileReader(f));
        in.skip(len);
        this.id = ID;
        this.svcType = svcType;
        this.initConfig(this.timeMultiplier, re);
        while ((currentLine = in.readLine()) != null) {
            Enumeration e;
            RtStat curr = this.parseLine(currentLine);
            if (curr == null) continue;
            if (!collectIPs) {
                curr.resetIp();
            }
            boolean logit = true;
            for (String current : this.URLDontLog) {
                try {
                    Pattern pa = gc.compile(current);
                    if (!pm.matches(curr.getUrl(), pa)) continue;
                    logit = false;
                    break;
                }
                catch (MalformedPatternException e2) {
                    this.log.error((Object)("Invalid regular expression: " + current));
                }
            }
            Integer stat = (e = curr.getStatus().keys()).hasMoreElements() ? (Integer)e.nextElement() : new Integer(200);
            String ipUrlKey = curr.getIpUrlKey();
            if (this.StatusDontLog.contains(stat) || !logit) continue;
            RtStat found = (RtStat)urls.get(ipUrlKey);
            if (found == null) {
                found = curr;
            } else {
                found.recompute(curr);
            }
            urls.put(ipUrlKey, found);
        }
        in.close();
        this.postFileParse(f);
        parsedlen[0] = f.length();
        return urls;
    }

    public void setTimeMultiplier(double mult) {
        this.timeMultiplier = mult;
    }

    public double getTimeMultiplier() {
        return this.timeMultiplier;
    }

    public void DontLog(Long stat) {
        this.StatusDontLog.add(stat);
    }

    public void DontLog(String url) {
        this.URLDontLog.add(url);
    }

    public void urlDontLog(ArrayList urls) {
        this.URLDontLog = urls;
    }

    public void postFileParse(File f) throws IOException {
    }
}

