/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.PIFMetrics;
import org.hyperic.hq.plugin.xen.XenCollector;

public class XenNicCollector
extends XenCollector {
    public void collect() {
        try {
            Connection conn = this.connect();
            PIF pif = PIF.getByUuid(conn, this.getServiceUUID());
            this.setAvailability(true);
            PIFMetrics metrics = pif.getMetrics(conn);
            PIFMetrics.Record record = metrics.getRecord(conn);
            this.setValue("IORead", record.ioReadKbs);
            this.setValue("IOWrite", record.ioWriteKbs);
            this.setValue("Speed", record.speed.longValue());
        }
        catch (Exception e) {
            this.setAvailability(false);
            this.setErrorMessage(e.getMessage());
        }
    }
}

