/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.xen;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VBD;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.VMGuestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.plugin.xen.XenUtil;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

public class XenVmDetector
extends ServerDetector
implements AutoServerDetector {
    private void setValue(ConfigResponse config, String key, String val) {
        if (val == null) {
            return;
        }
        config.setValue(key, val);
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        if (platformConfig.getValue("url") == null) {
            return null;
        }
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        Properties props = platformConfig.toProperties();
        Connection conn = XenUtil.connect(props);
        Host host = XenUtil.getHost(conn, props);
        try {
            for (VM vm : host.getResidentVMs(conn)) {
                if (vm.getIsATemplate(conn).booleanValue() || vm.getIsControlDomain(conn).booleanValue()) continue;
                ConfigResponse config = new ConfigResponse();
                String[] keys = XenUtil.CONNECT_PROPS;
                for (int i = 0; i < keys.length; ++i) {
                    config.setValue(keys[i], platformConfig.getValue(keys[i]));
                }
                ConfigResponse cprops = new ConfigResponse();
                String uuid = vm.getUuid(conn);
                String name = vm.getNameLabel(conn);
                VMGuestMetrics gmetrics = vm.getGuestMetrics(conn);
                try {
                    Map<String, String> os = gmetrics.getOsVersion(conn);
                    this.setValue(cprops, "os", os.get("name"));
                }
                catch (Exception e) {
                    this.getLog().warn((Object)("getOsVersion(" + uuid + ") failed: " + e));
                }
                String type = this.getTypeInfo().getName();
                ServerResource server = new ServerResource();
                server.setType(type);
                server.setName(XenVmDetector.getPlatformName() + " " + type + " " + name);
                server.setDescription(vm.getNameDescription(conn));
                server.setInstallPath(uuid);
                server.setIdentifier(uuid);
                config.setValue("server.uuid", uuid);
                server.setProductConfig(config);
                server.setMeasurementConfig();
                server.setControlConfig();
                server.setCustomProperties(cprops);
                servers.add(server);
            }
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return servers;
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        VM vm;
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        Properties props = serverConfig.toProperties();
        String vmid = props.getProperty("server.uuid");
        Connection conn = XenUtil.connect(props);
        try {
            vm = VM.getByUuid(conn, vmid);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        try {
            for (VBD vbd : vm.getVBDs(conn)) {
                Types.VbdType type = vbd.getType(conn);
                if (!type.equals((Object)Types.VbdType.DISK)) continue;
                String uuid = vbd.getUuid(conn);
                String name = vbd.getDevice(conn);
                ConfigResponse config = new ConfigResponse();
                config.setValue("service.uuid", uuid);
                ConfigResponse cprops = new ConfigResponse();
                ServiceResource service = this.createServiceResource("Storage");
                service.setServiceName("Storage " + name);
                service.setProductConfig(config);
                service.setMeasurementConfig();
                service.setCustomProperties(cprops);
                services.add(service);
            }
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        try {
            for (VIF vif : vm.getVIFs(conn)) {
                String uuid = vif.getUuid(conn);
                String name = vif.getDevice(conn);
                ConfigResponse config = new ConfigResponse();
                config.setValue("service.uuid", uuid);
                ConfigResponse cprops = new ConfigResponse();
                cprops.setValue("mac", vif.getMAC(conn));
                long mtu = vif.getMTU(conn);
                if (mtu > 0L) {
                    cprops.setValue("mtu", mtu);
                }
                ServiceResource service = this.createServiceResource("NIC");
                service.setServiceName("NIC " + name);
                service.setProductConfig(config);
                service.setMeasurementConfig();
                service.setCustomProperties(cprops);
                services.add(service);
            }
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
        return services;
    }
}

