/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.PlatformServiceDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.SNMPDetector;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.snmp.SNMPClient;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPValue;
import org.hyperic.util.config.ConfigResponse;

public class NetworkDeviceDetector
extends PlatformServiceDetector {
    private static final String SVC_NAME = "Interface";
    private static final String PROP_IF = "Interface".toLowerCase();
    static final String PROP_IF_IX = PROP_IF + ".index";
    static final String IF_DESCR = "ifDescr";
    static final String IF_NAME = "ifName";
    private static final String IF_MAC = "ifPhysAddress";
    private static final String IP_IF_IX = "ipAdEntIfIndex";
    private static final String IP_NETMASK = "ipAdEntNetMask";
    private static final String PROP_IP = "ipaddress";
    private static final String PROP_NETMASK = "netmask";
    private static final String[] FILTER_PROPS = new String[]{"ipaddress", "netmask"};
    private SNMPSession session;

    public List discoverServices(ConfigResponse serverConfig) throws PluginException {
        Log log = this.getLog();
        ArrayList services = new ArrayList();
        this.openSession(serverConfig);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using snmp config=" + serverConfig));
        }
        services.addAll(this.discoverInterfaces(serverConfig));
        List extServices = SNMPDetector.discoverServices((ServerDetector)this, (ConfigResponse)serverConfig, (SNMPSession)this.session);
        services.addAll(extServices);
        this.closeSession();
        return services;
    }

    protected boolean hasInterfaceService() {
        String type = this.getServiceTypeName(SVC_NAME);
        ProductPluginManager manager = (ProductPluginManager)this.getManager().getParent();
        MeasurementPlugin plugin = manager.getMeasurementPlugin(type);
        if (plugin == null) {
            return false;
        }
        return plugin.getCustomPropertiesSchema().getOption("ifMtu") != null;
    }

    protected List discoverInterfaces(ConfigResponse serverConfig) throws PluginException {
        String netmask;
        String ip;
        HashMap descriptions;
        Log log = this.getLog();
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        String type = this.getServiceTypeName(SVC_NAME);
        if (!this.hasInterfaceService()) {
            log.debug((Object)("Skipping discovery of " + type));
            return services;
        }
        String[] keys = this.getCustomPropertiesSchema(type).getOptionNames();
        HashMap<String, Map> cpropColumns = new HashMap<String, Map>();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (Arrays.binarySearch(FILTER_PROPS, key) != -1) continue;
            try {
                cpropColumns.put(key, this.getIfColumn(key));
                continue;
            }
            catch (PluginException e) {
                log.warn((Object)("Error getting '" + key + "': " + e.getMessage()));
            }
        }
        String columnName = serverConfig.getValue(PROP_IF_IX);
        if (columnName == null) {
            columnName = IF_DESCR;
        }
        Map interfaces = this.getIfColumn(columnName);
        log.debug((Object)("Found " + interfaces.size() + " interfaces using " + columnName));
        String descrColumn = columnName.equals(IF_DESCR) ? IF_NAME : IF_DESCR;
        try {
            descriptions = this.getIfColumn(descrColumn);
        }
        catch (PluginException e) {
            descriptions = new HashMap();
            String msg = "Error getting descriptions from " + descrColumn + ": " + (Object)((Object)e);
            log.warn((Object)msg);
        }
        List ip_if_ix = this.getColumn(IP_IF_IX);
        HashMap<String, String> ips = new HashMap<String, String>();
        HashMap<String, String> netmasks = new HashMap<String, String>();
        String IF_IX_OID = SNMPClient.getOID((String)IP_IF_IX) + ".";
        String NETMASK_OID = SNMPClient.getOID((String)IP_NETMASK) + ".";
        for (int i = 0; i < ip_if_ix.size(); ++i) {
            SNMPValue value = (SNMPValue)ip_if_ix.get(i);
            String oid = value.getOID();
            String ix = value.toString();
            if (!oid.startsWith(IF_IX_OID)) continue;
            ip = oid.substring(IF_IX_OID.length());
            ips.put(ix, ip);
            try {
                netmask = this.session.getSingleValue(NETMASK_OID + ip).toString();
                netmasks.put(ix, netmask);
                continue;
            }
            catch (SNMPException e) {
                log.debug((Object)("Failed to get netmask for " + ip));
            }
        }
        Iterator it = interfaces.entrySet().iterator();
        while (it.hasNext()) {
            ConfigResponse config = new ConfigResponse();
            ConfigResponse cprops = new ConfigResponse();
            Map.Entry entry = it.next();
            String ix = (String)entry.getKey();
            String name = (String)entry.getValue();
            String mac = null;
            ServiceResource service = this.createServiceResource(SVC_NAME);
            config.setValue(PROP_IF, name);
            config.setValue(PROP_IF_IX, columnName);
            service.setProductConfig(config);
            service.setMeasurementConfig();
            for (int j = 0; j < keys.length; ++j) {
                String val;
                String key = keys[j];
                Map data = (Map)cpropColumns.get(key);
                if (data == null || (val = (String)data.get(ix)) == null) continue;
                cprops.setValue(key, val);
                if (!key.equals(IF_MAC)) continue;
                mac = val;
            }
            ip = (String)ips.get(ix);
            netmask = (String)netmasks.get(ix);
            if (ip == null) {
                ip = "0.0.0.0";
            }
            if (netmask == null) {
                netmask = "0.0.0.0";
            }
            cprops.setValue(PROP_IP, ip);
            cprops.setValue(PROP_NETMASK, netmask);
            service.setCustomProperties(cprops);
            name = name + " " + SVC_NAME;
            if (mac != null && !mac.equals("0:0:0:0:0:0")) {
                name = name + " (" + mac + ")";
            }
            service.setServiceName(name);
            Object obj = descriptions.get(ix);
            if (obj != null) {
                service.setDescription(obj.toString());
            }
            services.add(service);
        }
        return services;
    }

    static SNMPSession getSession(ConfigResponse config) throws PluginException {
        try {
            return new SNMPClient().getSession(config);
        }
        catch (SNMPException e) {
            throw new PluginException("Error getting SNMP session: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void openSession(ConfigResponse config) throws PluginException {
        this.session = NetworkDeviceDetector.getSession(config);
    }

    protected void closeSession() {
        this.session = null;
    }

    private String getIfIndex(SNMPValue val) {
        String oid = val.getOID();
        int last = oid.lastIndexOf(46);
        return oid.substring(last + 1);
    }

    protected Map getIfColumn(String name) throws PluginException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List column = this.getColumn(name);
        for (int i = 0; i < column.size(); ++i) {
            SNMPValue ent = (SNMPValue)column.get(i);
            String ix = this.getIfIndex(ent);
            String val = name.equals(IF_MAC) ? ent.toPhysAddressString() : ent.toString().trim();
            map.put(ix, val);
        }
        return map;
    }

    protected List getColumn(String name) throws PluginException {
        try {
            return this.session.getColumn(name);
        }
        catch (SNMPException e) {
            throw new PluginException("Error getting SNMP column: " + name + ":" + (Object)((Object)e), (Throwable)e);
        }
    }

    protected String getServerName(ConfigResponse config) {
        String fqdn = config.getValue("platform.fqdn");
        String name = config.getValue("platform.name");
        return fqdn + " " + name;
    }

    public List getServerResources(ConfigResponse config) {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Testing snmp config=" + config));
        }
        if (config.getValue("snmpIp") == null) {
            log.debug((Object)"snmp config incomplete, defering server creation");
            return null;
        }
        try {
            NetworkDeviceDetector.getSession(config).getSingleValue("sysName");
        }
        catch (Exception e) {
            log.debug((Object)"snmp config invalid, defering server creation");
            return null;
        }
        log.debug((Object)"snmp config valid, creating server");
        return super.getServerResources(config);
    }

    protected ServerResource getServer(ConfigResponse config) {
        ServerResource server = super.getServer(config);
        server.setName(this.getServerName(config));
        return server;
    }
}

