/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hibernate.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hibernate.dialect.HQDialect;
import org.hyperic.hq.measurement.shared.MeasRangeObj;
import org.hyperic.util.StringUtil;
import org.hyperic.util.jdbc.DBUtil;
import org.hyperic.util.timer.StopWatch;

public class MySQL5InnoDBDialect
extends org.hibernate.dialect.MySQL5InnoDBDialect
implements HQDialect {
    private static final String logCtx = MySQL5InnoDBDialect.class.getName();
    private final Log _log = LogFactory.getLog((String)logCtx);
    private static final String TAB_MEAS = "EAM_MEASUREMENT";
    private static final String TAB_DATA = "EAM_MEASUREMENT_DATA";
    private static final int IND_LAST_TIME = 4;

    public MySQL5InnoDBDialect() {
        this.registerColumnType(-3, 255, "blob");
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public String getOptimizeStmt(String table, int cost) {
        return "ANALYZE TABLE " + table.toUpperCase();
    }

    public boolean supportsDuplicateInsertStmt() {
        return true;
    }

    public boolean supportsMultiInsertStmt() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean viewExists(Statement stmt, String viewName) throws SQLException {
        ResultSet rs;
        block3: {
            boolean bl;
            rs = null;
            try {
                String sql = "SELECT table_name from information_schema.views WHERE table_name = '" + viewName + "'" + " AND table_schema = database()";
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet((Object)logCtx, rs);
                throw throwable;
            }
            DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
            return bl;
        }
        boolean bl = false;
        DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Statement stmt, String tableName) throws SQLException {
        ResultSet rs;
        block3: {
            boolean bl;
            rs = null;
            try {
                String sql = "SELECT table_name from information_schema.tables WHERE table_name = '" + tableName + "'" + " AND table_schema = database()";
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet((Object)logCtx, rs);
                throw throwable;
            }
            DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
            return bl;
        }
        boolean bl = false;
        DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
        return bl;
    }

    public String getLimitBuf(String sql, int offset, int limit) {
        StringBuilder buf = new StringBuilder(sql);
        buf.append(" LIMIT ");
        if (offset > 0) {
            buf.append(offset).append(',');
        }
        buf.append(limit);
        return buf.toString();
    }

    public String getLimitString(int num) {
        return "LIMIT " + num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMeasIds(Connection conn, Map lastMap, Integer[] iids) throws SQLException {
        StringBuffer iidsConj = new StringBuffer(DBUtil.composeConjunctions((String)"instance_id", (int)iids.length));
        DBUtil.replacePlaceHolders((StringBuffer)iidsConj, (Object[])iids);
        HashMap<Integer, LongListObj> rtn = new HashMap<Integer, LongListObj>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT id FROM EAM_MEASUREMENT WHERE template_id = ? AND " + iidsConj;
            pstmt = conn.prepareStatement(sql);
            for (Map.Entry entry : lastMap.entrySet()) {
                Integer tid = (Integer)entry.getKey();
                Long lastTime = (Long)entry.getValue();
                int ind = 1;
                pstmt.setInt(ind++, tid);
                rs = pstmt.executeQuery();
                ArrayList<Integer> list = new ArrayList<Integer>();
                while (rs.next()) {
                    list.add(new Integer(rs.getInt(1)));
                }
                LongListObj longListObj = (LongListObj)rtn.get(tid);
                if (null == longListObj) {
                    rtn.put(tid, new LongListObj(lastTime, list));
                    continue;
                }
                List timelist = longListObj.getList();
                timelist.addAll(list);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet((Object)logCtx, rs);
            DBUtil.closeStatement((Object)logCtx, pstmt);
            throw throwable;
        }
        DBUtil.closeResultSet((Object)logCtx, rs);
        DBUtil.closeStatement((Object)logCtx, (Statement)pstmt);
        return rtn;
    }

    private String getUnionStatement(Integer[] measIds, long timestamp) {
        StringBuilder sql = new StringBuilder();
        String measInStmt = this.getMeasInStmt(measIds, true);
        sql.append("(SELECT * FROM ").append(MeasRangeObj.getInstance().getTable(timestamp)).append(" WHERE timestamp = ").append(timestamp).append(measInStmt).append(") ").append(TAB_DATA);
        return sql.toString();
    }

    private String getMeasInStmt(Integer[] measIds, boolean prependAnd) {
        if (measIds.length == 0) {
            return "";
        }
        StringBuilder rtn = new StringBuilder();
        rtn.append(" " + (prependAnd ? "AND" : "") + " measurement_id");
        if (measIds.length == 1) {
            rtn.append(" = " + measIds[0]);
            return rtn.toString();
        }
        rtn.append(" in (");
        for (int i = 0; i < measIds.length; ++i) {
            if (measIds[i] == null) continue;
            rtn.append(measIds[i] + ",");
        }
        rtn.deleteCharAt(rtn.length() - 1);
        rtn.append(")");
        return rtn.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getLastData(Connection conn, String minMax, Map resMap, Map lastMap, Integer[] iids, long begin, long end, String table) throws SQLException {
        ResultSet rs = null;
        Statement stmt = null;
        StopWatch timer = new StopWatch();
        try {
            Map timeMeasIDMap = this.getMeasIds(conn, lastMap, iids);
            stmt = conn.createStatement();
            for (Map.Entry entry : timeMeasIDMap.entrySet()) {
                Integer tid = (Integer)entry.getKey();
                LongListObj obj = (LongListObj)entry.getValue();
                Long lastTime = obj.getLong();
                Integer[] measIds = obj.getList().toArray(new Integer[0]);
                if (table.endsWith(TAB_DATA)) {
                    table = this.getUnionStatement(measIds, lastTime);
                }
                String sql = "SELECT value FROM " + table + " WHERE timestamp = " + lastTime;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("getAggregateData() for measids=" + measIds + " lastTime=" + lastTime + ": " + sql));
                }
                if (!(rs = stmt.executeQuery(sql)).next()) continue;
                double[] data = (double[])resMap.get(tid);
                data[4] = rs.getDouble(1);
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("getAggregateData(): Statement query elapsed time: " + timer.reset()));
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet((Object)logCtx, rs);
            DBUtil.closeStatement((Object)logCtx, stmt);
            throw throwable;
        }
        DBUtil.closeResultSet((Object)logCtx, rs);
        DBUtil.closeStatement((Object)logCtx, (Statement)stmt);
        return resMap;
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String cols = StringUtil.implode(Arrays.asList(foreignKey), (String)", ");
        return new StringBuffer(64).append(" add constraint ").append(constraintName).append(" foreign key (").append(cols).append(") references ").append(referencedTable).append(" (").append(StringUtil.implode(Arrays.asList(primaryKey), (String)", ")).append(')').toString();
    }

    public boolean usesSequenceGenerator() {
        return false;
    }

    public String getRegExSQL(String column, String regex, boolean ignoreCase, boolean invertMatch) {
        if (ignoreCase) {
            return "lower(" + column + ")" + (invertMatch ? " NOT " : " ") + "REGEXP " + "lower(" + regex + ")";
        }
        return column + (invertMatch ? " NOT " : " ") + "REGEXP " + regex;
    }

    public boolean useEamNumbers() {
        return false;
    }

    public int getMaxExpressions() {
        return -1;
    }

    public boolean supportsPLSQL() {
        return false;
    }

    public boolean useMetricUnion() {
        return false;
    }

    public String getMetricDataHint() {
        return "USE INDEX (PRIMARY)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getSchemaCreationTimestampInMillis(Statement stmt) throws SQLException {
        block8: {
            block7: {
                rs = null;
                installDate = null;
                try {
                    arr$ = sqls = new String[]{"select CTIME from EAM_AGENT_TYPE where ID = 1", "select CTIME from EAM_APPLICATION_TYPE where ID = 2", "select CTIME from EAM_RESOURCE_GROUP where ID = 0", "select CTIME from EAM_ALERT_DEFINITION where ID = 0", "select CTIME from EAM_ESCALATION where ID = 100"};
                    len$ = arr$.length;
                    i$ = 0;
lbl7:
                    // 2 sources

                    while (i$ < len$) {
                        sql = arr$[i$];
                        rs = stmt.executeQuery(sql);
                        if (!rs.next()) ** GOTO lbl-1000
                        date = new Date(rs.getLong(1));
                        if (installDate == null) {
                            installDate = date;
                        } else {
                            cal1 = Calendar.getInstance();
                            cal2 = Calendar.getInstance();
                            cal1.setTime(installDate);
                            cal2.setTime(date);
                            if (cal1.get(1) != cal2.get(1) || cal1.get(6) != cal2.get(6)) {
                                var12_14 = null;
                                break block7;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl32
                }
                catch (Throwable var13_15) {
                    DBUtil.closeResultSet((Object)MySQL5InnoDBDialect.logCtx, rs);
                    throw var13_15;
                }
            }
            DBUtil.closeResultSet((Object)MySQL5InnoDBDialect.logCtx, (ResultSet)rs);
            return var12_14;
lbl-1000:
            // 3 sources

            {
                ++i$;
                ** GOTO lbl7
lbl32:
                // 1 sources

                sql = "select min(CREATE_TIME) from information_schema.tables where table_schema = database()";
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block8;
                date = rs.getDate(1);
                cal1 = Calendar.getInstance();
                cal2 = Calendar.getInstance();
                cal1.setTime(installDate);
                cal2.setTime(date);
                if (cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6)) break block8;
                var9_11 = null;
            }
            DBUtil.closeResultSet((Object)MySQL5InnoDBDialect.logCtx, (ResultSet)rs);
            return var9_11;
        }
        DBUtil.closeResultSet((Object)MySQL5InnoDBDialect.logCtx, (ResultSet)rs);
        return installDate.getTime();
    }

    public boolean analyzeDb() {
        return true;
    }

    public boolean supportsAsyncCommit() {
        return false;
    }

    public String getSetAsyncCommitStmt(boolean on) {
        return null;
    }

    private class LongListObj {
        private Long longVal;
        private List listVal;

        LongListObj(Long longVal, List listVal) {
            this.longVal = longVal;
            this.listVal = listVal;
        }

        List getList() {
            return this.listVal;
        }

        Long getLong() {
            return this.longVal;
        }
    }
}

