/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hibernate.usertypes;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.hibernate.util.EqualsHelper;
import org.hyperic.hq.common.SystemException;
import org.hyperic.util.encoding.ObjectCoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodedSerializedStringUserType<T>
implements UserType {
    private static final int[] m_arrSqlTypes = new int[]{12};
    private Class<T> m_clsReturnType;

    public EncodedSerializedStringUserType() {
    }

    public EncodedSerializedStringUserType(Class<T> clsReturnType) {
        this.m_clsReturnType = clsReturnType;
    }

    public final int[] sqlTypes() {
        return m_arrSqlTypes;
    }

    public final Class<T> returnedClass() {
        return this.m_clsReturnType;
    }

    public final boolean equals(Object x, Object y) throws HibernateException {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public final int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String sEncodedValue = rs.getString(names[0]);
        Object oResult = null;
        try {
            oResult = ObjectCoder.decode((String)sEncodedValue, this.m_clsReturnType);
        }
        catch (Throwable t) {
            throw new SystemException(t);
        }
        return oResult;
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        try {
            String sEncodedValue = ObjectCoder.encode(null, (Object)value);
            st.setString(index, sEncodedValue);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public final Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public final boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public final Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public final Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

