/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport.util;

import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.transport.util.MessageDeliveryOptions;
import org.jboss.remoting.InvokerLocator;

public class HQInvokerLocator
extends InvokerLocator {
    public static final String UNKNOWN_AGENT_TOKEN = "UNKNOWN-AGENT-TOKEN";
    private final String _agentToken;
    private static final ThreadLocal<MessageDeliveryOptions> THREADLOCAL_MESSAGE_DELIVERY_OPTIONS = new ThreadLocal<MessageDeliveryOptions>(){

        @Override
        protected MessageDeliveryOptions initialValue() {
            return MessageDeliveryOptions.newSynchronousInstance();
        }
    };

    public HQInvokerLocator(String protocol, String host, int port, String path, Map parameters, String agentToken) {
        super(protocol, host, port, path, parameters);
        if (agentToken == null) {
            throw new NullPointerException("agent token is null");
        }
        if (agentToken.equals(UNKNOWN_AGENT_TOKEN)) {
            throw new IllegalArgumentException("illegal token name: UNKNOWN-AGENT-TOKEN");
        }
        this._agentToken = agentToken;
    }

    public HQInvokerLocator(String protocol, String host, int port, String path, Map parameters) {
        super(protocol, host, port, path, parameters);
        this._agentToken = UNKNOWN_AGENT_TOKEN;
    }

    public InvokerLocator toInvokerLocator() {
        return new InvokerLocator(this.getProtocol(), this.getHost(), this.getPort(), this.getPath(), this.getParameters());
    }

    public HQInvokerLocator cloneWithNewAgentToken(String agentToken) {
        HashMap parameters = null;
        if (this.getParameters() != null) {
            parameters = new HashMap(this.getParameters());
        }
        return new HQInvokerLocator(this.getProtocol(), this.getHost(), this.getPort(), this.getPath(), parameters, agentToken);
    }

    public String getAgentToken() {
        return this._agentToken;
    }

    public boolean isAgentTokenKnown() {
        return !UNKNOWN_AGENT_TOKEN.equals(this._agentToken);
    }

    public void setMessageDeliveryOptions(MessageDeliveryOptions options) {
        if (options == null) {
            throw new NullPointerException("message delivery options is null");
        }
        THREADLOCAL_MESSAGE_DELIVERY_OPTIONS.set(options);
    }

    public MessageDeliveryOptions getMessageDeliveryOptions() {
        return THREADLOCAL_MESSAGE_DELIVERY_OPTIONS.get();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HQInvokerLocator) {
            HQInvokerLocator locator = (HQInvokerLocator)((Object)obj);
            return super.equals(obj) && locator.getAgentToken().equals(this.getAgentToken());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 17 * result + this.getAgentToken().hashCode();
        return result;
    }
}

