/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport.util;

public class MessageDeliveryOptions {
    private static final MessageDeliveryOptions SYNCHRONOUS = new MessageDeliveryOptions(false, false);
    private static final MessageDeliveryOptions ASYNC_GUARANTEED = new MessageDeliveryOptions(true, true);
    private static final MessageDeliveryOptions ASYNC_NON_GUARANTEED = new MessageDeliveryOptions(true, false);
    private final boolean _asynchronous;
    private final boolean _guaranteed;

    private MessageDeliveryOptions(boolean asynchronous, boolean guaranteed) {
        if (!asynchronous && guaranteed) {
            throw new IllegalArgumentException("guaranteed delivery only available for asynchronous delivery");
        }
        this._asynchronous = asynchronous;
        this._guaranteed = guaranteed;
    }

    public static MessageDeliveryOptions newSynchronousInstance() {
        return SYNCHRONOUS;
    }

    public static MessageDeliveryOptions newAsynchronousInstance(boolean guaranteed) {
        if (guaranteed) {
            return ASYNC_GUARANTEED;
        }
        return ASYNC_NON_GUARANTEED;
    }

    public boolean isAsynchronous() {
        return this._asynchronous;
    }

    public boolean isGuaranteed() {
        return this._guaranteed;
    }
}

