/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.remoting.InvocationRequest;

public class TransportUtils {
    private TransportUtils() {
    }

    public static boolean isOneWayInvocation(InvocationRequest invocation) {
        Map requestPayload = invocation.getRequestPayload();
        if (requestPayload != null) {
            String value = (String)requestPayload.get("oneway");
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void setOneWayInvocation(InvocationRequest invocation) {
        HashMap<String, String> requestPayload = invocation.getRequestPayload();
        if (requestPayload == null) {
            requestPayload = new HashMap<String, String>();
            invocation.setRequestPayload(requestPayload);
        }
        requestPayload.put("oneway", Boolean.TRUE.toString());
    }

    public static String getHttpTransport(boolean encrypted) {
        if (encrypted) {
            return "https";
        }
        return "http";
    }

    public static void assertVoidReturnTypes(Class serviceInterface) {
        Method[] methods = serviceInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getReturnType().equals(Void.TYPE)) continue;
            throw new IllegalArgumentException("found a non-void return type operation: " + method + " in " + serviceInterface);
        }
    }

    public static void assertOperationsThrowException(Class serviceInterface, Class expectedExceptionType) {
        Method[] methods = serviceInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] exceptions = method.getExceptionTypes();
            boolean throwsExpectedException = false;
            for (int j = 0; j < exceptions.length; ++j) {
                Class<?> exception = exceptions[j];
                if (!expectedExceptionType.equals(exception)) continue;
                throwsExpectedException = true;
                break;
            }
            if (throwsExpectedException) continue;
            throw new IllegalArgumentException(serviceInterface + " operation: " + method + " does not throw " + expectedExceptionType);
        }
    }

    public static Class tryLoadUnidirectionalTransportPollerClient() throws ClassNotFoundException {
        return Class.forName("com.hyperic.hq.transport.PollerClientImpl");
    }
}

