/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.bizapp.client.MeasurementCallbackClient;
import org.hyperic.hq.measurement.shared.MeasurementConfigEntity;
import org.hyperic.hq.measurement.shared.MeasurementConfigList;
import org.hyperic.hq.product.ConfigTrackPlugin;
import org.hyperic.hq.product.ConfigTrackPluginManager;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.util.config.ConfigResponse;

class ConfigPopulateThread
extends Thread {
    private static final long MAX_TIME_TO_SLEEP = 600000L;
    private MeasurementCallbackClient client;
    private LogTrackPluginManager ltManager;
    private ConfigTrackPluginManager ctManager;
    private Log log = LogFactory.getLog((String)ConfigPopulateThread.class.getName());

    ConfigPopulateThread(MeasurementCallbackClient client, LogTrackPluginManager ltManager, ConfigTrackPluginManager ctManager) {
        this.client = client;
        this.ltManager = ltManager;
        this.ctManager = ctManager;
    }

    public void run() {
        MeasurementConfigList configs;
        long timeToSleep = 10000L;
        this.log.info((Object)"Starting config populate thread");
        while (true) {
            try {
                configs = this.client.getMeasurementConfigs();
                break;
            }
            catch (Exception exc) {
                this.log.warn((Object)("Unable to get entities for agent: " + exc.getMessage()));
                this.log.warn((Object)("Sleeping for " + timeToSleep / 1000L + " seconds to fetch entities"));
                if ((timeToSleep *= 2L) > 600000L) {
                    timeToSleep = 600000L;
                }
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException exc2) {
                    this.log.warn((Object)"Interrupted ConfigPopulateThread");
                    return;
                }
            }
        }
        MeasurementConfigEntity[] ents = configs.getEntities();
        for (int i = 0; i < ents.length; ++i) {
            try {
                byte[] encConfig = ents[i].getConfig();
                if (encConfig == null || encConfig.length == 0) continue;
                ConfigResponse config = ConfigResponse.decode((byte[])encConfig);
                AppdefEntityID id = new AppdefEntityID(ents[i].getPluginName());
                this.log.info((Object)("Received measurement configuration for " + ents[i].getPluginType() + " '" + ents[i].getPluginName() + "'"));
                if (ConfigTrackPlugin.isEnabled((ConfigResponse)config, (int)id.getType())) {
                    this.log.info((Object)("Creating config track plugin " + ents[i].getPluginName()));
                    this.ctManager.createPlugin(ents[i].getPluginName(), ents[i].getPluginType(), config);
                }
                if (!LogTrackPlugin.isEnabled((ConfigResponse)config, (int)id.getType())) continue;
                this.log.info((Object)("Creating log track plugin " + ents[i].getPluginName()));
                this.ltManager.createPlugin(ents[i].getPluginName(), ents[i].getPluginType(), config);
                continue;
            }
            catch (Exception exc) {
                this.log.error((Object)("Unable to create plugin: " + ents[i].getPluginName() + " '" + ents[i].getPluginType() + "':" + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

