/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentNotificationHandler;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.agent.server.CollectorThread;
import org.hyperic.hq.agent.server.monitor.AgentMonitorInterface;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.client.MeasurementCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.measurement.agent.MeasurementCommandsAPI;
import org.hyperic.hq.measurement.agent.ScheduledMeasurement;
import org.hyperic.hq.measurement.agent.client.MeasurementCommandsClient;
import org.hyperic.hq.measurement.agent.commands.DeleteProperties_args;
import org.hyperic.hq.measurement.agent.commands.DeleteProperties_result;
import org.hyperic.hq.measurement.agent.commands.GetMeasurements_args;
import org.hyperic.hq.measurement.agent.commands.ScheduleMeasurements_args;
import org.hyperic.hq.measurement.agent.commands.ScheduleMeasurements_result;
import org.hyperic.hq.measurement.agent.commands.ScheduleTopn_args;
import org.hyperic.hq.measurement.agent.commands.SetProperties_args;
import org.hyperic.hq.measurement.agent.commands.SetProperties_result;
import org.hyperic.hq.measurement.agent.commands.TrackPluginAdd_args;
import org.hyperic.hq.measurement.agent.commands.TrackPluginAdd_result;
import org.hyperic.hq.measurement.agent.commands.TrackPluginRemove_args;
import org.hyperic.hq.measurement.agent.commands.TrackPluginRemove_result;
import org.hyperic.hq.measurement.agent.commands.UnscheduleMeasurements_args;
import org.hyperic.hq.measurement.agent.commands.UnscheduleMeasurements_result;
import org.hyperic.hq.measurement.agent.commands.UnscheduleTopn_result;
import org.hyperic.hq.measurement.agent.server.ConfigPopulateThread;
import org.hyperic.hq.measurement.agent.server.MeasurementCommandsService;
import org.hyperic.hq.measurement.agent.server.MeasurementSchedule;
import org.hyperic.hq.measurement.agent.server.ScheduleThread;
import org.hyperic.hq.measurement.agent.server.SenderThread;
import org.hyperic.hq.measurement.agent.server.TopNScheduler;
import org.hyperic.hq.measurement.agent.server.TrackerThread;
import org.hyperic.hq.product.ConfigTrackPluginManager;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.MeasurementPluginManager;
import org.hyperic.hq.product.MeasurementValueGetter;
import org.hyperic.hq.product.PluginManager;

public class MeasurementCommandsServer
implements AgentServerHandler,
AgentNotificationHandler {
    private static final long THREAD_JOIN_WAIT = 10000L;
    private final MeasurementCommandsAPI verAPI = new MeasurementCommandsAPI();
    private Thread scheduleThread = null;
    private ScheduleThread scheduleObject = null;
    private Thread senderThread = null;
    private SenderThread senderObject = null;
    private AgentStorageProvider storage = null;
    private final Map validProps = Collections.synchronizedMap(new HashMap());
    private AgentConfig bootConfig = null;
    private MeasurementSchedule schedStorage = null;
    private MeasurementPluginManager pluginManager = null;
    private final Log log = LogFactory.getLog(MeasurementCommandsServer.class);
    private ConfigTrackPluginManager ctPluginManager = null;
    private LogTrackPluginManager ltPluginManager = null;
    private Thread trackerThread = null;
    private TrackerThread trackerObject = null;
    private TopNScheduler topnScheduler = null;
    private MeasurementCommandsService measurementCommandsService;
    private CollectorThread collectorThread;

    public MeasurementCommandsServer() {
        for (String element : MeasurementCommandsAPI.propSet) {
            this.validProps.put(element, this);
        }
    }

    private void spawnThreads(SenderThread senderObject, ScheduleThread scheduleObject, TrackerThread trackerObject) throws AgentStartException {
        this.senderThread = new Thread((Runnable)senderObject, "SenderThread");
        this.senderThread.setDaemon(true);
        this.scheduleThread = new Thread((Runnable)scheduleObject, "ScheduleThread");
        this.scheduleThread.setDaemon(true);
        this.trackerThread = new Thread((Runnable)trackerObject, "TrackerThread");
        this.trackerThread.setDaemon(true);
        this.collectorThread = CollectorThread.getInstance((PluginManager)this.pluginManager);
        this.senderThread.start();
        this.scheduleThread.start();
        this.trackerThread.start();
        this.collectorThread.doStart();
    }

    public AgentAPIInfo getAPIInfo() {
        return this.verAPI;
    }

    public String[] getCommandSet() {
        return MeasurementCommandsAPI.commandSet;
    }

    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream in, OutputStream out) throws AgentRemoteException {
        if (cmd.equals("rtm:scheduleMeasurements")) {
            ScheduleMeasurements_args sa = new ScheduleMeasurements_args(args);
            this.measurementCommandsService.scheduleMeasurements(sa);
            return new ScheduleMeasurements_result();
        }
        if (cmd.equals("rtm:unscheduleMeasurements")) {
            UnscheduleMeasurements_args sa = new UnscheduleMeasurements_args(args);
            this.measurementCommandsService.unscheduleMeasurements(sa);
            return new UnscheduleMeasurements_result();
        }
        if (cmd.equals("rtm:getMeasurements")) {
            GetMeasurements_args sa = new GetMeasurements_args(args);
            return this.measurementCommandsService.getMeasurements(sa);
        }
        if (cmd.equals("rtm:setProperties")) {
            SetProperties_args sa = new SetProperties_args(args);
            this.measurementCommandsService.setProperties(sa);
            return new SetProperties_result();
        }
        if (cmd.equals("rtm:deleteProperties")) {
            DeleteProperties_args sa = new DeleteProperties_args(args);
            this.measurementCommandsService.deleteProperties(sa);
            return new DeleteProperties_result();
        }
        if (cmd.equals("track:trackAdd")) {
            TrackPluginAdd_args ta = new TrackPluginAdd_args(args);
            this.measurementCommandsService.addTrackPlugin(ta);
            return new TrackPluginAdd_result();
        }
        if (cmd.equals("track:trackRemove")) {
            TrackPluginRemove_args ta = new TrackPluginRemove_args(args);
            this.measurementCommandsService.removeTrackPlugin(ta);
            return new TrackPluginRemove_result();
        }
        if (cmd.equals("topN:scheduleTopn")) {
            ScheduleTopn_args topnArgs = new ScheduleTopn_args(args);
            this.measurementCommandsService.scheduleTopn(topnArgs);
            return new TrackPluginRemove_result();
        }
        if (cmd.equals("topN:unscheduleTopn")) {
            this.measurementCommandsService.unscheduleTopn();
            return new UnscheduleTopn_result();
        }
        throw new AgentRemoteException("Unknown command: " + cmd);
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        Iterator<ScheduledMeasurement> i = null;
        try {
            this.storage = agent.getStorageProvider();
            this.bootConfig = agent.getBootConfig();
            this.schedStorage = new MeasurementSchedule(this.storage, this.bootConfig.getBootProperties());
            this.logMeasurementSchedule(this.schedStorage);
        }
        catch (AgentRunningException exc) {
            throw new AgentAssertionException("Agent should be running here", (Throwable)exc);
        }
        try {
            this.pluginManager = (MeasurementPluginManager)agent.getPluginManager("measurement");
            this.ctPluginManager = (ConfigTrackPluginManager)agent.getPluginManager("config_track");
            this.ltPluginManager = (LogTrackPluginManager)agent.getPluginManager("log_track");
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get measurement plugin manager: " + e.getMessage());
        }
        this.senderObject = new SenderThread(this.bootConfig.getBootProperties(), this.storage, this.schedStorage);
        this.scheduleObject = new ScheduleThread(this.senderObject, (MeasurementValueGetter)this.pluginManager, this.bootConfig.getBootProperties());
        this.trackerObject = new TrackerThread(this.ctPluginManager, this.ltPluginManager, this.storage, this.bootConfig.getBootProperties());
        this.topnScheduler = new TopNScheduler(this.storage, this.bootConfig.getBootProperties());
        this.measurementCommandsService = new MeasurementCommandsService(this.storage, this.validProps, this.schedStorage, this.pluginManager, this.ltPluginManager, this.ctPluginManager, this.scheduleObject, this.topnScheduler);
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e.getMessage());
        }
        this.log.info((Object)"Registering Measurement Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(MeasurementCommandsClient.class, (Object)this.measurementCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register Measurement Commands Service.", e);
        }
        this.spawnThreads(this.senderObject, this.scheduleObject, this.trackerObject);
        try {
            i = this.schedStorage.getMeasurementList();
        }
        catch (Exception e) {
            throw new AgentStartException("Failed reading the measurement list from the storage.", e);
        }
        while (i.hasNext()) {
            ScheduledMeasurement meas = i.next();
            this.measurementCommandsService.scheduleMeasurement(meas);
        }
        agent.registerMonitor("camMetric.schedule", (AgentMonitorInterface)this.scheduleObject);
        agent.registerMonitor("camMetric.sender", (AgentMonitorInterface)this.senderObject);
        if (CommandsAPIInfo.getProvider((AgentStorageProvider)this.storage) == null) {
            agent.registerNotifyHandler((AgentNotificationHandler)this, CommandsAPIInfo.NOTIFY_SERVER_SET);
        } else {
            this.startConfigPopulator();
        }
        this.log.info((Object)"Measurement Commands Server started up");
    }

    public void handleNotification(String msgClass, String msg) {
        this.startConfigPopulator();
    }

    private void startConfigPopulator() {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this.storage);
        MeasurementCallbackClient client = new MeasurementCallbackClient((ProviderFetcher)fetcher);
        ConfigPopulateThread populator = new ConfigPopulateThread(client, this.ltPluginManager, this.ctPluginManager);
        populator.setDaemon(true);
        populator.start();
    }

    private void interruptThread(Thread t) throws InterruptedException {
        if (t.isAlive()) {
            t.interrupt();
            t.join(10000L);
            if (t.isAlive()) {
                this.log.warn((Object)(t.getName() + " did not die within the " + "timeout period.  Killing it"));
                t.stop();
            }
        }
    }

    private void logMeasurementSchedule(MeasurementSchedule sched) {
        if (this.log.isDebugEnabled()) {
            try {
                Iterator<ScheduledMeasurement> scheduleIter = sched.getMeasurementList();
                int scheduleSize = 0;
                while (scheduleIter.hasNext()) {
                    ScheduledMeasurement metric = scheduleIter.next();
                    if (metric == null) continue;
                    ScheduleThread.ParsedTemplate templ = ScheduleThread.getParsedTemplate(metric);
                    StringBuffer s = new StringBuffer("Measurement Schedule[").append(++scheduleSize).append("]: entityId=").append(metric.getEntity()).append(", category=").append(metric.getCategory()).append(", interval=").append(metric.getInterval()).append(", derivedId=").append(metric.getDerivedID()).append(", dsnId=").append(metric.getDsnID()).append(", dsn=").append(templ.metric.toDebugString());
                    this.log.debug((Object)s.toString());
                }
                this.log.debug((Object)("Measurement schedule list size=" + scheduleSize));
            }
            catch (Exception e) {
                this.log.debug((Object)("Could not display measurement schedule: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public final void postInitActions() throws AgentStartException {
    }

    public void shutdown() {
        this.log.info((Object)"Measurement Commands Server shutting down");
        this.logMeasurementSchedule(this.schedStorage);
        this.scheduleObject.die();
        this.collectorThread.doStop();
        this.senderObject.die();
        this.topnScheduler.die();
        try {
            this.interruptThread(this.senderThread);
            this.interruptThread(this.scheduleThread);
        }
        catch (InterruptedException exc) {
            this.log.warn((Object)"shutdown interrupted");
        }
        this.log.info((Object)"Measurement Commands Server shut down");
    }
}

