/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.monitor.AgentMonitorException;
import org.hyperic.hq.agent.server.monitor.AgentMonitorSimple;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.MeasurementCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.common.SystemException;
import org.hyperic.hq.measurement.agent.server.MeasurementSchedule;
import org.hyperic.hq.measurement.agent.server.Sender;
import org.hyperic.hq.measurement.agent.server.ServerTimeDiff;
import org.hyperic.hq.measurement.data.DSNList;
import org.hyperic.hq.measurement.data.MeasurementReport;
import org.hyperic.hq.measurement.data.MeasurementReportConstructor;
import org.hyperic.hq.measurement.server.session.SRN;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.util.Reference;
import org.hyperic.util.StringUtil;
import org.hyperic.util.encoding.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenderThread
extends AgentMonitorSimple
implements Sender,
Runnable {
    private static final String PROP_METRICDUP = "agent.metricDup";
    private static final String PROP_MAXBATCHSIZE = "agent.maxBatchSize";
    private static final String PROP_METRICDEBUG = "agent.metricDebug";
    private static final long MAX_SERVERDIFF = 180000L;
    private static final int PROP_RECSIZE = 34;
    private static final int SEND_INTERVAL = 60000;
    private static final int MAX_BATCHSIZE = 500;
    private static final String MEASURENENT_LISTNAME = "measurement_spool";
    private static final String AVAILABILITY_LISTNAME = "availability_spool";
    private volatile boolean shouldDie = false;
    private final Log log = LogFactory.getLog(SenderThread.class);
    private final MeasurementCallbackClient client;
    private final AgentStorageProvider storage;
    private String agentToken;
    private final LinkedList<Record> transitionQueue;
    private int metricDup = 0;
    private int maxBatchSize = 500;
    private final Set metricDebug;
    private final MeasurementSchedule schedule;
    private long serverDiff = 0L;
    private long stat_numBatchesSent = 0L;
    private long stat_totBatchSendTime = 0L;
    private long stat_totMetricsSent = 0L;

    SenderThread(Properties bootProps, AgentStorageProvider storage, MeasurementSchedule schedule) throws AgentStartException {
        String sMetricDebug;
        String sMaxBatchSize;
        String AvailabilityInfo;
        this.storage = storage;
        this.client = this.setupClient();
        this.transitionQueue = new LinkedList();
        this.metricDebug = new HashSet();
        this.schedule = schedule;
        String measuementInfo = bootProps.getProperty(MEASURENENT_LISTNAME);
        if (measuementInfo != null) {
            storage.addOverloadedInfo(MEASURENENT_LISTNAME, measuementInfo);
        }
        if ((AvailabilityInfo = bootProps.getProperty(AVAILABILITY_LISTNAME)) != null) {
            storage.addOverloadedInfo(AVAILABILITY_LISTNAME, AvailabilityInfo);
        }
        try {
            this.storage.createList(MEASURENENT_LISTNAME, 34);
            this.storage.createList(AVAILABILITY_LISTNAME, 34);
        }
        catch (AgentStorageException ignore) {
            // empty catch block
        }
        String sMetricDup = bootProps.getProperty(PROP_METRICDUP);
        if (sMetricDup != null) {
            try {
                this.metricDup = Integer.parseInt(sMetricDup);
            }
            catch (NumberFormatException exc) {
                throw new AgentStartException("agent.metricDup is not a valid integer ('" + sMetricDup + "')");
            }
            this.log.info((Object)("Duplicating metrics " + this.metricDup + " times"));
        }
        if ((sMaxBatchSize = bootProps.getProperty(PROP_MAXBATCHSIZE)) != null) {
            try {
                this.maxBatchSize = Integer.parseInt(sMaxBatchSize);
            }
            catch (NumberFormatException exc) {
                throw new AgentStartException("agent.maxBatchSize is not a valid integer ('" + sMaxBatchSize + "')");
            }
        }
        if ((sMetricDebug = bootProps.getProperty(PROP_METRICDEBUG)) != null) {
            try {
                for (String element : StringUtil.explode((String)sMetricDebug, (String)" ")) {
                    Integer metId = new Integer(element);
                    this.metricDebug.add(metId);
                    this.log.info((Object)("metricDebug:  Enabling special debugging for metric id=" + metId));
                }
            }
            catch (NumberFormatException exc) {
                throw new AgentStartException("agent.metricDebug must contain integers seperated by spaces");
            }
        }
        this.log.info((Object)("Maximum metric batch size set to " + this.maxBatchSize));
    }

    private MeasurementCallbackClient setupClient() throws AgentStartException {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this.storage);
        return new MeasurementCallbackClient((ProviderFetcher)fetcher);
    }

    void die() {
        this.shouldDie = true;
    }

    private static Record decodeRecord(String val) throws IOException {
        ByteArrayInputStream bIs = new ByteArrayInputStream(Base64.decode((String)val));
        DataInputStream dIs = new DataInputStream(bIs);
        int derivedID = dIs.readInt();
        long retTime = dIs.readLong();
        int dsnID = dIs.readInt();
        MetricValue measVal = new MetricValue(dIs.readDouble(), retTime);
        return new Record(dsnID, measVal, derivedID);
    }

    private static String encodeRecord(Record record) throws IOException {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        dOs.writeInt(record.derivedID);
        dOs.writeLong(record.data.getTimestamp());
        dOs.writeInt(record.dsnId);
        dOs.writeDouble(record.data.getValue());
        return Base64.encode((byte[])bOs.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processData(int dsnId, MetricValue data, int derivedID, boolean isAvail) {
        double val = data.getValue();
        if (this.metricDebug.contains(new Integer(derivedID))) {
            this.log.info((Object)("metricDebug:  Placing DSN='" + dsnId + "' derivedID=" + derivedID + " value=" + val + " time=" + data.getTimestamp() + " into transition queue"));
        }
        LinkedList<Record> linkedList = this.transitionQueue;
        synchronized (linkedList) {
            MetricValue measVal = new MetricValue(val, data.getTimestamp());
            this.transitionQueue.add(new Record(dsnId, measVal, derivedID, isAvail));
        }
        if (this.metricDup != 0) {
            ArrayList<Record> dupeList = new ArrayList<Record>();
            long dTime = data.getTimestamp();
            for (int i = 0; i < this.metricDup; ++i) {
                MetricValue measVal = new MetricValue(val, dTime + (long)i + 1L);
                dupeList.add(new Record(dsnId, measVal, derivedID, isAvail));
            }
            LinkedList<Record> linkedList2 = this.transitionQueue;
            synchronized (linkedList2) {
                this.transitionQueue.addAll(dupeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransitionQueue() {
        LinkedList<Record> linkedList = this.transitionQueue;
        synchronized (linkedList) {
            for (Record rec : this.transitionQueue) {
                try {
                    String encodedRec = SenderThread.encodeRecord(rec);
                    if (rec.isAvail) {
                        this.storage.addToList(AVAILABILITY_LISTNAME, encodedRec);
                        continue;
                    }
                    this.storage.addToList(MEASURENENT_LISTNAME, encodedRec);
                }
                catch (Exception exc) {
                    this.log.error((Object)("Unable to store data: " + exc), (Throwable)exc);
                }
            }
            this.transitionQueue.clear();
            try {
                this.storage.flush();
            }
            catch (Exception exc) {
                this.log.error((Object)"Unable to flush storage", (Throwable)exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long sendBatch(String listName, Reference<Integer> numSent) {
        int numUsed;
        long batchStart = 0L;
        long batchEnd = 0L;
        long lastMetricTime = 0L;
        long serverTime = 0L;
        this.processTransitionQueue();
        int numDebuggedSent = 0;
        MeasurementReportConstructor constructor = new MeasurementReportConstructor();
        boolean debug = this.log.isDebugEnabled();
        this.log.debug((Object)"Sending batch to server:");
        HashSet<Record> records = new HashSet<Record>();
        Iterator it = this.storage.getListIterator(listName);
        for (numUsed = 0; it != null && it.hasNext() && numUsed < this.maxBatchSize; ++numUsed) {
            try {
                Record r = SenderThread.decodeRecord((String)it.next());
                boolean didNotAlreadyExist = records.add(r);
                if (didNotAlreadyExist) continue;
                if (debug) {
                    this.log.debug((Object)("Dropping duplicate entry for " + r));
                }
                --numUsed;
                continue;
            }
            catch (IOException exc) {
                this.log.error((Object)("Error accessing record -- deleting: " + exc), (Throwable)exc);
            }
        }
        int num = 0;
        long firstMetricTime = Long.MAX_VALUE;
        for (Record rec : records) {
            lastMetricTime = rec.data.getTimestamp();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("    Data:  d=" + rec.derivedID + " r=" + rec.dsnId + " t=" + rec.data.getTimestamp() + " v=" + rec.data));
            }
            if (this.metricDebug.contains(new Integer(rec.derivedID))) {
                ++numDebuggedSent;
                this.log.info((Object)("metricDebug:  Pulled DSN=" + rec.dsnId + " derivedID=" + rec.derivedID + " value=" + rec.data.getValue() + " from tQueue -- sending"));
            }
            constructor.addDataPoint(rec.derivedID, rec.dsnId, rec.data);
            ++num;
        }
        numSent.set((Object)num);
        if (numUsed == 0) {
            return null;
        }
        DSNList[] clientIds = constructor.constructDSNList();
        boolean success = false;
        try {
            SRN[] srnList = this.schedule.getSRNsAsArray();
            if (srnList.length == 0) {
                this.log.error((Object)"Agent does not have valid SRNs, but has metric data to send, removing measurements");
                this.removeMeasurements(numUsed, listName);
                Long l = null;
                return l;
            }
            if (this.log.isDebugEnabled()) {
                for (SRN element : srnList) {
                    this.log.debug((Object)("    SRN: " + element.getEntity() + "=" + element.getRevisionNumber()));
                }
            }
            MeasurementReport report = new MeasurementReport();
            if (this.agentToken == null) {
                this.agentToken = this.storage.getValue("covalent.CAMAgentToken");
            }
            report.setAgentToken(this.agentToken);
            report.setClientIdList(clientIds);
            report.setSRNList(srnList);
            batchStart = this.now();
            try {
                serverTime = this.client.measurementSendReport(report);
            }
            catch (IllegalArgumentException e) {
                throw new SystemException("error sending report: " + e + ", report=" + report, (Throwable)e);
            }
            batchEnd = this.now();
            this.serverDiff = Math.abs(serverTime - batchEnd);
            ServerTimeDiff.getInstance().setServerTimeDiff(serverTime - batchEnd);
            ServerTimeDiff.getInstance().setLastSync(batchEnd);
            if (this.serverDiff > 180000L) {
                if (serverTime < batchEnd) {
                    this.log.error((Object)("Agent is " + this.serverDiff / 1000L + " seconds ahead of the server.  To " + "ensure accuracy of the charting and " + "alerting make sure the agent and server " + "clocks are synchronized"));
                } else {
                    this.log.error((Object)("Agent is " + this.serverDiff / 1000L + " seconds behind the server.  To " + "ensure accuracy of the charting and " + "alerting make sure the agent and server " + "clocks are synchronized"));
                }
            }
            success = true;
        }
        catch (AgentCallbackClientException exc) {
            this.log.error((Object)("Error sending measurements: " + exc.getMessage()), (Throwable)exc);
            if (!exc.getMessage().toLowerCase().endsWith("refused")) {
                this.log.info((Object)"retrying measurement send");
                Long l = firstMetricTime;
                return l;
            }
        }
        finally {
            if (numDebuggedSent != 0) {
                if (success) {
                    this.log.info((Object)("metricDebug:  Successfully sent " + numDebuggedSent + " debugged metrics to " + "server"));
                } else {
                    this.log.info((Object)("metricDebug:  Server reported failure when sent " + numDebuggedSent + " debugged metrics"));
                }
            }
        }
        if (success) {
            this.removeMeasurements(numUsed, listName);
            ++this.stat_numBatchesSent;
            this.stat_totBatchSendTime += batchEnd - batchStart;
            this.stat_totMetricsSent += (long)numUsed;
            if (numUsed == this.maxBatchSize) {
                return new Long(lastMetricTime);
            }
            return null;
        }
        return null;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private int removeMeasurements(int num, String listName) {
        int j;
        Iterator i = this.storage.getListIterator(listName);
        for (j = 0; i != null && i.hasNext() && j < num; ++j) {
            i.next();
            i.remove();
        }
        try {
            this.storage.flush();
        }
        catch (AgentStorageException exc) {
            this.log.error((Object)"Failed to flush agent storage", (Throwable)exc);
        }
        if (j != num) {
            this.log.error((Object)("Failed to remove " + (num - j) + "records"));
        }
        return j;
    }

    public double getNumBatchesSent() throws AgentMonitorException {
        return this.stat_numBatchesSent;
    }

    public double getTotBatchSendTime() throws AgentMonitorException {
        return this.stat_totBatchSendTime;
    }

    public double getTotMetricsSent() throws AgentMonitorException {
        return this.stat_totMetricsSent;
    }

    public double getServerOffset() throws AgentMonitorException {
        return this.serverDiff;
    }

    @Override
    public void run() {
        Calendar controlCal = Calendar.getInstance();
        controlCal.setTimeInMillis(System.currentTimeMillis());
        Calendar cal = Calendar.getInstance();
        controlCal.set(13, 5);
        while (!this.shouldDie) {
            try {
                try {
                    controlCal.add(12, 1);
                    long now = System.currentTimeMillis();
                    cal.setTimeInMillis(now + 60000L);
                    if (cal.get(12) != controlCal.get(12)) {
                        long sleeptime = controlCal.getTimeInMillis() - now;
                        if (sleeptime > 0L) {
                            Thread.sleep(controlCal.getTimeInMillis() - now);
                        }
                    } else {
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException exc) {
                    this.log.info((Object)"Measurement sender interrupted");
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Woke up, sending batch of metrics.");
                }
                Reference numSent = new Reference((Object)0);
                this.sendData(AVAILABILITY_LISTNAME, (Reference<Integer>)numSent);
                this.sendData(MEASURENENT_LISTNAME, (Reference<Integer>)numSent);
            }
            catch (Throwable e) {
                this.log.error((Object)e.getMessage(), e);
            }
        }
    }

    private void sendData(String listName, Reference<Integer> numSent) {
        Long lastMetricTime = this.sendBatch(listName, numSent);
        if (lastMetricTime != null) {
            String backlogNum = "";
            long start = System.currentTimeMillis();
            while ((lastMetricTime = this.sendBatch(listName, numSent)) != null) {
                long now = System.currentTimeMillis();
                long tDiff = now - lastMetricTime;
                String backlog = Long.toString(tDiff / 60000L);
                if (tDiff / 60000L > 1L && !backlog.equals(backlogNum)) {
                    backlogNum = backlog;
                    this.log.info((Object)(backlog + " minute(s) of metrics backlogged"));
                }
                if (!this.shouldDie) continue;
                this.log.info((Object)"Dying with measurements backlogged");
                return;
            }
            long total = System.currentTimeMillis() - start;
            if (total > 60000L) {
                this.log.info((Object)("Agent took " + total / 1000L + " seconds to send its " + listName + " metrics to the HQ Server."));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Agent took " + total + " ms to send its " + listName));
            }
        }
    }

    private static class Record {
        final int dsnId;
        final int derivedID;
        final MetricValue data;
        private Integer hashCode = null;
        private final boolean isAvail;

        private Record(int dsnId, MetricValue data, int derivedID, boolean isAvail) {
            this.dsnId = dsnId;
            this.data = data;
            this.derivedID = derivedID;
            this.isAvail = isAvail;
        }

        public Record(int dsnID, MetricValue measVal, int derivedID) {
            this(dsnID, measVal, derivedID, false);
        }

        public int hashCode() {
            if (this.hashCode != null) {
                return this.hashCode;
            }
            Long timestamp = new Long(this.data.getTimestamp() * 71L);
            Integer mId = new Integer(this.derivedID * 71);
            this.hashCode = new Integer(7 + timestamp.hashCode() * 71 + mId.hashCode() * 71);
            return this.hashCode;
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof Record) {
                Record r = (Record)rhs;
                return r.derivedID == this.derivedID && r.data.getTimestamp() == this.data.getTimestamp();
            }
            return false;
        }

        public String toString() {
            return "mId=" + this.derivedID + ",timestamp=" + this.data.getTimestamp() + ",value=" + this.data.getValue() + ",isAvail=" + this.isAvail;
        }
    }
}

