/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleSqlForRowSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    static final long serialVersionUID = -2066958142885801470L;
    private SQLWarning sqlWarning;
    private RowSetWarning rowsetWarning;
    protected int presentRow = 0;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull = false;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag = false;
    private int updateRowPosition;
    private boolean updateRowFlag = false;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    private transient OracleSqlForRowSet osql = null;
    protected Vector rows;
    private Vector param = new Vector();
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private String tableName;
    private boolean executeCalled = false;
    private boolean driverManagerInitialized = false;
    private static final int MAX_CHAR_BUFFER_SIZE = 1024;
    private static final int MAX_BYTE_BUFFER_SIZE = 1024;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:16:40_PDT_2010";
    public static final boolean TRACE = false;

    public OracleCachedRowSet() throws SQLException {
        this.rows = new Vector();
        this.sqlWarning = new SQLWarning();
        try {
            this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
        }
        catch (SyncFactoryException syncFactoryException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 304);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setReader(new OracleCachedRowSetReader());
        this.setWriter(new OracleCachedRowSetWriter());
        this.currentPage = 0;
        this.pageSize = 0;
        this.isPopulateDone = false;
        this.keyColumns = null;
        this.tableName = null;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionInternal();
    }

    Connection getConnectionInternal() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            if (this.getDataSourceName() != null) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(this.getDataSourceName());
                    if (this.username == null || string2 == null) {
                        this.connection = object.getConnection();
                    }
                    this.connection = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 300, namingException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else if (this.getUrl() != null) {
                String string3;
                if (!this.driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    this.driverManagerInitialized = true;
                }
                if ((string3 = this.getUrl()).equals("") || string.equals("") || string2.equals("")) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.connection = DriverManager.getConnection(string3, string, string2);
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return this.connection;
    }

    public Statement getStatement() throws SQLException {
        if (this.resultSet == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 305);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.resultSet.getStatement();
    }

    public RowSetReader getReader() {
        return this.reader;
    }

    public RowSetWriter getWriter() {
        return this.writer;
    }

    public void setFetchDirection(int n2) throws SQLException {
        if (this.rowsetType == 1005) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 306);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        switch (n2) {
            case 1000: 
            case 1002: {
                this.presentRow = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 307);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.presentRow = this.rowCount + 1;
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 308);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        super.setFetchDirection(n2);
    }

    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        this.osql = string == null || string.equals("") ? null : new OracleSqlForRowSet(string);
    }

    public void setReader(RowSetReader rowSetReader) {
        this.reader = rowSetReader;
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.writer = rowSetWriter;
    }

    private final int getColumnIndex(String string) throws SQLException {
        int n2;
        if (string == null || string.equals("")) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        string = string.toUpperCase();
        for (n2 = 0; n2 < this.metaData.length && !string.equals(this.metaData[n2]); ++n2) {
        }
        if (n2 >= this.metaData.length) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2 + 1;
    }

    private final void checkColumnIndex(int n2) throws SQLException {
        if (this.readOnly) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 1 || n2 > this.colCount) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private final boolean isUpdated(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    private final void checkParamIndex(int n2) throws SQLException {
        if (n2 < 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 310, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
        this.presentRow = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized InputStream getStream(int n2) throws SQLException {
        PipedInputStream pipedInputStream2;
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        if (!(object instanceof Reader)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 312);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        BufferedReader bufferedReader = null;
        PipedOutputStream pipedOutputStream = null;
        try {
            try {
                bufferedReader = new BufferedReader((Reader)object);
                int n3 = 0;
                PipedInputStream pipedInputStream = new PipedInputStream();
                pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n3 = ((Reader)bufferedReader).read()) != -1) {
                    pipedOutputStream.write(n3);
                }
                pipedInputStream2 = pipedInputStream;
                Object var9_11 = null;
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (bufferedReader != null) {
                    ((Reader)bufferedReader).close();
                }
            }
            catch (IOException iOException2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException2.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                if (pipedOutputStream == null) throw throwable;
                pipedOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException3) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException3.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        try {}
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bufferedReader != null) {
            ((Reader)bufferedReader).close();
        }
        try {}
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (pipedOutputStream == null) return pipedInputStream2;
        pipedOutputStream.close();
        return pipedInputStream2;
    }

    private final Calendar getSessionCalendar(Connection connection) {
        Calendar calendar;
        String string = ((OracleConnection)connection).getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setID(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    private boolean isStreamType(int n2) {
        return n2 == 2004 || n2 == 2005 || n2 == -4 || n2 == -1;
    }

    protected synchronized void notifyCursorMoved() {
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                int n2 = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n2;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
    }

    OracleRow getCurrentRow() throws SQLException {
        int n2 = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    boolean isExecuteCalled() {
        return this.executeCalled;
    }

    int getCurrentPage() {
        return this.currentPage;
    }

    boolean isConnectionStayingOpen() {
        return this.isConnectionStayingOpenForTxnControl;
    }

    void setOriginal() throws SQLException {
        int n2 = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalRowInternal(n2)) continue;
            ++n2;
        } while (n2 <= this.rowCount);
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    boolean setOriginalRowInternal(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.rowCount) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = false;
        OracleRow oracleRow = (OracleRow)this.rows.elementAt(n2 - 1);
        if (oracleRow.isRowDeleted()) {
            this.rows.remove(n2 - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (oracleRow.isRowInserted()) {
                oracleRow.setInsertedFlag(false);
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.makeUpdatesOriginal();
            }
        }
        return bl;
    }

    public boolean next() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowCount > 0 && this.presentRow == 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowCount > 0 && this.presentRow == this.rowCount + 1;
    }

    public boolean isFirst() throws SQLException {
        return this.presentRow == 1;
    }

    public boolean isLast() throws SQLException {
        return this.presentRow == this.rowCount;
    }

    public void beforeFirst() throws SQLException {
        this.presentRow = 0;
    }

    public void afterLast() throws SQLException {
        this.presentRow = this.rowCount + 1;
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public boolean absolute(int n2) throws SQLException {
        if (this.rowsetType == 1003) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 314);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        this.presentRow = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.notifyCursorMoved();
        return true;
    }

    public boolean relative(int n2) throws SQLException {
        return this.absolute(this.presentRow + n2);
    }

    public synchronized void populate(ResultSet resultSet) throws SQLException {
        int n2;
        if (this.rows == null) {
            this.rows = new Vector(50, 10);
        } else {
            this.rows.clear();
        }
        this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
        this.colCount = this.rowsetMetaData.getColumnCount();
        this.metaData = new String[this.colCount];
        for (n2 = 0; n2 < this.colCount; ++n2) {
            this.metaData[n2] = this.rowsetMetaData.getColumnName(n2 + 1);
        }
        if (!(resultSet instanceof OracleCachedRowSet)) {
            this.populateInit(resultSet);
        }
        n2 = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
        this.rowCount = 0;
        OracleRow oracleRow = null;
        int n3 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (resultSet.getType() != 1003 && this.rows.size() == 0 && n2 == 0) {
            resultSet.afterLast();
        }
        boolean bl = false;
        while (this.rowCount < n3) {
            if (n2 != 0) {
                if (!resultSet.next()) {
                    bl = true;
                    break;
                }
            } else if (!resultSet.previous()) {
                bl = true;
                break;
            }
            oracleRow = new OracleRow(this.colCount);
            for (int i2 = 1; i2 <= this.colCount; ++i2) {
                Object object = null;
                try {
                    object = resultSet.getObject(i2, this.typeMap);
                }
                catch (Exception exception) {
                    object = resultSet.getObject(i2);
                }
                catch (AbstractMethodError abstractMethodError) {
                    object = resultSet.getObject(i2);
                }
                if (object instanceof Clob || object instanceof CLOB) {
                    oracleRow.setColumnValue(i2, new OracleSerialClob((Clob)object));
                } else if (object instanceof Blob || object instanceof BLOB) {
                    oracleRow.setColumnValue(i2, new OracleSerialBlob((Blob)object));
                } else {
                    oracleRow.setColumnValue(i2, object);
                }
                oracleRow.markOriginalNull(i2, resultSet.wasNull());
            }
            if (n2 != 0) {
                this.rows.add(oracleRow);
            } else {
                this.rows.add(1, oracleRow);
            }
            ++this.rowCount;
        }
        if (bl || n2 != 0 && resultSet.isAfterLast() || n2 == 0 && resultSet.isBeforeFirst()) {
            this.isPopulateDone = true;
        }
        this.connection = null;
        this.notifyRowSetChanged();
    }

    public String getCursorName() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public synchronized void clearParameters() throws SQLException {
        this.param = null;
        this.param = new Vector();
    }

    public boolean wasNull() throws SQLException {
        return this.previousColumnWasNull;
    }

    public void close() throws SQLException {
        this.release();
        this.isClosed = true;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    public int findColumn(String string) throws SQLException {
        return this.getColumnIndex(string);
    }

    public Object[] getParams() throws SQLException {
        return this.param.toArray();
    }

    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowsetMetaData = rowSetMetaData;
        if (rowSetMetaData != null) {
            this.colCount = rowSetMetaData.getColumnCount();
        }
    }

    public synchronized void execute() throws SQLException {
        this.isConnectionStayingOpenForTxnControl = false;
        this.getReader().readData(this);
        this.executeCalled = true;
    }

    public void acceptChanges() throws SyncProviderException {
        try {
            this.getWriter().writeData(this);
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException(sQLException.getMessage());
        }
    }

    public void acceptChanges(Connection connection) throws SyncProviderException {
        this.connection = connection;
        this.isConnectionStayingOpenForTxnControl = true;
        this.acceptChanges();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("SQL Error occured while cloning: " + sQLException.getMessage());
        }
    }

    public CachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createShared();
        int n2 = this.rows.size();
        oracleCachedRowSet.rows = new Vector(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            oracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(i2)).createCopy());
        }
        return oracleCachedRowSet;
    }

    public RowSet createShared() throws SQLException {
        int n2;
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rows = this.rows;
        oracleCachedRowSet.setDataSource(this.getDataSource());
        oracleCachedRowSet.setDataSourceName(this.getDataSourceName());
        oracleCachedRowSet.setUsername(this.getUsername());
        oracleCachedRowSet.setPassword(this.getPassword());
        oracleCachedRowSet.setUrl(this.getUrl());
        oracleCachedRowSet.setTypeMap(this.getTypeMap());
        oracleCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        oracleCachedRowSet.setMaxRows(this.getMaxRows());
        oracleCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        oracleCachedRowSet.setFetchSize(this.getFetchSize());
        oracleCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        oracleCachedRowSet.setConcurrency(this.getConcurrency());
        oracleCachedRowSet.setReadOnly(this.readOnly);
        this.rowsetType = this.getType();
        this.fetchDirection = this.getFetchDirection();
        oracleCachedRowSet.setCommand(this.getCommand());
        oracleCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        oracleCachedRowSet.presentRow = this.presentRow;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.showDeleted = this.showDeleted;
        oracleCachedRowSet.syncProvider = this.syncProvider;
        oracleCachedRowSet.currentPage = this.currentPage;
        oracleCachedRowSet.pageSize = this.pageSize;
        oracleCachedRowSet.tableName = this.tableName == null ? null : this.tableName;
        oracleCachedRowSet.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
        int n3 = this.listener.size();
        for (n2 = 0; n2 < n3; ++n2) {
            oracleCachedRowSet.listener.add(this.listener.elementAt(n2));
        }
        oracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
        n3 = this.param.size();
        for (n2 = 0; n2 < n3; ++n2) {
            oracleCachedRowSet.param.add(this.param.elementAt(n2));
        }
        oracleCachedRowSet.metaData = new String[this.metaData.length];
        System.arraycopy(this.metaData, 0, oracleCachedRowSet.metaData, 0, this.metaData.length);
        return oracleCachedRowSet;
    }

    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.rowCount = 0;
        this.presentRow = 0;
        this.notifyRowSetChanged();
    }

    public void restoreOriginal() throws SQLException {
        boolean bl = false;
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
            if (oracleRow.isRowInserted()) {
                this.rows.remove(i2);
                --this.rowCount;
                --i2;
                bl = true;
                continue;
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.setRowUpdated(false);
                bl = true;
                continue;
            }
            if (!oracleRow.isRowDeleted()) continue;
            oracleRow.setRowDeleted(false);
            bl = true;
        }
        if (!bl) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 315);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    public Collection toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                map.put(i2, ((OracleRow)this.rows.elementAt(i2)).toCollection());
            }
        }
        catch (Exception exception) {
            map = null;
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 316);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return map.values();
    }

    public Collection toCollection(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
            Object object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
            vector.add(object);
        }
        return vector;
    }

    public Collection toCollection(String string) throws SQLException {
        return this.toCollection(this.getColumnIndex(string));
    }

    public int getRow() throws SQLException {
        if (this.presentRow > this.rowCount) {
            return this.rowCount;
        }
        return this.presentRow;
    }

    public void cancelRowInsert() throws SQLException {
        if (this.getCurrentRow().isRowInserted()) {
            this.rows.remove(--this.presentRow);
            --this.rowCount;
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.notifyRowChanged();
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getCurrentRow().isRowDeleted()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 318);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getCurrentRow().setRowDeleted(false);
        this.notifyRowChanged();
    }

    public void cancelRowUpdates() throws SQLException {
        if (!this.getCurrentRow().isRowUpdated()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(false);
        this.notifyRowChanged();
    }

    public void insertRow() throws SQLException {
        if (this.isReadOnly()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.insertRowFlag) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.insertRow.isRowFullyPopulated()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 320);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.insertRow.insertRow();
        this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
        this.insertRowFlag = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    public void updateRow() throws SQLException {
        if (this.isReadOnly()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.updateRowFlag) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(true);
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        if (this.isReadOnly()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    public void refreshRow() throws SQLException {
        OracleRow oracleRow = this.getCurrentRow();
        if (oracleRow.isRowUpdated()) {
            oracleRow.cancelRowUpdates();
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this.isReadOnly()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.insertRow = new OracleRow(this.colCount, true);
        this.insertRowFlag = true;
        this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.isReadOnly()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.insertRowFlag = false;
        this.updateRowFlag = false;
        this.absolute(this.presentRow);
    }

    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = 1;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        OracleRow oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        oracleCachedRowSet.rows.add(oracleRow);
        return oracleCachedRowSet;
    }

    public ResultSet getOriginal() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setType(1004);
        oracleCachedRowSet.setConcurrency(1008);
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        int n2 = this.rowsetMetaData.getColumnCount();
        OracleRow oracleRow = null;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            oracleRow = new OracleRow(n2, ((OracleRow)iterator.next()).getOriginalRow());
            oracleCachedRowSet.rows.add(oracleRow);
        }
        return oracleCachedRowSet;
    }

    public void setNull(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, null);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{n3, string};
        this.param.add(n2 - 1, objectArray);
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, bl);
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Byte(by));
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, s2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, l2);
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, Float.valueOf(f2));
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, d2);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, bigDecimal);
    }

    public void setString(int n2, String string) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, string);
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, byArray);
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, date);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, time);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, object);
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, ref);
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, blob);
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, clob);
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, array);
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, n3, 2};
        this.param.add(n2 - 1, objectArray);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{time, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, timestamp);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, n3, 3};
        this.param.add(n2 - 1, objectArray);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, n3, 1};
        this.param.add(n2 - 1, objectArray);
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, n3, 4};
        this.param.add(n2 - 1, objectArray);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, n3, n4};
        this.param.add(n2 - 1, objectArray);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, n3};
        this.param.add(n2 - 1, objectArray);
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{date, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, uRL.toString());
    }

    public synchronized Object getObject(int n2) throws SQLException {
        int n3 = this.presentRow * this.colCount + n2 - 1;
        Object object = null;
        object = !this.isUpdated(n2) ? this.getCurrentRow().getColumn(n2) : this.getCurrentRow().getModifiedColumn(n2);
        this.previousColumnWasNull = object == null;
        return object;
    }

    private synchronized Number getNumber(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public byte getByte(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return 0;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(new BigDecimal(127)) == 1 || bigDecimal.compareTo(new BigDecimal(-128)) == -1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return bigDecimal.byteValue();
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(1L, 1)[0];
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(1L, 1).getBytes()[0];
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public short getShort(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? (short)0 : number.shortValue();
    }

    public int getInt(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0 : number.intValue();
    }

    public long getLong(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0L : number.longValue();
    }

    public float getFloat(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0f : number.floatValue();
    }

    public double getDouble(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0 : number.doubleValue();
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        if (number == null || number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.doubleValue());
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getBigDecimal(n2);
    }

    public Date getDate(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (Date)object;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            return new Date(time.getTime());
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Date(date.getYear(), date.getMonth(), date.getDate());
        }
        if (object instanceof TIMESTAMP) {
            return ((TIMESTAMP)object).dateValue();
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).dateValue(this.getConnectionInternal());
        }
        if (object instanceof TIMESTAMPLTZ) {
            Connection connection = this.getConnectionInternal();
            return ((TIMESTAMPLTZ)object).dateValue(connection, this.getSessionCalendar(connection));
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    public Time getTime(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Time(date.getHours(), date.getMinutes(), date.getSeconds());
        }
        if (object instanceof TIMESTAMP) {
            return ((TIMESTAMP)object).timeValue();
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).timeValue(this.getConnectionInternal());
        }
        if (object instanceof TIMESTAMPLTZ) {
            Connection connection = this.getConnectionInternal();
            return ((TIMESTAMPLTZ)object).timeValue(connection, this.getSessionCalendar(connection));
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        if (object instanceof TIMESTAMP) {
            return ((TIMESTAMP)object).timestampValue();
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).timestampValue(this.getConnectionInternal());
        }
        if (object instanceof TIMESTAMPLTZ) {
            Connection connection = this.getConnectionInternal();
            return ((TIMESTAMPLTZ)object).timestampValue(connection, this.getSessionCalendar(connection));
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (byte[])object;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return ((Number)object).toString().getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length());
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(1L, (int)oracleSerialClob.length()).getBytes();
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Ref getRef(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Ref) {
            return (Ref)object;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Blob getBlob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof OracleSerialBlob) {
            return (Blob)object;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Clob getClob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof OracleSerialClob) {
            return (Clob)object;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Array getArray(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Array) {
            return (Array)object;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public String getString(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (String)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof Date) {
            return object.toString();
        }
        if (object instanceof Timestamp) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(1L, (int)oracleSerialClob.length());
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return new String(oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length()));
        }
        if (object instanceof URL) {
            return ((URL)object).toString();
        }
        if (object instanceof ROWID) {
            return ((ROWID)object).stringValue();
        }
        if (object instanceof Reader) {
            try {
                Reader reader = (Reader)object;
                char[] cArray = new char[1024];
                int n3 = 0;
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((n3 = reader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n3);
                }
                return stringBuffer.substring(0, stringBuffer.length());
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 321, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        try {
            InputStream inputStream = this.getAsciiStream(n2);
            if (inputStream == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while ((n3 = inputStream.read()) != -1) {
                stringBuffer.append((char)n3);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            cArray = null;
            return charArrayReader;
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 322);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnIndex(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnIndex(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnIndex(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnIndex(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnIndex(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnIndex(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnIndex(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string), n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnIndex(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnIndex(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnIndex(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnIndex(string), calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnIndex(string), calendar);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(string));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnIndex(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(string));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string), calendar);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.getColumnIndex(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColumnIndex(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnIndex(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnIndex(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColumnIndex(string));
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.updateObject(n2, object, (int[])null);
    }

    protected synchronized void updateObject(int n2, Object object, int[] nArray) throws SQLException {
        this.checkColumnIndex(n2);
        if (this.insertRowFlag) {
            this.checkAndFilterObject(n2, object);
            this.insertRow.updateObject(n2, object, nArray);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.updateRowFlag = true;
            this.updateRowPosition = this.presentRow;
            this.getCurrentRow().updateObject(n2, object, nArray);
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public void updateNull(int n2) throws SQLException {
        this.updateObject(n2, null);
    }

    public synchronized void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.updateCharacterStreamInternal(n2, reader, n3, false);
    }

    void updateCharacterStreamInternal(int n2, Reader reader, int n3, boolean bl) throws SQLException {
        this.checkColumnIndex(n2);
        if (n3 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n4)) {
            try {
                int n5;
                int n6 = 0;
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder(1024);
                for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? reader.read(cArray) : reader.read(cArray, 0, n5)) != -1; n5 -= n6) {
                    stringBuilder.append(cArray, 0, n6);
                }
                reader.close();
                if (n5 == n3) {
                    this.updateNull(n2);
                    return;
                }
                this.updateString(n2, stringBuilder.toString());
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            int n7 = bl ? 4 : 3;
            int[] nArray = new int[]{n3, n7};
            this.updateObject(n2, (Object)reader, nArray);
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader, n2);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnIndex(string), timestamp);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, n2);
    }

    public synchronized void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkColumnIndex(n2);
        if (n3 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n4)) {
            try {
                int n5;
                int n6 = 0;
                byte[] byArray = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                    byteArrayOutputStream.write(byArray, 0, n6);
                }
                inputStream.close();
                if (n5 == n3) {
                    this.updateNull(n2);
                    return;
                }
                this.updateBytes(n2, byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            int[] nArray = new int[]{n3, 2};
            this.updateObject(n2, (Object)inputStream, nArray);
        }
    }

    public synchronized void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkColumnIndex(n2);
        if (n3 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n4)) {
            try {
                int n5;
                int n6 = 0;
                byte[] byArray = new byte[1024];
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder(1024);
                for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                    DBConversion.asciiBytesToJavaChars(byArray, n6, cArray);
                    stringBuilder.append(cArray, 0, n6);
                }
                inputStream.close();
                if (n5 == n3) {
                    this.updateNull(n2);
                    return;
                }
                this.updateString(n2, stringBuilder.toString());
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            int[] nArray = new int[]{n3, 1};
            this.updateObject(n2, (Object)inputStream, nArray);
        }
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.updateObject(n2, (Object)bl);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)new Byte(by));
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)s2);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)n3);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)l2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)Float.valueOf(f2));
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)d2);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    public void updateString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        if (!(object instanceof Number)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.updateObject(n2, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n3));
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnIndex(string));
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, n2);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColumnIndex(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnIndex(string), by);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.getColumnIndex(string), s2);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.getColumnIndex(string), n2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.getColumnIndex(string), l2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.getColumnIndex(string), f2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.getColumnIndex(string), d2);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnIndex(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnIndex(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnIndex(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnIndex(string), time);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object, n2);
    }

    public URL getURL(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (URL)object;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object instanceof String) {
            try {
                return new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.getColumnIndex(string));
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateObject(n2, (Object)ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.getColumnIndex(string), ref);
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateObject(n2, (Object)blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), blob);
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateObject(n2, (Object)clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColumnIndex(string), clob);
    }

    public void updateArray(int n2, Array array) throws SQLException {
        this.updateObject(n2, (Object)array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.getColumnIndex(string), array);
    }

    public int[] getKeyColumns() throws SQLException {
        return this.keyColumns;
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        int n2 = 0;
        if (this.rowsetMetaData != null) {
            n2 = this.rowsetMetaData.getColumnCount();
            if (nArray == null || nArray.length > n2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 324);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        int n3 = nArray.length;
        this.keyColumns = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] <= 0 || nArray[i2] > n2) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + nArray[i2]);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.keyColumns[i2] = nArray[i2];
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n2) throws SQLException {
        if (n2 < 0 || this.maxRows > 0 && n2 > this.maxRows) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 325);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.pageSize = n2;
    }

    public SyncProvider getSyncProvider() throws SQLException {
        return this.syncProvider;
    }

    public void setSyncProvider(String string) throws SQLException {
        this.syncProvider = SyncFactory.getInstance(string);
        this.reader = this.syncProvider.getRowSetReader();
        this.writer = this.syncProvider.getRowSetWriter();
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public void setTableName(String string) throws SQLException {
        this.tableName = string;
    }

    public CachedRowSet createCopyNoConstraints() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.initializeProperties();
        oracleCachedRowSet.listener = new Vector();
        try {
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return oracleCachedRowSet;
    }

    public CachedRowSet createCopySchema() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.rows = null;
        oracleCachedRowSet.rowCount = 0;
        oracleCachedRowSet.currentPage = 0;
        return oracleCachedRowSet;
    }

    public boolean columnUpdated(int n2) throws SQLException {
        if (this.insertRowFlag) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 326);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getColumnIndex(string));
    }

    public synchronized void execute(Connection connection) throws SQLException {
        this.connection = connection;
        this.execute();
    }

    public void commit() throws SQLException {
        this.getConnectionInternal().commit();
    }

    public void rollback() throws SQLException {
        this.getConnectionInternal().rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        Connection connection = this.getConnectionInternal();
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            connection.rollback(savepoint);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            connection.setAutoCommit(bl);
            throw throwable;
        }
        connection.setAutoCommit(bl);
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        ((OracleConnection)this.getConnectionInternal()).oracleRollback(oracleSavepoint);
    }

    public void setOriginalRow() throws SQLException {
        if (this.insertRowFlag) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 327);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setOriginalRowInternal(this.presentRow);
    }

    public int size() {
        return this.rowCount;
    }

    public boolean nextPage() throws SQLException {
        if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if ((this.isExecuteCalled() || this.isPopulateDone) && this.rowCount < this.pageSize) {
            return false;
        }
        if (this.isExecuteCalled()) {
            ++this.currentPage;
            this.execute();
        } else {
            this.populate(this.resultSet);
            ++this.currentPage;
        }
        return !this.isPopulateDone;
    }

    public boolean previousPage() throws SQLException {
        if (this.resultSet != null && this.resultSet.getType() == 1003) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.currentPage == 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            this.resultSet.relative(this.pageSize * 2);
        } else {
            this.resultSet.relative(-2 * this.pageSize);
        }
        this.populate(this.resultSet);
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        return this.currentPage != 0;
    }

    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) throws SQLException {
        if (n2 <= 0 || n2 < this.fetchSize) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 330);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowCount % n2 == 0) {
            this.rowsetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.rowsetWarning;
    }

    public void populate(ResultSet resultSet, int n2) throws SQLException {
        if (n2 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 331);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (resultSet == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 332);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n3 = resultSet.getType();
        if (n3 == 1003) {
            int n4;
            boolean bl = false;
            for (n4 = 0; n4 < n2; ++n4) {
                if (resultSet.next()) continue;
                bl = true;
                break;
            }
            if (n4 < n2 && n2 > 0 && bl) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 333);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else if (n2 == 0) {
            resultSet.beforeFirst();
        } else {
            resultSet.absolute(n2);
        }
        this.populate(resultSet);
    }

    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }
}

