/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.common.shared.ProductProperties;
import org.hyperic.hq.plugin.netservices.SocketChecker;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.security.KeystoreConfig;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPCollector
extends SocketChecker {
    private static final Log log = LogFactory.getLog(HTTPCollector.class);
    private AtomicBoolean isPingCompat = new AtomicBoolean();
    private AtomicReference<String> url = new AtomicReference();
    private AtomicReference<String> method = new AtomicReference();
    private AtomicReference<String> hosthdr = new AtomicReference();
    private AtomicReference<String> useragent = new AtomicReference();
    private AtomicReference<Pattern> pattern = new AtomicReference();
    private List<String> matches = new ArrayList<String>();
    private AtomicReference<String> proxyHost = new AtomicReference();
    private AtomicInteger proxyPort = new AtomicInteger(8080);
    private AtomicReference<Map<String, String>> params = new AtomicReference();

    @Override
    protected void init() throws PluginException {
        String proxy;
        String pattern;
        super.init();
        Properties props = this.getProperties();
        boolean isSSL = this.isSSL();
        String protocol = props.getProperty("protocol", isSSL ? "https" : "http");
        this.isPingCompat.set(protocol.equals("ping"));
        if (this.isPingCompat.get()) {
            return;
        }
        this.method.set(props.getProperty("method", "HEAD"));
        this.hosthdr.set(props.getProperty("hostheader"));
        this.setParams(props);
        try {
            URL url = new URL(protocol, this.getHostname(), this.getPort(), this.getPath());
            this.url.set(url.toString());
        }
        catch (MalformedURLException e) {
            throw new PluginException((Throwable)e);
        }
        this.useragent.set(this.getPlugin().getManagerProperty("http.useragent"));
        if (this.useragent.get() == null || this.useragent.get().trim().length() == 0) {
            this.useragent.set("Hyperic-HQ-Agent/" + ProductProperties.getVersion());
        }
        this.setSource(this.url.get());
        if (isSSL) {
            try {
                this.getSocketWrapper(true);
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
        if ((pattern = props.getProperty("pattern")) != null) {
            this.pattern.set(Pattern.compile(pattern));
        }
        if ((proxy = props.getProperty("proxy")) != null) {
            this.setSource(this.getSource() + " [via " + proxy + "]");
            int ix = proxy.indexOf(58);
            if (ix != -1) {
                this.proxyPort.set(Integer.parseInt(proxy.substring(ix + 1)));
                proxy = proxy.substring(0, ix);
            }
            this.proxyHost.set(proxy);
        }
        this.collect();
        if (this.getLogLevel() == 3) {
            throw new PluginException(this.getMessage());
        }
    }

    protected String getURL() {
        return this.url.get();
    }

    protected void setURL(String url) {
        this.url.set(url);
    }

    protected String getMethod() {
        return this.method.get();
    }

    protected void setMethod(String method) {
        this.method.set(method);
    }

    private double getAvail(int code) {
        switch (code) {
            case 400: 
            case 403: 
            case 404: 
            case 405: 
            case 408: 
            case 409: 
            case 412: 
            case 413: 
            case 414: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                return 0.0;
            }
        }
        if (this.hasCredentials() && code == 401) {
            return 0.0;
        }
        return 1.0;
    }

    protected void parseResults(HttpResponse response) {
        Header length = response.getFirstHeader("Content-Length");
        Header type = response.getFirstHeader("Content-Type");
        if (type == null || !type.getValue().equals("text/plain")) {
            return;
        }
        if (length != null) {
            try {
                if (Integer.parseInt(length.getValue()) > 8192) {
                    return;
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        try {
            this.parseResults(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
        }
        catch (org.apache.http.ParseException e) {
            this.setErrorMessage("Exception parsing response: " + e.getMessage(), e);
        }
        catch (IOException e) {
            this.setErrorMessage("Exception reading response stream: " + e.getMessage(), e);
        }
    }

    private boolean matchResponse(HttpResponse response) {
        String body;
        try {
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            String string = body = body == null ? "" : body;
            if (log.isDebugEnabled()) {
                log.debug((Object)("attempting to match pattern=" + this.pattern.get() + " against response body=" + body));
            }
        }
        catch (org.apache.http.ParseException e) {
            this.setErrorMessage("Exception parsing response: " + (Object)((Object)e), e);
            return false;
        }
        catch (IOException e) {
            this.setErrorMessage("Exception reading response stream: " + e, e);
            return false;
        }
        Matcher matcher = this.pattern.get().matcher(body);
        boolean matches = false;
        while (matcher.find()) {
            matches = true;
            int count = matcher.groupCount();
            for (int i = 1; i <= count; ++i) {
                this.matches.add(matcher.group(i));
            }
        }
        if (matches) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("pattern='" + this.pattern.get() + "' matches"));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("pattern='" + this.pattern.get() + "' does not match"));
        }
        this.setWarningMessage("Response (length=" + body.length() + ") does not match " + this.pattern.get());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect() {
        if (this.isPingCompat.get()) {
            super.collect();
            return;
        }
        this.matches.clear();
        HttpConfig config = new HttpConfig(this.getTimeoutMillis(), this.getTimeoutMillis(), this.proxyHost.get(), this.proxyPort.get());
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig();
        log.debug((Object)("isAcceptUnverifiedCert:" + keystoreConfig.isAcceptUnverifiedCert()));
        HQHttpClient client = new HQHttpClient((KeystoreConfig)keystoreConfig, config, keystoreConfig.isAcceptUnverifiedCert());
        HttpParams params = client.getParams();
        params.setParameter("http.useragent", (Object)this.useragent.get());
        if (this.hosthdr != null) {
            params.setParameter("http.virtual-host", this.hosthdr);
        }
        double avail = 0.0;
        try {
            HttpHead request;
            if (this.getMethod().equals("HEAD")) {
                request = new HttpHead(this.getURL());
                this.addParams((HttpRequestBase)request, this.params.get());
            } else if (this.getMethod().equals("POST")) {
                HttpPost httpPost = new HttpPost(this.getURL());
                request = httpPost;
                this.addParams((HttpEntityEnclosingRequestBase)httpPost, this.params.get());
            } else {
                request = new HttpGet(this.getURL());
                this.addParams((HttpRequestBase)request, this.params.get());
            }
            request.getParams().setParameter("http.protocol.handle-redirects", (Object)this.isFollow());
            this.addCredentials((HttpMessage)request, (DefaultHttpClient)client);
            this.startTime();
            HttpResponse response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            for (int tries = 0; statusCode == 302 && tries < 3; ++tries) {
                Header header = response.getFirstHeader("Location");
                String url = header.getValue();
                String[] toks = url.split(";");
                String[] t = toks.length > 1 ? toks[1].split("\\?") : new String[]{};
                response = this.getRedirect(toks[0], t.length > 1 ? t[1] : "");
                statusCode = response.getStatusLine().getStatusCode();
            }
            this.endTime();
            this.setResponseCode(statusCode);
            avail = this.getAvail(statusCode);
            StringBuilder msg = new StringBuilder(String.valueOf(statusCode));
            Header header = response.getFirstHeader("Server");
            msg.append(header != null ? " (" + header.getValue() + ")" : "");
            this.setLastModified((HttpMessage)response, statusCode);
            avail = this.checkPattern(response, avail, msg);
            this.setAvailMsg(avail, msg);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("unsupported encoding: " + e), (Throwable)e);
        }
        catch (IOException e) {
            avail = 0.0;
            this.setErrorMessage(e.toString());
        }
        finally {
            this.setAvailability(avail);
        }
        this.netstat();
    }

    private void setAvailMsg(double avail, StringBuilder msg) {
        if (avail == 1.0) {
            if (this.matches.size() != 0) {
                this.setInfoMessage(msg.toString());
            } else {
                this.setDebugMessage(msg.toString());
            }
        } else if (avail == 0.5) {
            this.setWarningMessage(msg.toString());
        } else {
            this.setErrorMessage(msg.toString());
        }
    }

    private void setLastModified(HttpMessage response, int statusCode) {
        long lastModified = 0L;
        Header header = response.getFirstHeader("Last-Modified");
        if (header != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat();
                lastModified = format.parse(header.getValue()).getTime();
            }
            catch (ParseException e) {
                log.error((Object)e, (Throwable)e);
            }
        } else if (statusCode == 200) {
            lastModified = System.currentTimeMillis();
        }
        if (lastModified != 0L) {
            this.setValue("LastModified", lastModified);
        }
    }

    private double checkPattern(HttpResponse response, double avail, StringBuilder msg) {
        if (!this.getMethod().equals("HEAD") && avail == 1.0) {
            if (this.pattern.get() != null) {
                if (!this.matchResponse(response)) {
                    avail = 0.5;
                } else if (this.matches.size() != 0) {
                    msg.append(" match results=").append(this.matches);
                }
            } else {
                this.parseResults(response);
            }
        }
        return avail;
    }

    private Map<String, String> getArgs(String args) {
        String[] toks;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String t : toks = args.split("&")) {
            String[] pair = t.split("=");
            if (pair.length < 2) continue;
            params.put(pair[0], pair[1]);
        }
        return params;
    }

    private HttpResponse getRedirect(String url, String args) throws ClientProtocolException, IOException {
        HttpConfig config = new HttpConfig(this.getTimeoutMillis(), this.getTimeoutMillis(), this.proxyHost.get(), this.proxyPort.get());
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig();
        HQHttpClient client = new HQHttpClient((KeystoreConfig)keystoreConfig, config, keystoreConfig.isAcceptUnverifiedCert());
        HttpParams params = client.getParams();
        params.setParameter("http.useragent", (Object)this.useragent.get());
        if (this.hosthdr != null) {
            params.setParameter("http.virtual-host", this.hosthdr);
        }
        HttpGet request = new HttpGet(url);
        this.addParams((HttpRequestBase)request, this.getArgs(args));
        this.addCredentials((HttpMessage)request, (DefaultHttpClient)client);
        return client.execute((HttpUriRequest)request);
    }

    private void addCredentials(HttpMessage request, DefaultHttpClient client) {
        if (this.hasCredentials()) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getUsername(), this.getPassword());
            String realm = this.getProperties().getProperty("realm", "");
            if (realm.length() == 0) {
                boolean isProxied = StringUtils.hasText((String)this.proxyHost.get()) && this.proxyPort.get() != -1;
                Header authenticationHeader = BasicScheme.authenticate((Credentials)credentials, (String)"UTF-8", (boolean)isProxied);
                request.addHeader(authenticationHeader);
            } else {
                String authenticationHost = this.hosthdr.get() == null ? this.getHostname() : this.hosthdr.get();
                AuthScope authScope = new AuthScope(authenticationHost, -1, realm);
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
                request.getParams().setParameter("http.protocol.handle-authentication", (Object)true);
            }
        }
    }

    private void setParams(Properties props) {
        String[] toks;
        String secretparams = props.getProperty("secretrequestparams", "");
        String params = props.getProperty("requestparams", "") + "," + secretparams;
        if ((params = params.trim()).length() == 0 || params.equals(",")) {
            this.params.set(null);
            return;
        }
        this.params.set(new HashMap());
        for (String tok : toks = params.split(",")) {
            String[] pair = tok.split("=");
            if (pair.length != 2) {
                log.warn((Object)("specified params do not match the proper pattern: " + tok));
                continue;
            }
            this.params.get().put(pair[0], pair[1]);
        }
    }

    private void addParams(HttpRequestBase request, Map<String, String> params) throws UnsupportedEncodingException {
        if (params != null && !params.isEmpty()) {
            BasicHttpParams prms = new BasicHttpParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                prms.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            request.setParams((HttpParams)prms);
        }
    }

    private void addParams(HttpEntityEnclosingRequestBase request, Map<String, String> params) throws UnsupportedEncodingException {
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
            BasicHttpParams prms = new BasicHttpParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                postParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                prms.setParameter(entry.getKey(), (Object)entry.getValue());
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, "UTF-8"));
            request.setParams((HttpParams)prms);
        }
    }
}

