/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.plugin.netservices.SocketWrapper;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;

public abstract class NetServicesCollector
extends Collector {
    private static Log log = LogFactory.getLog(NetServicesCollector.class);
    private int port = -1;
    private int defaultPort;
    private int defaultSSLPort;
    private boolean isSSL;
    private boolean enableNetstat;
    private String sslProtcol;
    private AgentKeystoreConfig keystoreConfig;
    private String user;
    private String pass;
    private boolean hasCredentials;
    private static Sigar sigar = null;

    protected int getDefaultTimeout() {
        return 10;
    }

    protected String getPropTimeout() {
        return "sotimeout";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void netstat() {
        NetStat netstat;
        if (!this.enableNetstat) {
            return;
        }
        InetSocketAddress saddr = this.getSocketAddress();
        byte[] address = saddr.getAddress().getAddress();
        int port = saddr.getPort();
        Sigar sigar = NetServicesCollector.sigar;
        synchronized (sigar) {
            try {
                netstat = NetServicesCollector.sigar.getNetStat(address, (long)port);
            }
            catch (SigarException e) {
                return;
            }
        }
        this.setValue("InboundConnections", netstat.getTcpInboundTotal());
        this.setValue("OutboundConnections", netstat.getTcpOutboundTotal());
        this.setValue("AllInboundConnections", netstat.getAllInboundTotal());
        this.setValue("AllOutboundConnections", netstat.getAllOutboundTotal());
        int[] states = netstat.getTcpStates();
        for (int i = 0; i < states.length; ++i) {
            this.setValue("State" + NetConnection.getStateString((int)i), states[i]);
        }
    }

    protected void init() throws PluginException {
        Properties props = this.getProperties();
        this.keystoreConfig = new AgentKeystoreConfig();
        this.enableNetstat = this.getPlugin().isNetStatEnabled();
        if (this.enableNetstat && sigar == null) {
            sigar = new Sigar();
        }
        try {
            this.getHostAddress();
        }
        catch (Exception e) {
            throw new PluginException("Invalid hostname=" + this.getHostname(), (Throwable)e);
        }
        this.user = props.getProperty("user");
        this.pass = props.getProperty("pass");
        boolean bl = this.hasCredentials = this.user != null || this.pass != null;
        if (this.hasCredentials) {
            if (this.user == null) {
                throw new PluginException("Missing user");
            }
            if (this.pass == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Password was null, setting to empty string.");
                }
                this.pass = "";
            }
        }
        this.defaultPort = this.getIntegerTypeProperty("port");
        this.defaultSSLPort = this.getIntegerTypeProperty("sslport");
        this.isSSL = "true".equals(props.getProperty("ssl")) || "https".equals(props.getProperty("protocol"));
        this.sslProtcol = props.getProperty("sslprotocol");
        if (this.sslProtcol != null) {
            this.isSSL = !this.sslProtcol.equalsIgnoreCase("none");
        } else {
            this.sslProtcol = "TLS";
        }
    }

    public abstract void collect();

    public boolean isPoolable() {
        return true;
    }

    public String getHostname() {
        return this.getProperties().getProperty("hostname", "localhost");
    }

    protected int getIntegerTypeProperty(String key) {
        String val = this.getPlugin().getTypeProperty(key);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return -1;
    }

    protected int getDefaultPort() {
        return this.isSSL() ? this.defaultSSLPort : this.defaultPort;
    }

    public int getPort() {
        if (this.port == -1) {
            this.port = this.getIntegerProperty("port", this.getDefaultPort());
        }
        return this.port;
    }

    public String getUsername() {
        return this.user;
    }

    public String getPassword() {
        return this.pass;
    }

    public boolean hasCredentials() {
        return this.hasCredentials;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public String getSSLProtocol() {
        return this.sslProtcol;
    }

    public boolean isFollow() {
        return "true".equals(this.getProperties().getProperty("follow"));
    }

    public String getPath() {
        return this.getProperties().getProperty("path", "/");
    }

    public InetSocketAddress getSocketAddress() {
        String host = this.getHostname();
        int port = this.getPort();
        if (this.getSource() == null) {
            this.setSource(host + ":" + port);
        }
        InetSocketAddress saddr = new InetSocketAddress(host, port);
        return saddr;
    }

    public String getHostAddress() {
        return this.getSocketAddress().getAddress().getHostAddress();
    }

    public SocketWrapper getSocketWrapper() throws IOException {
        return this.getSocketWrapper(false);
    }

    protected void connect(Socket socket) throws IOException {
        InetSocketAddress saddr = this.getSocketAddress();
        try {
            socket.connect(saddr, this.getTimeoutMillis());
            socket.setSoTimeout(this.getTimeoutMillis());
            this.setMessage("OK");
        }
        catch (IOException e) {
            this.setMessage("connect " + saddr, e);
            throw e;
        }
    }

    public SocketWrapper getSocketWrapper(boolean acceptUnverifiedCertificatesOverride) throws IOException {
        if (this.isSSL()) {
            boolean accept = acceptUnverifiedCertificatesOverride ? true : this.keystoreConfig.isAcceptUnverifiedCert();
            DefaultSSLProviderImpl sslProvider = new DefaultSSLProviderImpl((KeystoreConfig)this.keystoreConfig, accept);
            SSLSocketFactory factory = sslProvider.getSSLSocketFactory();
            Socket socket = factory.createSocket();
            socket.connect(this.getSocketAddress(), this.getTimeoutMillis());
            socket.setSoTimeout(this.getTimeoutMillis());
            ((SSLSocket)socket).startHandshake();
            return new SocketWrapper(socket);
        }
        Socket socket = new Socket();
        this.connect(socket);
        return new SocketWrapper(socket);
    }
}

