/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.io.IOException;
import org.hyperic.hq.plugin.netservices.SocketChecker;
import org.hyperic.hq.plugin.netservices.SocketWrapper;

public class POP3Collector
extends SocketChecker {
    private static final String OK = "+OK";
    private static final String ERR = "-ERR";

    private boolean isOK(String line) {
        return line.startsWith(OK);
    }

    private boolean isERR(String line) {
        return line.startsWith(ERR);
    }

    private String getERR(String line) {
        return line.substring(ERR.length());
    }

    private boolean sendCommand(SocketWrapper socket, String cmd) throws IOException {
        return this.sendCommand(socket, cmd, null);
    }

    private boolean sendCommand(SocketWrapper socket, String cmd, String val) throws IOException {
        String line;
        if (val != null) {
            cmd = cmd + " " + val;
        }
        socket.writeLine(cmd);
        try {
            line = socket.readLine();
        }
        catch (IOException e) {
            this.setErrorMessage("Reading " + cmd + " response", e);
            return false;
        }
        if (this.isOK(line)) {
            return true;
        }
        if (this.isERR(line)) {
            this.setErrorMessage(this.getERR(line));
            return false;
        }
        this.setErrorMessage("Unexpected " + cmd + " response: " + line);
        return false;
    }

    protected boolean check(SocketWrapper socket) throws IOException {
        String line;
        try {
            line = socket.readLine();
            this.setDebugMessage(line);
        }
        catch (IOException e) {
            this.setErrorMessage("Failed to read welcome banner", e);
            throw e;
        }
        if (!this.isOK(line)) {
            this.setErrorMessage("Unexpected welcome response: " + line);
            return false;
        }
        if (this.hasCredentials()) {
            int ix;
            if (!this.sendCommand(socket, "USER", this.getUsername())) {
                return false;
            }
            if (!this.sendCommand(socket, "PASS", this.getPassword())) {
                return false;
            }
            if (!this.sendCommand(socket, "LIST")) {
                return false;
            }
            String msgs = null;
            while ((line = socket.readLine()) != null && !line.startsWith(".")) {
                msgs = line;
            }
            int num = 0;
            if (msgs != null && (ix = msgs.indexOf(32)) != -1) {
                msgs = msgs.substring(0, ix);
                num = Integer.parseInt(msgs);
            }
            this.setValue("NumberOfMessages", num);
        }
        return this.sendCommand(socket, "QUIT");
    }
}

