/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netservices;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.hq.plugin.netservices.NetServicesCollector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.RPC;
import org.hyperic.sigar.SigarException;

public class RPCCollector
extends NetServicesCollector {
    static final String RPC_VERSION = "2";
    static final String PROGRAM_NFS = "nfs";
    private static final Map PROGRAMS = new HashMap();
    private int[] protocol;
    private long program;
    private long version;

    protected void init() throws PluginException {
        if (GenericPlugin.isWin32()) {
            String msg = "This service is not supported on Windows";
            throw new PluginException(msg);
        }
        super.init();
        String program = this.getProperties().getProperty("program");
        Long pnum = (Long)PROGRAMS.get(program);
        this.program = pnum != null ? pnum : RPC.getProgram((String)program);
        String version = this.getProperties().getProperty("version");
        try {
            this.version = Long.parseLong(version);
        }
        catch (NumberFormatException e) {
            this.version = 2L;
        }
        this.setSource("portmapper@" + this.getHostname());
        String propProto = "rpc." + program + "." + "protocol";
        String proto = this.getPlugin().getManagerProperty(propProto);
        if (proto == null) {
            proto = this.getProperties().getProperty("protocol", "any");
        }
        if (proto.equals("any")) {
            this.protocol = new int[]{16, 32};
        } else {
            try {
                this.protocol = new int[]{NetFlags.getConnectionProtocol((String)proto)};
            }
            catch (SigarException e) {
                throw new PluginException(e.getMessage());
            }
        }
    }

    private String getConnectionProtocol(int proto) {
        switch (proto) {
            case 16: {
                return "tcp";
            }
            case 32: {
                return "udp";
            }
        }
        return "unknown";
    }

    public void collect() {
        String address;
        this.startTime();
        try {
            address = InetAddress.getByName(this.getHostname()).getHostAddress();
        }
        catch (UnknownHostException e) {
            this.setAvailability(false);
            this.setErrorMessage(e.getMessage());
            return;
        }
        for (int i = 0; i < this.protocol.length; ++i) {
            int proto = this.protocol[i];
            int rc = RPC.ping((String)address, (int)proto, (long)this.program, (long)this.version);
            if (rc == 0) {
                this.endTime();
                this.setAvailability(true);
                String msg = this.getConnectionProtocol(proto) + " program " + this.program + " version " + this.version + " ready and waiting";
                this.setInfoMessage(msg);
                break;
            }
            this.setAvailability(false);
            this.setErrorMessage(RPC.strerror((int)rc));
        }
    }

    static {
        PROGRAMS.put(PROGRAM_NFS, new Long(100003L));
    }
}

