/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.iis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.RtPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.logparse.BaseLogParser;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.SchemaBuilder;
import org.novadeck.jxla.LogParse;

public class IisRtPlugin
extends RtPlugin {
    private static final String FIELDS_FMT = "#Fields: ";
    private Hashtable logFormats = new Hashtable();
    private static Hashtable tokens = new Hashtable();
    private static final Log log;

    public BaseLogParser getParser() {
        return new LogParse();
    }

    public String getLogFormat(ConfigResponse config) {
        return "";
    }

    public String convertFormat(String fmt) {
        String jxlaFmt = new String();
        if (fmt == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(fmt);
        while (st.hasMoreTokens()) {
            String temp = (String)tokens.get(st.nextToken());
            jxlaFmt = temp == null ? jxlaFmt + "*" : jxlaFmt + temp;
            if (!st.hasMoreTokens()) continue;
            jxlaFmt = jxlaFmt + " ";
        }
        return jxlaFmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLogFormat(String fname) {
        BufferedReader logf = null;
        String format = (String)this.logFormats.get(fname);
        if (format != null) {
            return format;
        }
        try {
            String line;
            logf = new BufferedReader(new FileReader(fname));
            while ((line = logf.readLine()) != null) {
                if (!line.startsWith(FIELDS_FMT) || line.indexOf("time-taken") == -1) continue;
                format = line.substring(FIELDS_FMT.length()).trim();
                String jxlaFmt = this.convertFormat(format);
                this.logFormats.put(fname, jxlaFmt);
                String string = jxlaFmt;
                return string;
            }
            log.error((Object)("Unable to determine log file format for file: " + fname + ".  No valid " + FIELDS_FMT + " token " + "found"));
        }
        catch (IOException e) {
            log.error((Object)("Unable to determine log format for file: " + fname + ": " + e.getMessage()));
        }
        finally {
            if (logf != null) {
                try {
                    logf.close();
                }
                catch (IOException ingore) {}
            }
        }
        format = "";
        this.logFormats.put(fname, format);
        return format;
    }

    public String getEULogFormat(ConfigResponse config) {
        return "";
    }

    public boolean supportsEndUser() {
        return false;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        int type = info.getType();
        if (type != 3) {
            return new ConfigSchema();
        }
        SchemaBuilder schema = new SchemaBuilder(config);
        String serverRoot = config.getValue("installpath");
        schema.add(CONFIG_LOGDIR, "Full path to log directory", serverRoot + "\\LogFiles");
        schema.add(CONFIG_LOGMASK, "The filenames of your log files with wildcards", "*.log");
        schema.add(CONFIG_INTERVAL, "Interval between parsing log files (seconds)", 60);
        schema.addRegex(CONFIG_TRANSFORM, "Regular expressions to apply to all URLS, space separated", null).setOptional(true);
        schema.addStringArray(CONFIG_DONTLOG, "Regular expressions specifying which URLs not to log, space separated", null).setOptional(true);
        return schema.getSchema();
    }

    public int getSvcType() {
        return 2;
    }

    public Collection getTimes(Integer svcID, Properties alreadyParsedFiles, String logdir, String logmask, String logfmt, int svcType, String transforms, ArrayList noLog, boolean collectIPs) throws IOException {
        Hashtable urls = new Hashtable();
        this.lp = this.getParser();
        this.lp.setTimeMultiplier(this.getTimeMultiplier());
        this.lp.urlDontLog(noLog);
        RtPlugin.ParsedFile[] flist = this.generateFileList(alreadyParsedFiles, logdir, logmask);
        for (int i = 0; i < flist.length; ++i) {
            long[] flen = new long[1];
            RtPlugin.ParsedFile f = flist[i];
            logfmt = this.getLogFormat(f.fname);
            if (logfmt == "") {
                log.debug((Object)("Not parsing " + f.fname + ": No log format"));
                continue;
            }
            long start = System.currentTimeMillis();
            log.debug((Object)("Parsing log: " + f.fname));
            Hashtable rv = this.lp.parseLog(f.fname, logfmt, f.oldLen, svcID, svcType, flen, collectIPs);
            if (log.isDebugEnabled()) {
                long elapsed = System.currentTimeMillis() - start;
                log.debug((Object)("Done parsing log, " + rv.keySet().size() + " elements (" + StringUtil.formatDuration((long)elapsed, (int)0, (boolean)true) + ")"));
            }
            alreadyParsedFiles.put(f.fname, Long.toString(flen[0]));
            this.combineUrls(rv, urls, transforms);
        }
        log.debug((Object)("Returning parsed data " + urls.values().size() + " entries"));
        return urls.values();
    }

    static {
        tokens.put("date", "y-m-d");
        tokens.put("time", "h");
        tokens.put("c-ip", "$remote_ip");
        tokens.put("cs-username", "*");
        tokens.put("s-sitename", "*");
        tokens.put("s-computername", "*");
        tokens.put("s-ip", "*");
        tokens.put("s-port", "*");
        tokens.put("cs-method", "*");
        tokens.put("cs-uri-stem", "$uri");
        tokens.put("cs-uri-query", "$query");
        tokens.put("sc-status", "$status");
        tokens.put("sc-substatus", "*");
        tokens.put("sc-win32-status", "*");
        tokens.put("sc-bytes", "$size");
        tokens.put("cs-bytes", "*");
        tokens.put("time-taken", "$time_taken");
        tokens.put("cs-version", "*");
        tokens.put("cs-host", "$remote_host");
        tokens.put("cs(User-Agent)", "*");
        tokens.put("cs(Cookie)", "*");
        tokens.put("cs(Referer)", "*");
        log = LogFactory.getLog((String)"IisRtPlugin");
    }
}

