/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.wsmq.MQSeriesProductPlugin;
import org.hyperic.hq.plugin.wsmq.finders.ChannelFinder;
import org.hyperic.hq.plugin.wsmq.finders.ClusterFinder;
import org.hyperic.hq.plugin.wsmq.finders.QManagerFinder;
import org.hyperic.hq.plugin.wsmq.finders.QueueFinder;
import org.hyperic.hq.plugin.wsmq.finders.TopicFinder;
import org.hyperic.hq.plugin.wsmq.services.QManager;
import org.hyperic.hq.plugin.wsmq.services.Service;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;

public class MQSeriesDetector
extends ServerDetector
implements AutoServerDetector {
    public static final String PROP_LISTENER = "process.query";
    private static final String VERSION_CMD = "/bin/dspmqver -f 2";
    private Log log = LogFactory.getLog(MQSeriesDetector.class);

    private List getServerList(String path) throws PluginException {
        ArrayList<ServerResource> serverList;
        block7: {
            this.log.debug((Object)("getServerList(" + path + ")"));
            serverList = new ArrayList<ServerResource>();
            String version = this.getTypeInfo().getVersion();
            this.log.debug((Object)("Version = '" + version + "'"));
            try {
                Process cmd = Runtime.getRuntime().exec(path + VERSION_CMD);
                cmd.waitFor();
                String sal = MQSeriesDetector.inputStreamAsString(cmd.getInputStream());
                if (cmd.exitValue() == 0) {
                    this.log.debug((Object)("sal => " + sal));
                    Pattern regExp = Pattern.compile("Version.*(\\d)\\.\\d*\\.\\d*\\.\\d*");
                    Matcher m = regExp.matcher(sal);
                    m.find();
                    String ver = m.group(1);
                    this.log.debug((Object)("ver=" + ver + "(" + version.equals(ver) + ")"));
                    if (!version.equals(ver)) {
                        return serverList;
                    }
                    break block7;
                }
                String err = MQSeriesDetector.inputStreamAsString(cmd.getErrorStream());
                this.log.error((Object)"Fatal Error determining the MQ Version");
                this.log.error((Object)("stdOut => " + sal));
                this.log.error((Object)("stdErr => " + err));
                return serverList;
            }
            catch (Exception e) {
                this.log.error((Object)"Fatal Error determining the MQ Version", (Throwable)e);
                return serverList;
            }
        }
        List productServices = QManagerFinder.findQManagers(path);
        for (String qm_name : productServices) {
            String type = this.getTypeInfo().getName();
            this.log.debug((Object)("qmanager = '" + qm_name + "' (" + type + ")"));
            List qmanagers = new QManagerFinder(qm_name).findServices();
            assert (qmanagers.size() <= 1) : qmanagers.size();
            if (qmanagers.size() <= 0) continue;
            QManager qmanager = (QManager)qmanagers.get(0);
            ServerResource server = new ServerResource();
            server.setType(type);
            server.setName(MQSeriesDetector.getPlatformName() + " " + type + " " + qmanager.getName());
            server.setInstallPath(path);
            server.setIdentifier(server.getInstallPath() + " " + qmanager.getName());
            this.setProductConfig(server, qmanager.getProductConfig());
            ConfigResponse monitor = new ConfigResponse();
            monitor.setValue("server.log_track.enable", "true");
            monitor.setValue("server.log_track.level", "Info");
            server.setMeasurementConfig(monitor);
            server.setControlConfig();
            assert (qmanager.getName().equals(server.getProductConfig().getValue("queue.manager.name"))) : qmanager.getName() + "!=" + server.getProductConfig().getValue("queue.manager.name");
            serverList.add(server);
        }
        return serverList;
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.log.debug((Object)("getServerResources(" + platformConfig + ") [" + (MQSeriesDetector.isWin32() ? "win" : "unix") + "]"));
        String installPath = MQSeriesProductPlugin.findInstallDir();
        if (installPath != null) {
            return this.getServerList(installPath);
        }
        return new ArrayList();
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        this.log.debug((Object)("discoverServices(" + serverConfig + ")"));
        ArrayList services = new ArrayList();
        services.addAll(this.discoverProcess(serverConfig));
        services.addAll(this.discoverServices(new ClusterFinder(serverConfig).findServices()));
        services.addAll(this.discoverServices(new ChannelFinder(serverConfig).findServices()));
        services.addAll(this.discoverServices(new QueueFinder(serverConfig).findServices()));
        if (!this.getTypeInfo().getVersion().equals("6")) {
            services.addAll(this.discoverServices(new TopicFinder(serverConfig).findServices()));
        }
        return services;
    }

    private List discoverProcess(ConfigResponse serverConfig) throws PluginException {
        this.log.debug((Object)("discoverServicesListener(" + serverConfig + ")"));
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        String type = this.getTypeInfo().getName();
        Properties props = this.getProperties();
        Enumeration<Object> keys = props.keys();
        Pattern regExp = Pattern.compile("process.[*|" + this.getTypeInfo().getVersion() + "].(.*)");
        while (keys.hasMoreElements()) {
            String proc = (String)keys.nextElement();
            Matcher m = regExp.matcher(proc);
            if (!m.find()) continue;
            String progname = m.group(1).toLowerCase();
            this.log.debug((Object)("progname='" + progname + "'"));
            String query = "State.Name.eq=" + progname + "," + "Args.*.ct=" + serverConfig.getValue("queue.manager.name");
            if (MQSeriesDetector.getPids((String)query).length <= 0) continue;
            ServiceResource service = new ServiceResource();
            service.setType(type + " Process");
            service.setServiceName("Process " + progname.toUpperCase());
            service.setDescription(props.getProperty(proc));
            ConfigResponse conf = new ConfigResponse();
            conf.setValue(PROP_LISTENER, query);
            service.setProductConfig(conf);
            service.setMeasurementConfig();
            service.setControlConfig();
            services.add(service);
        }
        return services;
    }

    private List discoverServices(List mqServices) throws PluginException {
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        String type = this.getTypeInfo().getName();
        for (Service mqService : mqServices) {
            ServiceResource service = new ServiceResource();
            service.setType(type + " " + mqService.getTypeName());
            service.setServiceName(mqService.getTypeName() + " " + mqService.getName());
            service.setProductConfig(mqService.getProductConfig());
            service.setMeasurementConfig();
            services.add(service);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }
}

