/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.finders;

import com.ibm.mq.pcf.PCFMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.wsmq.MQSeriesProductPlugin;
import org.hyperic.hq.plugin.wsmq.finders.DefaultFinder;
import org.hyperic.hq.plugin.wsmq.services.QManager;
import org.hyperic.hq.plugin.wsmq.services.Service;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public class QManagerFinder
extends DefaultFinder {
    private static Log log = LogFactory.getLog(QManagerFinder.class);
    private static final int[] ATTRS = new int[]{1009};

    public QManagerFinder(ConfigResponse serverConfig) {
        super(serverConfig);
    }

    public QManagerFinder(String qm_name) {
        super(qm_name);
    }

    public PCFMessage getPCFMessage() {
        PCFMessage msg = new PCFMessage(2);
        msg.addParameter(1001, ATTRS);
        return msg;
    }

    public boolean isOK(PCFMessage response) {
        return true;
    }

    public Service newInstace(String mgrName, PCFMessage response) {
        return new QManager(response);
    }

    public static List findQManagers(String binPath) throws PluginException {
        ArrayList<String> qm = new ArrayList<String>();
        String dspmq = MQSeriesProductPlugin.getDspmqComand(binPath);
        log.debug((Object)("Executing '" + dspmq + "' for queue managers"));
        try {
            Process cmd = Runtime.getRuntime().exec(dspmq);
            cmd.waitFor();
            String sal = QManagerFinder.inputStreamAsString(cmd.getInputStream());
            log.debug((Object)(dspmq + " output:\n" + sal));
            Pattern p = Pattern.compile("QMNAME\\(([^\\)]*)\\) *STATUS\\(Running\\)");
            Matcher m = p.matcher(sal);
            while (m.find()) {
                qm.add(m.group(1));
            }
        }
        catch (Exception ex) {
            log.debug((Object)("error executing 'dspmq' " + ex), (Throwable)ex);
        }
        return qm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }
}

