/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.finders;

import com.ibm.mq.pcf.PCFMessage;
import org.hyperic.hq.plugin.wsmq.MQSeriesProductPlugin;
import org.hyperic.hq.plugin.wsmq.finders.DefaultFinder;
import org.hyperic.hq.plugin.wsmq.services.Queue;
import org.hyperic.hq.plugin.wsmq.services.Service;
import org.hyperic.util.config.ConfigResponse;

public class QueueFinder
extends DefaultFinder {
    private static final int[] ATTRS = new int[]{2016, 20, 7, 2002, 2029, 2017, 2018, 2024};

    public QueueFinder(ConfigResponse serverConfig) {
        super(serverConfig);
    }

    public Service newInstace(String mgrName, PCFMessage response) {
        if (MQSeriesProductPlugin.isTraceEnabled() && this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)response);
        }
        Queue service = new Queue(mgrName, response);
        return service;
    }

    public PCFMessage getPCFMessage() {
        PCFMessage msg = new PCFMessage(13);
        msg.addParameter(2016, "*");
        msg.addParameter(1002, ATTRS);
        return msg;
    }

    public boolean isOK(PCFMessage response) {
        boolean is_tempo = new Integer(3).equals(response.getParameterValue(7));
        boolean is_model = new Integer(2).equals(response.getParameterValue(7));
        boolean is_valid_type = response.getParameterValue(20) != null;
        boolean res = !is_model && !is_tempo && is_valid_type;
        this.getLog().debug((Object)(response.getParameterValue(2016) + " => is_model=" + is_model + " is_tempo=" + is_tempo + " is_valid_type=" + is_valid_type + " => " + res));
        return res;
    }
}

