/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.wsmq.services;

import com.ibm.mq.pcf.PCFMessage;
import org.hyperic.hq.plugin.wsmq.services.Service;
import org.hyperic.util.config.ConfigResponse;

public class Channel
implements Service {
    public static final String PROP_CHL_NAME = "channel.name";
    public static final String PROP_CLS_NAME = "cluster.name";
    private String name;
    private String typeName;
    private int type;
    private ConfigResponse productConfig = new ConfigResponse();

    public Channel(PCFMessage response) {
        this.type = (Integer)response.getParameterValue(1511);
        this.name = ((String)response.getParameterValue(3501)).trim();
        this.productConfig.setValue(PROP_CHL_NAME, this.name);
        switch (this.type) {
            case 1: {
                this.typeName = "Sender Channel";
                break;
            }
            case 3: {
                this.typeName = "Receiver Channel";
                break;
            }
            case 8: {
                this.typeName = "Cluster Receiver Channel";
                this.productConfig.setValue(PROP_CLS_NAME, ((String)response.getParameterValue(3501)).trim());
                break;
            }
            case 9: {
                this.typeName = "Cluster Sender Channel";
                this.productConfig.setValue(PROP_CLS_NAME, ((String)response.getParameterValue(3501)).trim());
                break;
            }
            default: {
                this.typeName = "Channel";
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ConfigResponse getProductConfig() {
        return this.productConfig;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "] config=" + this.productConfig;
    }
}

