/*
 * This file implements the ctApacheMPMTable of the COVALENT-APACHE-MPM-MIB.
 */
/* General includes */
#include <stdio.h>
#include <sys/types.h>

/* Apache includes */
#include <httpd.h>
#define CORE_PRIVATE
#include <http_config.h>
#include <scoreboard.h>
#include <ap_mpm.h>

/* SNMP includes */
#include "ucd-snmp-config.h"
#include <asn1.h>
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_impl.h>
#include <snmp_debug.h>
#include <snmp_vars.h>
#include <var_struct.h>

#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#define APACHE_MPM_MIB_PRIVATE
#include "apache-mpm-mib/apache-mpm-mib.h"

#ifdef COVALENT_APACHE_MPM_MIB

static unsigned char *
read_ctApacheMPMEntry(struct variable *vp,
    oid *name, size_t *length, int exact,
    size_t *var_len, WriteMethod **write_method)
{
int result;
static int value;

    /* We can directly compare, since the init procedure already
     * fixes the applIndex for this registered branch.
     */
    result = snmp_oid_compare(name, *length, vp->name, vp->namelen);
    if ((exact && (result != 0)) || (!exact && (result >= 0))) {
        return(NULL);
    }
    memcpy( (char *)name,(char *)vp->name, vp->namelen * sizeof(oid));
    *length = vp->namelen;

#ifdef COVALENT_APACHE_MPM_MIB_WRITE
    *write_method = WRITE_CTAPACHEMPMENTRY;
#endif /* COVALENT_APACHE_MPM_MIB_WRITE */
    *var_len = sizeof(value);    /* default to 'long' results */
    switch (vp->magic) {
    case CTAPACHEMPMDESCR:
        *var_len = strlen(ap_show_mpm());
        return (unsigned char *) ap_show_mpm();
    case CTAPACHEMPMFORKING:
        ap_mpm_query(AP_MPMQ_IS_FORKED, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMTHREADING:
        ap_mpm_query(AP_MPMQ_IS_THREADED, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMDAEMONSLIMIT:
        ap_mpm_query(AP_MPMQ_HARD_LIMIT_DAEMONS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMTHREADSLIMIT:
        ap_mpm_query(AP_MPMQ_HARD_LIMIT_THREADS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMMAXDAEMONS:
        ap_mpm_query(AP_MPMQ_MAX_DAEMONS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMMAXTHREADS:
        ap_mpm_query(AP_MPMQ_MAX_THREADS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMMINSPAREDAEMONS:
        ap_mpm_query(AP_MPMQ_MIN_SPARE_DAEMONS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMMINSPARETHREADS:
        ap_mpm_query(AP_MPMQ_MIN_SPARE_THREADS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMMAXSPAREDAEMONS:
        ap_mpm_query(AP_MPMQ_MAX_SPARE_DAEMONS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMMAXSPARETHREADS:
        ap_mpm_query(AP_MPMQ_MAX_SPARE_THREADS, &value);
        return (unsigned char *) &value;
    case CTAPACHEMPMMAXREQUESTPERDAEMON:
        ap_mpm_query(AP_MPMQ_MAX_REQUESTS_DAEMON, &value);
        return (unsigned char *) &value;
    }
    return NULL;
}

/* We add a 0 as last OID to be filled with the applIndex. Each registration */
/* is by t his implementation limited to only 1 entry.                       */
/* (Makes table implementation like scalars which is simple and allows for   */
/* multiple registrations of Apache)                                         */
static oid ctApacheMPMEntry_oid[] = {1, 3, 6, 1, 4, 1, 6100, 11, 1, 2, 1};
struct variable2 ctApacheMPMEntry_variables[] = {
    { CTAPACHEMPMDESCR, ASN_OCTET_STR, RONLY,
                                        read_ctApacheMPMEntry, 2, {1, 0} },
    { CTAPACHEMPMFORKING, ASN_INTEGER, RONLY,
                                        read_ctApacheMPMEntry, 2, {2, 0} },
    { CTAPACHEMPMTHREADING, ASN_INTEGER, RONLY,
                                        read_ctApacheMPMEntry, 2, {3, 0} },
    { CTAPACHEMPMDAEMONSLIMIT, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {4, 0} },
    { CTAPACHEMPMTHREADSLIMIT, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {5, 0} },
    { CTAPACHEMPMMAXDAEMONS, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {6, 0} },
    { CTAPACHEMPMMAXTHREADS, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {7, 0} },
    { CTAPACHEMPMMINSPAREDAEMONS, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {8, 0} },
    { CTAPACHEMPMMINSPARETHREADS, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {9, 0} },
    { CTAPACHEMPMMAXSPAREDAEMONS, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {10, 0} },
    { CTAPACHEMPMMAXSPARETHREADS, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {11, 0} },
    { CTAPACHEMPMMAXREQUESTPERDAEMON, ASN_UNSIGNED, RWRITE,
                                        read_ctApacheMPMEntry, 2, {12, 0} },
};

void init_covalent_apache_mpm_mib()
{
unsigned long appl_index;
int i;

    appl_index = get_appl_index();
    for (i = 0;
         i < (sizeof(ctApacheMPMEntry_variables)/sizeof(struct variable2));
         i++) {
       ctApacheMPMEntry_variables[i].name[1] = appl_index;
    }
    REGISTER_MIB("ctApacheMPMEntry", ctApacheMPMEntry_variables,
                                 variable2, ctApacheMPMEntry_oid);

#ifdef COVALENT_APACHE_MPM_MIB_WRITE
    ap_mpm_query(AP_MPMQ_HARD_LIMIT_DAEMONS, &shadow_daemons_limit);
    ap_mpm_query(AP_MPMQ_MIN_SPARE_DEAMONS, &shadow_daemons_min_free);
    ap_mpm_query(AP_MPMQ_MAX_SPARE_DAEMONS, &shadow_daemons_max_free);
    ap_mpm_query(AP_MPMQ_MAX_REQUESTS_DEAMON, &shadow_max_requests_per_child);
#endif /* COVALENT_APACHE_MPM_MIB_WRITE */
}
#endif /* COVALENT_APACHE_MPM_MIB */

