/*
 * This file implements the ctApacheProcessStatusTable of the
 * COVALENT-APACHE-STATUSv2-MIB module.
 */
/* General includes */
#include <sys/types.h>

/* Apache includes */ 
#include <httpd.h>
#include <scoreboard.h>
#include <ap_mpm.h>

/* SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp.h"
#include "snmp_api.h"
#include "snmp_impl.h"
#include "snmp_debug.h"
#include "snmp_vars.h"
#include "var_struct.h"
#include <mibgroup/mibII/sysORTable.h>

/* module includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "apache-status-mib.h"

/* columnar objects of the ctApacheProcessStatusTable */
#define CTAPACHEPROCESSSTATUSINDEX              1
#define CTAPACHEPROCESSSTATUSPROCESSID          2
#define CTAPACHEPROCESSSTATUSGENERATION         3
#define CTAPACHEPROCESSSTATUSSHARED             4
#define CTAPACHEPROCESSSTATUSOPERSTATUS         5
#define CTAPACHEPROCESSSTATUSADMINSTATUS        6
#define CTAPACHEPROCESSSTATUSWORKERS            7

#ifdef COVALENT_APACHE_STATUS_MIB
FindVarMethod read_ctApacheProcessStatusEntry;

unsigned char *
read_ctApacheProcessStatusEntry(struct variable *vp,
    oid *name, size_t *length,
    int exact, size_t *var_len, WriteMethod **write_method)
{
process_score *process_info;
int process_index = 1;
int servers_used = 0;
int hard_server_limit = 0;

    ap_mpm_query(AP_MPMQ_MAX_DAEMON_USED, &servers_used);
    ap_mpm_query(AP_MPMQ_HARD_LIMIT_DAEMONS, &hard_server_limit);
    if ((servers_used < 0) || (hard_server_limit < servers_used)) {
        servers_used = hard_server_limit;
    }
    process_index = get_ctApacheProcessStatusIndex(vp, name, length, exact,
                                                1, servers_used);
    process_info = ap_get_scoreboard_process(process_index - 1);
    if (process_info == NULL) {
        return(NULL);
    }
    *length = vp->namelen;
    memcpy( (char *)name,(char *)vp->name, *length * sizeof(oid));
    *var_len = sizeof(long_return);
    *write_method = 0;
    switch (vp->magic) {
	case CTAPACHEPROCESSSTATUSPROCESSID:
            long_return = process_info->pid;
	    return (unsigned char *) &long_return;
        case CTAPACHEPROCESSSTATUSGENERATION:
            long_return = process_info->generation;
            return (unsigned char *) &long_return;
        case CTAPACHEPROCESSSTATUSSHARED:
            long_return = ((process_info->sb_type == SB_SHARED) ? 1 : 2);
            return (unsigned char *) &long_return;
	case CTAPACHEPROCESSSTATUSOPERSTATUS:
            *write_method = NULL;
	    long_return = 1; /* Always up, otherwise it is not there. */
	    return (unsigned char *) &long_return;
	case CTAPACHEPROCESSSTATUSADMINSTATUS:
	    long_return = 1; /* Always up, otherwise it is not there. */
	    return (unsigned char *) &long_return;
	case CTAPACHEPROCESSSTATUSWORKERS: /* not implemented. */
        default:
            return NULL;
    }
}

/* We add a 0 as last OID to be filled with the applIndex. Each registration */
/* is by t his implementation limited to only 1 entry.                       */
/* (Makes table implementation like scalars which is simple and allows for   */
/* multiple registrations of Apache)                                         */
static oid ctApacheProcessStatusEntry_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 12, 1, 1, 1};
static struct variable2 ctApacheProcessStatusEntry_variables[] = {
    { CTAPACHEPROCESSSTATUSPROCESSID, ASN_UNSIGNED, RONLY,
                                read_ctApacheProcessStatusEntry, 2, {2, 0} },
    { CTAPACHEPROCESSSTATUSGENERATION, ASN_UNSIGNED, RONLY,
                                read_ctApacheProcessStatusEntry, 2, {3, 0} },
    { CTAPACHEPROCESSSTATUSSHARED, ASN_INTEGER, RONLY,
                                read_ctApacheProcessStatusEntry, 2, {4, 0} },
    { CTAPACHEPROCESSSTATUSOPERSTATUS, ASN_INTEGER, RONLY,
                                read_ctApacheProcessStatusEntry, 2, {5, 0} },
    { CTAPACHEPROCESSSTATUSADMINSTATUS, ASN_INTEGER, RONLY,
                                read_ctApacheProcessStatusEntry, 2, {6, 0} },
    { CTAPACHEPROCESSSTATUSWORKERS, ASN_UNSIGNED, RONLY,
                                read_ctApacheProcessStatusEntry, 2, {7, 0} },
};

void
init_covalent_apache_status_process()
{
int appl_index;
int i;

    appl_index = get_appl_index();
    for (i = 0;
         i < (sizeof(ctApacheProcessStatusEntry_variables)/sizeof(struct variable2));
         i++) {
       ctApacheProcessStatusEntry_variables[i].name[1] = appl_index;
    }
    REGISTER_MIB("covalent-apache-status-mib/ctApacheProcessStatusTable",
		ctApacheProcessStatusEntry_variables, variable2,
		ctApacheProcessStatusEntry_oid);
#ifdef USING_MIBII_SYSORTABLE_MODULE
    register_sysORTable(ctApacheProcessStatusEntry_oid, 10,
		"The Covalent Apache Server MIB module");
#endif /* USING_MIBII_SYSORTABLE_MODULE */
}
#endif /* COVALENT_APACHE_STATUS_MIB */


