/* Standard includes */
#include <stdio.h>
#include <fcntl.h>
#ifndef WIN32
#include <unistd.h>
#endif

/* Apache includes */
#include <httpd.h>
#include <http_core.h>
#include <http_config.h>
#include <scoreboard.h>
#include <apr_optional.h>

#include "covalent-snmp-config.h"
#include "www-mib/www-mib.h"
#include "www-mib/www-mib-document.h"

#ifdef WWW_DOCUMENT_GROUP
int		wwwDocBucket_errno;
wwwDocTopN_t	record_data;

DB_TYPE
covalent_snmp_wwwDocBucket_open(char *name)
{
DB_TYPE	wwwdocbucket;

#if defined(HAVE_DB_H) || defined(HAVE_DB_185_H)
    unlink(name);
    wwwdocbucket = dbopen(name, (O_CREAT | O_RDWR), 0664, DB_HASH, NULL);
    wwwDocBucket_errno = errno;
#elif HAVE_NDBM_H
    char filename_array[1000];

    strcpy(filename_array, name);
    unlink(strcat(filename_array, ".dir"));
    strcpy(filename_array, name);
    unlink(strcat(filename_array, ".pag"));
    wwwdocbucket = dbm_open(name, (O_CREAT | O_RDWR), 0664);
#elif BUCKETTYPE_IS_SDBM
    char filename_array[1000];

    strcpy(filename_array, name);
    unlink(strcat(filename_array, DIRFEXT));
    strcpy(filename_array, name);
    unlink(strcat(filename_array, PAGFEXT));
    wwwdocbucket = covalent_sdbm_open(name, (O_CREAT | O_RDWR), 0664);
#endif
    return(wwwdocbucket);
}


void
covalent_snmp_wwwDocBucket_close(DB_TYPE wwwdocbucket)
{
    if (!wwwdocbucket) return;
#if defined(HAVE_DB_H) || defined(HAVE_DB_185_H)
    (wwwdocbucket->close)(wwwdocbucket);
#elif defined(HAVE_NDBM_H) 
    dbm_close(wwwdocbucket);
#elif defined(BUCKETTYPE_IS_SDBM)
    covalent_sdbm_close(wwwdocbucket);
#endif
}

wwwDocTopN_t *
covalent_snmp_wwwDocBucket_fetch(DB_TYPE wwwdocbucket, char *keystr)  
{
#if defined(HAVE_DB_H) || defined(HAVE_DB_185_H)
    DBT	key;
    DBT	data;

    if (wwwdocbucket) {
	key.data = keystr;
	key.size = strlen(keystr);
	if (!((wwwdocbucket->get)(wwwdocbucket, &key, &data, 0))) {
	    if (data.size == sizeof(record_data)) {
		memcpy(&record_data, data.data, sizeof(wwwDocTopN_t));
		return(&record_data);
	    }
	}
	wwwDocBucket_errno = errno;
    }
#elif defined(HAVE_NDBM_H)
    datum key;
    datum data;

    if (wwwdocbucket) {
	key.dptr = keystr;
	key.dsize = strlen(keystr);
	data = dbm_fetch(wwwdocbucket, key);
	if (data.dsize == sizeof(wwwDocTopN_t)) {
	    memcpy(&record_data, data.dptr, sizeof(wwwDocTopN_t));
	    return &record_data;
	}
    }
#elif defined(BUCKETTYPE_IS_SDBM)
    datum key;
    datum data;

    if (wwwdocbucket) {
	key.dptr = keystr;
	key.dsize = strlen(keystr);
	data = covalent_sdbm_fetch(wwwdocbucket, key);
	if (data.dsize == sizeof(wwwDocTopN_t)) {
	    memcpy(&record_data, data.dptr, sizeof(wwwDocTopN_t));
	    return &record_data;
	}
	wwwDocBucket_errno = errno;
    }
#endif
    return(NULL);
}

int
covalent_snmp_wwwDocBucket_store(DB_TYPE wwwdocbucket, char *keystr, wwwDocTopN_t *record,
	int action)
{
int result = 0;
#if defined(HAVE_DB_H) || defined(HAVE_DB_185_H)
    DBT	key;
    DBT	data;

    if (wwwdocbucket) {
	key.data = keystr;
	key.size = strlen(keystr);
	data.data = record;
	data.size = sizeof(wwwDocTopN_t);
	result = (wwwdocbucket->put)(wwwdocbucket, &key, &data, action);
	wwwDocBucket_errno = errno;
    }
#elif defined(HAVE_NDBM_H)
    datum key;
    datum data;

    if (wwwdocbucket) {
	key.dptr = keystr;
	key.dsize = strlen(keystr);
	data.dptr = (char *)record;
	data.dsize = sizeof(wwwDocTopN_t);
	result = dbm_store(wwwdocbucket, key, data, action);
    }
#elif defined(BUCKETTYPE_IS_SDBM)
    datum key;
    datum data;

    if (wwwdocbucket) {
	key.dptr = keystr;
	key.dsize = strlen(keystr);
	data.dptr = (char *)record;
	data.dsize = sizeof(wwwDocTopN_t);
	result = covalent_sdbm_store(wwwdocbucket, key, data, action);
	wwwDocBucket_errno = errno;
    }
#endif
    return(result);
}

wwwDocTopN_t *
covalent_snmp_wwwDocBucket_seqfetch(DB_TYPE wwwdocbucket, int action)
{
#if defined(HAVE_DB_H) || defined(HAVE_DB_185_H)
DBT	key;
DBT	record;

    if (wwwdocbucket) {
	if ((wwwdocbucket->seq)(wwwdocbucket, &key, &record, action) == 0) {
	    if (record.size == sizeof(record_data)) {
		memcpy(&record_data, record.data, record.size);
		return(&record_data);
	    }
	}
    }
#elif defined(HAVE_NDBM_H)
    datum key;
    datum data;

    if (wwwdocbucket) {
	if (action == FIRST_RECORD) {
	    key = dbm_firstkey(wwwdocbucket);
	} else {
	    key = dbm_nextkey(wwwdocbucket);
	}
	if (key.dptr != NULL) {
	    data = dbm_fetch(wwwdocbucket, key);
	    if (data.dsize == sizeof(wwwDocTopN_t)) {
		memcpy(&record_data, data.dptr, sizeof(wwwDocTopN_t));
		return &record_data;
	    }
	}
    }
#elif defined(BUCKETTYPE_IS_SDBM)
    datum key;
    datum data;

    if (wwwdocbucket) {
	if (action == FIRST_RECORD) {
	    key = covalent_sdbm_firstkey(wwwdocbucket);
	} else {
	    key = covalent_sdbm_nextkey(wwwdocbucket);
	}
	if (key.dptr != NULL) {
	    data = covalent_sdbm_fetch(wwwdocbucket, key);
	    if (data.dsize == sizeof(wwwDocTopN_t)) {
		memcpy(&record_data, data.dptr, sizeof(wwwDocTopN_t));
		return &record_data;
	    }
	}
	wwwDocBucket_errno = errno;
    }
#endif
    return(NULL);
}


const char *
covalent_snmp_get_wwwDocBucket_strerror()
{
int error;

    error = wwwDocBucket_errno;
    wwwDocBucket_errno = 0;
#if defined(HAVE_DB_H) || defined(HAVE_DB_185_H)
     return(strerror(error));
#elif defined(HAVE_NDBM_H)
    /* Not implemented */
#elif defined(BUCKETTYPE_IS_SDBM)
     return(strerror(error));
#endif
     return("");
}

int
covalent_snmp_get_wwwDocBucket_errno()
{
    return(wwwDocBucket_errno);
}

#endif /* WWW_DOCUMENT_GROUP */
