/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.SvaUtilities;

public class PhysicalVolume
extends AbstractSerializable {
    private final String name;
    private String uuid;
    private long size;
    private String volumeGroupName;
    private static final long serialVersionUID = 1L;

    public PhysicalVolume(String name) throws Exception {
        this.name = name;
        String[] attributes = new String[]{"uuid", "size", "vg_name"};
        StringBuilder sb = new StringBuilder();
        for (String a : attributes) {
            sb.append(a + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String options = this.getPhysicalVolumeAttribute(sb.toString()).replaceAll("\\b\\s{2,}\\b", " ");
        String[] values = options.split(" ");
        if (values.length != attributes.length) {
            throw new Exception("Unable to construct a PhysicalVolume object");
        }
        this.uuid = values[0];
        this.size = Long.valueOf(values[1]) / 1024L;
        this.volumeGroupName = values[2];
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public long getSize() {
        return this.size;
    }

    public String getVolumeGroupName() {
        return this.volumeGroupName;
    }

    public long getCurrentSize() throws Exception {
        String sizeStr = this.getPhysicalVolumeAttribute("size");
        return Long.valueOf(sizeStr) / 1024L;
    }

    public void resize(long newSize) throws Exception {
        SvaUtilities.resizePhysicalVolume(this, newSize);
        this.size = this.getCurrentSize();
    }

    private String getPhysicalVolumeAttribute(String attribute) throws Exception {
        return SvaUtilities.getLvmAttribute("/sbin/pvs", this.name, attribute);
    }
}

