/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.common.SerialFields;
import com.vmware.sva.common.SerialMinorVersion;
import com.vmware.sva.common.SvaUtilities;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.UUID;

@SerialMinorVersion(value=2)
public class PseudoSvaServerInfo
extends AbstractUniqueObject {
    private UUID storageClusterID;
    private boolean maintenanceMode;
    private String[] dnsServers;
    private String domainName;
    private boolean rmiRunning;
    private NetworkInterface networkInterface;
    private static final long serialVersionUID = 1L;

    public PseudoSvaServerInfo(UUID id, String name, UUID theStorageClusterID, boolean inMaintenanceMode, NetworkInterface theNetworkInterface, String[] theDnsServers, String theDomainName, boolean theRmiRunning) {
        super(id, name);
        this.storageClusterID = theStorageClusterID;
        this.networkInterface = theNetworkInterface;
        this.maintenanceMode = inMaintenanceMode;
        this.dnsServers = SvaUtilities.copyArray(theDnsServers);
        this.domainName = theDomainName;
        this.rmiRunning = theRmiRunning;
    }

    public PseudoSvaServerInfo(PseudoSvaServerInfo svaServerInfo) {
        this(svaServerInfo.getId(), svaServerInfo.getName(), svaServerInfo.getStorageClusterId(), svaServerInfo.getMaintenanceMode(), svaServerInfo.getNetworkInterface(), svaServerInfo.getDnsServers(), svaServerInfo.getDomainName(), svaServerInfo.getRmiRunning());
    }

    public PseudoSvaServerInfo(UUID id, String name) {
        super(id, name);
    }

    public UUID getStorageClusterId() {
        return this.storageClusterID;
    }

    public boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public String[] getDnsServers() {
        return SvaUtilities.copyArray(this.dnsServers);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public boolean getRmiRunning() {
        return this.rmiRunning;
    }

    public void setMaintenanceMode(boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InvalidClassException {
        SerialFields fields = this.getSerialGeneration().setDefaultFields(this, PseudoSvaServerInfo.class, in);
        if (fields != null) {
            switch (fields.getSerialMinorVersion()) {
                case 1: {
                    this.rmiRunning = true;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new InvalidClassException("Unknown serial minor version " + fields.getSerialMinorVersion() + " for class " + PseudoSvaServerInfo.class.getName());
                }
            }
        }
    }
}

