/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SvaVersion {
    public static final String RESOURCE = "com/vmware/sva/common/SvaVersion.properties";
    private static final String UNKNOWN = "<unknown>";
    private static final Logger logger = Logger.getLogger(SvaVersion.class.getName());
    private static final Properties properties = new Properties();
    private static final String version;
    private static final String fullVersion;
    private static final String prettyVersion;

    private SvaVersion() {
    }

    public static String getVersion() {
        return version;
    }

    public static String getFullVersion() {
        return fullVersion;
    }

    public static String getPrettyVersion() {
        return prettyVersion;
    }

    public static int compareVersions(String version1, String version2) {
        for (int i = 0; i < 3; ++i) {
            int dot1 = version1.indexOf(46);
            String component1 = dot1 >= 0 ? version1.substring(0, dot1) : version1;
            version1 = dot1 >= 0 ? version1.substring(dot1 + 1) : "";
            int dot2 = version2.indexOf(46);
            String component2 = dot2 >= 0 ? version2.substring(0, dot2) : version2;
            version2 = dot2 >= 0 ? version2.substring(dot2 + 1) : "";
            int compare = SvaVersion.compareVersionComponents(component1, component2);
            if (compare == 0) continue;
            return compare;
        }
        return SvaVersion.compareVersionComponents(version1, version2);
    }

    private static int compareVersionComponents(String component1, String component2) {
        int int1 = 0;
        boolean isInt1 = false;
        try {
            int1 = Integer.parseInt(component1);
            isInt1 = true;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int int2 = 0;
        boolean isInt2 = false;
        try {
            int2 = Integer.parseInt(component2);
            isInt2 = true;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (isInt1 && isInt2) {
            return int1 - int2;
        }
        if (isInt1) {
            return -1;
        }
        if (isInt2) {
            return 1;
        }
        return component1.compareTo(component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream = SvaVersion.class.getClassLoader().getResourceAsStream(RESOURCE);
        if (inputStream == null) {
            logger.log(Level.SEVERE, "Resource not found: com/vmware/sva/common/SvaVersion.properties");
        } else {
            InputStreamReader in = new InputStreamReader(inputStream);
            try {
                properties.load(in);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Problem reading SvaVersion properties", e);
            }
            finally {
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {}
            }
        }
        String buildVersion = properties.getProperty("BUILD_VERSION", UNKNOWN);
        String buildSerialNumber = properties.getProperty("BUILD_SERIAL_NUMBER", UNKNOWN);
        String buildNumber = properties.getProperty("BUILD_NUMBER", UNKNOWN);
        String buildPrettyVersion = properties.getProperty("BUILD_PRETTY_VERSION", UNKNOWN);
        version = buildVersion + "." + buildSerialNumber;
        fullVersion = buildPrettyVersion + " (SN " + buildSerialNumber + ", Build " + buildNumber + ")";
        prettyVersion = buildPrettyVersion + " (SN " + buildSerialNumber + ")";
        logger.info("Setting pretty version to " + prettyVersion);
    }
}

