/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.Disk;
import com.vmware.sva.common.RaidType;
import com.vmware.sva.common.VolumeState;
import java.util.List;
import java.util.UUID;

public class Volume
extends AbstractUniqueObject {
    private RaidType type;
    private int diskCount;
    private long size;
    private List<Disk> disks;
    private VolumeState state;
    private UUID currentVolumeOwner;
    private UUID primaryVolumeOwner;
    private UUID exportId;
    private Long syncSpeed = null;
    private Float syncPercent = null;
    private static final long serialVersionUID = 1L;

    public Volume() {
    }

    public Volume(UUID id, String name, RaidType type, int diskCount, long size, List<Disk> disks, VolumeState state, UUID currentVolumeOwner, UUID primaryVolumeOwner, UUID exportId) {
        super(id, name);
        this.type = type;
        this.diskCount = diskCount;
        this.size = size;
        this.disks = disks;
        this.state = state;
        this.currentVolumeOwner = currentVolumeOwner;
        this.primaryVolumeOwner = primaryVolumeOwner;
        this.exportId = exportId;
    }

    public RaidType getType() {
        return this.type;
    }

    public int getDiskCount() {
        return this.diskCount;
    }

    public long getSize() {
        return this.size;
    }

    public List<Disk> getDisks() {
        return this.disks;
    }

    public VolumeState getState() {
        return this.state;
    }

    public UUID getCurrentVolumeOwner() {
        return this.currentVolumeOwner;
    }

    public UUID getExportId() {
        return this.exportId;
    }

    public UUID getPrimaryVolumeOwner() {
        return this.primaryVolumeOwner;
    }

    public void setType(RaidType type) {
        this.type = type;
    }

    public void setDiskCount(int diskCount) {
        this.diskCount = diskCount;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setDisks(List<Disk> disks) {
        this.disks = disks;
    }

    public void setState(VolumeState state) {
        this.state = state;
    }

    public void setCurrentVolumeOwner(UUID currentVolumeOwner) {
        this.currentVolumeOwner = currentVolumeOwner;
    }

    public void setPrimaryVolumeOwner(UUID primaryVolumeOwner) {
        this.primaryVolumeOwner = primaryVolumeOwner;
    }

    public void setExportId(UUID exportId) {
        this.exportId = exportId;
    }

    public Long getSyncSpeed() {
        return this.syncSpeed;
    }

    public void setSyncSpeed(Long syncSpeed) {
        this.syncSpeed = syncSpeed == null ? 0L : syncSpeed;
    }

    public Float getSyncPercent() {
        return this.syncPercent;
    }

    public void setSyncPercent(Float syncPercent) throws IllegalArgumentException {
        if (syncPercent != null && (syncPercent.floatValue() < 0.0f || (double)syncPercent.floatValue() > 1.0)) {
            throw new IllegalArgumentException("The sync percentage must be between 0.0 and 1.0.");
        }
        this.syncPercent = Float.valueOf(syncPercent == null ? 1.0f : syncPercent.floatValue());
    }

    public Long getSyncTimeToComplete() {
        Long eta = null;
        eta = this.syncSpeed != null && this.syncSpeed != 0L ? Long.valueOf(Math.round((double)this.size * (1.0 - (double)this.syncPercent.floatValue()) / (double)this.syncSpeed.longValue())) : Long.valueOf(0L);
        return eta;
    }
}

