/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.mgmtevents.AbstractManagementEvent;
import com.vmware.sva.common.mgmtevents.AbstractSasManagementEvent;
import com.vmware.sva.common.mgmtevents.AbstractSvaManagementEvent;
import com.vmware.sva.messaging.MessagingServiceInfo;
import com.vmware.sva.messaging.interfaces.MessagingInterface;
import com.vmware.sva.messaging.interfaces.PseudosvaInterface;
import com.vmware.sva.messaging.interfaces.SasInterface;
import com.vmware.sva.messaging.interfaces.ServiceInterface;
import com.vmware.sva.messaging.interfaces.SvaInterface;
import com.vmware.sva.messaging.jms.TopicPublisher;
import com.vmware.sva.messaging.messages.BaseMessage;
import com.vmware.sva.messaging.ws.AccessController;
import com.vmware.sva.messaging.ws.pseudosva.PseudosvaserviceSkeleton;
import com.vmware.sva.messaging.ws.sas.SasserviceSkeleton;
import com.vmware.sva.messaging.ws.sva.SvaserviceSkeleton;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringSslContext;
import org.apache.activemq.xbean.XBeanBrokerService;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MessagingInterfaceImpl
implements MessagingInterface {
    private static final String JMSBROKER = "jmsbroker";
    private static final Log log = LogFactory.getLog(MessagingInterfaceImpl.class);
    private static final String SVA_WEBSERVICE_NAME = "svaservice";
    private static final String PSEUDOSVA_WEBSERVICE_NAME = "pseudosvaservice";
    private static final String SAS_WEBSERVICE_NAME = "sasservice";
    private static final String MESSAGING_INTERFACE_IMPL = "MessagingInterfaceImpl";
    private ClassPathXmlApplicationContext ctx;
    private SvaInterface sva;
    private PseudosvaInterface psva;
    private SasInterface sas;
    private Server wsServer;
    private ConfigurationContext wsContext;
    private static final ThreadLocal<HttpSession> sessionHolder = new ThreadLocal();
    private static final ThreadLocal<SessionManager> sessionMgrHolder = new ThreadLocal();
    private final AccessController svaController = new AccessController();
    private final AccessController psvaController = new AccessController();
    private final AccessController sasController = new AccessController();

    public MessagingInterfaceImpl() {
        this.startServices();
    }

    public void removeCurrentWsSession() {
        HttpSession session = sessionHolder.get();
        AbstractSessionManager mgr = (AbstractSessionManager)sessionMgrHolder.get();
        if (session != null && mgr != null) {
            if (log.isInfoEnabled()) {
                log.info("removeCurrentWsSession: " + session.getId());
            }
            mgr.removeSession(session, true);
        }
    }

    public ClassPathXmlApplicationContext getAppContext() {
        return this.ctx;
    }

    public SvaInterface getSvaInterface() {
        return this.sva;
    }

    public PseudosvaInterface getPseudosvaInterface() {
        return this.psva;
    }

    public SasInterface getSasInterface() {
        return this.sas;
    }

    public AccessController getSvaController() {
        return this.svaController;
    }

    public AccessController getPseudosvaController() {
        return this.psvaController;
    }

    public AccessController getSasController() {
        return this.sasController;
    }

    public void stopServices() {
        if (this.wsServer != null) {
            try {
                this.wsServer.stop();
                log.info("web service stopped.");
            }
            catch (Exception e) {
                log.error("failed to stop the web service.", e);
            }
        }
        if (this.ctx != null) {
            BrokerService broker = (BrokerService)this.ctx.getBean(JMSBROKER);
            try {
                broker.stop();
            }
            catch (Exception e) {
                log.error("failed to stop the jms broker.", e);
            }
        }
    }

    public void startServices() {
        URL respository;
        this.ctx = new ClassPathXmlApplicationContext(new String[]{"classpath:com/vmware/sva/messaging/jms/jms-server.xml"});
        if (log.isInfoEnabled()) {
            log.info("jms broker started.");
        }
        if ((respository = MessagingInterfaceImpl.class.getClassLoader().getResource("repository")) == null) {
            throw new RuntimeException("repository not in classpath");
        }
        String repositoryFileName = null;
        try {
            repositoryFileName = new URI(respository.toString()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        XBeanBrokerService broker = (XBeanBrokerService)this.ctx.getBean(JMSBROKER);
        SpringSslContext sslCtx = (SpringSslContext)broker.getSslContext();
        int port = SvaConstants.HTTPS_PORT;
        if (SvaConstants.IS_PSEUDO_SVA) {
            port = SvaConstants.PSVA_HTTPS_PORT;
        }
        log.info("Starting web service on port " + port);
        SslSocketConnector sslConnector = new SslSocketConnector();
        sslConnector.setPort(port);
        sslConnector.setKeystoreType(sslCtx.getKeyStoreType());
        sslConnector.setExcludeCipherSuites(SvaConstants.excludeCipherSuites);
        try {
            sslConnector.setKeystore(sslCtx.getKeyStore().getFile().getCanonicalPath());
        }
        catch (IOException e1) {
            log.error("failed to get keystore path", e1);
            throw new RuntimeException(e1);
        }
        sslConnector.setPassword(sslCtx.getKeyStorePassword());
        sslConnector.setKeyPassword(sslCtx.getKeyStorePassword());
        this.wsServer = new Server();
        this.wsServer.addConnector(sslConnector);
        ServletContextHandler root = new ServletContextHandler(this.wsServer, "/", 1);
        ServletHolder holder = new ServletHolder(new AxisServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
                if (req instanceof Request) {
                    Request request = (Request)req;
                    sessionHolder.set(request.getSession(true));
                    sessionMgrHolder.set(request.getSessionManager());
                }
                super.service(req, res);
            }

            @Override
            protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
                MessagingInterfaceImpl.this.wsContext = super.initConfigContext(config);
                try {
                    AxisService svaservice = MessagingInterfaceImpl.this.wsContext.getAxisConfiguration().getService(MessagingInterfaceImpl.SVA_WEBSERVICE_NAME);
                    svaservice.addParameter("ServiceObjectSupplier", ServiceObjectSupplier.class.getName());
                    svaservice.addParameter(MessagingInterfaceImpl.MESSAGING_INTERFACE_IMPL, MessagingInterfaceImpl.this);
                    svaservice.setScope("transportsession");
                    AxisService psvaservice = MessagingInterfaceImpl.this.wsContext.getAxisConfiguration().getService(MessagingInterfaceImpl.PSEUDOSVA_WEBSERVICE_NAME);
                    psvaservice.addParameter("ServiceObjectSupplier", ServiceObjectSupplier.class.getName());
                    psvaservice.addParameter(MessagingInterfaceImpl.MESSAGING_INTERFACE_IMPL, MessagingInterfaceImpl.this);
                    psvaservice.setScope("transportsession");
                    AxisService sasservice = MessagingInterfaceImpl.this.wsContext.getAxisConfiguration().getService(MessagingInterfaceImpl.SAS_WEBSERVICE_NAME);
                    sasservice.addParameter("ServiceObjectSupplier", ServiceObjectSupplier.class.getName());
                    sasservice.addParameter(MessagingInterfaceImpl.MESSAGING_INTERFACE_IMPL, MessagingInterfaceImpl.this);
                    sasservice.setScope("transportsession");
                }
                catch (Exception e) {
                    log.error("failed to init configContext", e);
                    throw new RuntimeException(e);
                }
                return MessagingInterfaceImpl.this.wsContext;
            }
        });
        root.addServlet(holder, "/services/*");
        holder.setInitParameter("axis2.repository.path", repositoryFileName);
        holder.setInitParameter("axis2.xml.path", repositoryFileName + File.separatorChar + "axis2.xml");
        try {
            this.wsServer.start();
            if (log.isInfoEnabled()) {
                log.info("web service started.");
            }
        }
        catch (Exception e) {
            log.error("failed to start jetty", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public MessagingServiceInfo getMessagingServiceInfo(ServiceInterface service) {
        return null;
    }

    @Override
    public void restartMessagingService(ServiceInterface service) {
    }

    @Override
    public void startMessagingService(ServiceInterface service) {
        if (service instanceof SasInterface) {
            this.sas = (SasInterface)service;
            this.sasController.enableService();
            if (log.isInfoEnabled()) {
                log.info("SAS web service is enabled");
            }
        } else if (service instanceof SvaInterface) {
            this.sva = (SvaInterface)service;
            this.svaController.enableService();
            if (log.isInfoEnabled()) {
                log.info("SVA web service is enabled");
            }
        } else if (service instanceof PseudosvaInterface) {
            this.psva = (PseudosvaInterface)service;
            this.psvaController.enableService();
            if (log.isInfoEnabled()) {
                log.info("PseudoSVA web service is enabled");
            }
        }
    }

    @Override
    public void stopMessagingService(ServiceInterface service) {
        if (service instanceof SasInterface) {
            this.svaController.disableService();
        } else if (service instanceof SvaInterface) {
            this.sasController.disableService();
        } else if (service instanceof PseudosvaInterface) {
            this.psvaController.disableService();
            log.info("PseudoSVA web service is disabled");
        }
    }

    @Override
    public void sendEvent(AbstractManagementEvent event) {
        TopicPublisher publisher = null;
        if (event instanceof AbstractSvaManagementEvent) {
            publisher = (TopicPublisher)this.ctx.getBean("nodeTopicPublisher");
        } else if (event instanceof AbstractSasManagementEvent) {
            publisher = (TopicPublisher)this.ctx.getBean("clusterTopicPublisher");
        }
        if (publisher != null) {
            BaseMessage message = new BaseMessage(event);
            publisher.produce(message);
        } else {
            log.error("failed to get JMS publisher");
        }
    }

    public static class ServiceObjectSupplier {
        public Object getServiceObject(AxisService axisService) {
            if (axisService.getName().equals(MessagingInterfaceImpl.SVA_WEBSERVICE_NAME)) {
                if (log.isInfoEnabled()) {
                    log.info("getServiceObject: svaservice");
                }
                MessagingInterfaceImpl impl = (MessagingInterfaceImpl)axisService.getParameter(MessagingInterfaceImpl.MESSAGING_INTERFACE_IMPL).getValue();
                SvaserviceSkeleton svaService = new SvaserviceSkeleton(impl);
                if (impl.sva != null) {
                    svaService.setSvaInterface(impl.sva);
                }
                return svaService;
            }
            if (axisService.getName().equals(MessagingInterfaceImpl.PSEUDOSVA_WEBSERVICE_NAME)) {
                if (axisService.getName().equals(MessagingInterfaceImpl.PSEUDOSVA_WEBSERVICE_NAME)) {
                    if (log.isInfoEnabled()) {
                        log.info("getServiceObject: pseudosvaservice");
                    }
                    MessagingInterfaceImpl impl = (MessagingInterfaceImpl)axisService.getParameter(MessagingInterfaceImpl.MESSAGING_INTERFACE_IMPL).getValue();
                    PseudosvaserviceSkeleton psvaService = new PseudosvaserviceSkeleton(impl);
                    if (impl.psva != null) {
                        psvaService.setPseudosvaInterface(impl.psva);
                    }
                    return psvaService;
                }
            } else if (axisService.getName().equals(MessagingInterfaceImpl.SAS_WEBSERVICE_NAME)) {
                if (log.isInfoEnabled()) {
                    log.info("getServiceObject: sasservice");
                }
                MessagingInterfaceImpl impl = (MessagingInterfaceImpl)axisService.getParameter(MessagingInterfaceImpl.MESSAGING_INTERFACE_IMPL).getValue();
                SasserviceSkeleton sasService = new SasserviceSkeleton(impl);
                if (impl.sas != null) {
                    sasService.setSasInterface(impl.sas);
                }
                return sasService;
            }
            log.error("No serviceObject for " + axisService.getName());
            return null;
        }
    }
}

