/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.webservice;

import com.vmware.sva.messaging.ws.model.AbstractStorageEntity;
import com.vmware.sva.messaging.ws.model.MapEntry;
import com.vmware.sva.messaging.ws.model.NetworkInterface;
import com.vmware.sva.messaging.ws.model.NfsAccessControl;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.StorageCluster;
import com.vmware.sva.messaging.ws.model.SvaServerInfo;
import com.vmware.sva.messaging.ws.model.TaskRef;
import com.vmware.sva.messaging.ws.model.TaskStatus;
import com.vmware.sva.messaging.ws.sas.LoginFailedException;
import com.vmware.sva.messaging.ws.sas.NoPermissionException;
import com.vmware.sva.messaging.ws.sas.SasserviceStub;
import com.vmware.sva.webservice.WebServiceInterfaceFactory;
import com.vmware.sva.webservice.interfaces.SasWebServiceInterface;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;

public class SasWebServiceInterfaceImpl
implements SasWebServiceInterface {
    private SasserviceStub sasclient = null;

    @Override
    public PingResult wsPing() throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException {
        PingResult pingResult = null;
        if (this.sasclient != null) {
            pingResult = this.sasclient.ping();
        }
        return pingResult;
    }

    @Override
    public StorageCluster svaWSStorageClusterInfo() throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        StorageCluster cluster = null;
        if (this.sasclient != null) {
            cluster = this.sasclient.getStorageCluster();
        }
        return cluster;
    }

    @Override
    public void connect(String webServUrl) throws com.vmware.sva.messaging.ws.sas.Exception, AxisFault {
        if (this.sasclient == null) {
            this.sasclient = new SasserviceStub(webServUrl);
            WebServiceInterfaceFactory.updateStub(this.sasclient, 0, "8443");
        }
    }

    @Override
    public void login(String username, String passwd) throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, LoginFailedException {
        this.sasclient.login(username, passwd);
    }

    @Override
    public void repairPseudoSva() throws RemoteException, com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException {
        if (this.sasclient != null) {
            this.sasclient.repairPseudoSva();
        }
    }

    @Override
    public SvaServerInfo svaWSGetSvaServerInfo(String svaId) throws RemoteException, com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException {
        SvaServerInfo serverInfo = null;
        if (this.sasclient != null) {
            serverInfo = this.sasclient.getSvaServer(svaId);
        }
        return serverInfo;
    }

    @Override
    public TaskRef[] getTaskList() throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        TaskRef[] refs = null;
        if (this.sasclient != null) {
            refs = this.sasclient.getTaskList();
        }
        return refs;
    }

    @Override
    public TaskStatus getTaskStatus(String taskId) throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        TaskStatus tstatus = null;
        if (this.sasclient != null) {
            tstatus = this.sasclient.getTaskStatus(taskId);
        }
        return tstatus;
    }

    @Override
    public AbstractStorageEntity getStorageEntity(String seId) throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        AbstractStorageEntity storageEntity = null;
        if (this.sasclient != null) {
            storageEntity = this.sasclient.getStorageEntity(seId);
        }
        return storageEntity;
    }

    @Override
    public void renameStorageCluster(String clustName) throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        if (this.sasclient != null) {
            this.sasclient.renameStorageCluster(clustName);
        }
    }

    @Override
    public TaskRef changePassword(String user, String oldpass, String newpass) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        TaskRef taskref = null;
        if (this.sasclient != null) {
            taskref = this.sasclient.changePassword(user, oldpass, newpass);
        }
        return taskref;
    }

    @Override
    public TaskRef replaceMember(String origSvaId, String newSvaId) throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        TaskRef taskRef = null;
        if (this.sasclient != null) {
            taskRef = this.sasclient.replaceStorageClusterMember(origSvaId, newSvaId);
        }
        return taskRef;
    }

    @Override
    public void close() throws Exception {
        if (this.sasclient != null) {
            this.sasclient._getServiceClient().cleanup();
        }
    }

    @Override
    public void confirmStorageClusterNetworkConfig(String taskId) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            this.sasclient.confirmStorageClusterNetworkConfig(taskId);
        }
    }

    @Override
    public TaskRef exitStorageClusterMaintenanceMode() throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            return this.sasclient.exitStorageClusterMaintenanceMode();
        }
        return null;
    }

    @Override
    public TaskRef gatherDiagnosticInfo() throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            return this.sasclient.gatherDiagnosticInfo();
        }
        return null;
    }

    @Override
    public InputStream getDiagnosticInfo() throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            try {
                DataHandler diagnosticInfo = this.sasclient.getDiagnosticInfo();
                return diagnosticInfo.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public TaskRef renameStorageClusterMember(String svaId, String name) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            return this.sasclient.renameStorageClusterMember(svaId, name);
        }
        return null;
    }

    @Override
    public TaskRef setStorageClusterNetworkConfig(NetworkInterface networkConfig, long timeout) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            return this.sasclient.setStorageClusterNetworkConfig(networkConfig, timeout);
        }
        return null;
    }

    @Override
    public void setStorageEntityAccessControlList(String storageEntityId, NfsAccessControl[] acl) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            this.sasclient.setStorageEntityAccessControlList(storageEntityId, acl);
        }
    }

    @Override
    public TaskRef setStorageEntityNetworkConfig(String storageEntityId, NetworkInterface networkConig) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            return this.sasclient.setStorageEntityNetworkConfig(storageEntityId, networkConig);
        }
        return null;
    }

    @Override
    public TaskRef enterStorageClusterMaintenanceMode(boolean stopSvaService) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            return this.sasclient.enterStorageClusterMaintenanceMode(stopSvaService);
        }
        return null;
    }

    @Override
    public TaskRef shutdownStorageClusterMember(String svaId, boolean maintenanceMode) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient != null) {
            return this.sasclient.shutdownStorageClusterMember(svaId, maintenanceMode);
        }
        return null;
    }

    @Override
    public Map<String, Object> getAllParameters() throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        if (this.sasclient == null) {
            return null;
        }
        MapEntry[] mapEntries = this.sasclient.getAllParameters();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (MapEntry me : mapEntries) {
            map.put(me.getKey(), me.getValue());
        }
        return map;
    }

    @Override
    public Object getParameter(String name) throws com.vmware.sva.messaging.ws.sas.Exception, RemoteException, NoPermissionException {
        if (this.sasclient == null) {
            return null;
        }
        MapEntry me = this.sasclient.getParameter(name);
        return me.getValue();
    }

    @Override
    public void setParameter(String name, Object value) throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient == null) {
            return;
        }
        this.sasclient.setParameter(name, value);
    }

    @Override
    public TaskRef growStorage() throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient == null) {
            return null;
        }
        return this.sasclient.growStorage();
    }

    @Override
    public void repairCluster() throws com.vmware.sva.messaging.ws.sas.Exception, NoPermissionException, RemoteException {
        if (this.sasclient == null) {
            return;
        }
        this.sasclient.repairCluster();
    }
}

