/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.webservice;

import com.vmware.sva.jms.ManagementClientEventListener;
import com.vmware.sva.messaging.ws.model.AbstractExport;
import com.vmware.sva.messaging.ws.model.AbstractStorageEntity;
import com.vmware.sva.messaging.ws.model.Disk;
import com.vmware.sva.messaging.ws.model.ExceptionMsg;
import com.vmware.sva.messaging.ws.model.IPv4Address;
import com.vmware.sva.messaging.ws.model.MemberSva;
import com.vmware.sva.messaging.ws.model.MemberSvaConfig;
import com.vmware.sva.messaging.ws.model.NFSv3Export;
import com.vmware.sva.messaging.ws.model.NFSv3ExportConfig;
import com.vmware.sva.messaging.ws.model.NFSv3StorageEntity;
import com.vmware.sva.messaging.ws.model.NFSv3StorageEntityConfig;
import com.vmware.sva.messaging.ws.model.NetConfigProtocol;
import com.vmware.sva.messaging.ws.model.NetworkInterface;
import com.vmware.sva.messaging.ws.model.NetworkState;
import com.vmware.sva.messaging.ws.model.NfsAccessControl;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.PseudoSvaServerInfo;
import com.vmware.sva.messaging.ws.model.StorageCluster;
import com.vmware.sva.messaging.ws.model.StorageClusterConfig;
import com.vmware.sva.messaging.ws.model.StorageEntityNetworkReconfig;
import com.vmware.sva.messaging.ws.model.StoragePool;
import com.vmware.sva.messaging.ws.model.SvaServerInfo;
import com.vmware.sva.messaging.ws.model.TaskRef;
import com.vmware.sva.messaging.ws.model.TaskStatus;
import com.vmware.sva.messaging.ws.model.Volume;
import com.vmware.sva.messaging.ws.model.VolumeState;
import com.vmware.sva.messaging.ws.pseudosva.Exception;
import com.vmware.sva.messaging.ws.pseudosva.ExecuteResponse;
import com.vmware.sva.messaging.ws.sas.NoPermissionException;
import com.vmware.sva.webservice.PseudosvaWebServiceInterfaceImpl;
import com.vmware.sva.webservice.WebServiceInterfaceFactory;
import com.vmware.sva.webservice.interfaces.PseudosvaWebServiceInterface;
import com.vmware.sva.webservice.interfaces.SasWebServiceInterface;
import com.vmware.sva.webservice.interfaces.SvaWebServiceInterface;
import com.vmware.sva.webservice.interfaces.WebServiceInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public final class SvaWebserviceInterfaceCli {
    private static final String FAULT_USAGE = "fault clear [-name <name>]\nfault crash\nfault hang\nfault list [-name <name>]\nfault reset [-name <name>]\nfault saveAll\nfault set -name <name> [-repeat <repeat-count>] [-skip <skip-count>]\n  [-delay <delay-in-seconds>] [-reboot | -noreboot]\nfault set -name blc.edge [-repeat <repeat-count>] [-skip <skip-count>]\n  [-delay <delay-in-seconds>] [-reboot | -noreboot]\n  [-blcClass <classname>] [-blcState <state-number>]\n  [-eventClass <classname>] [-failNextPlatformCommand <boolean>]\nfault ssh <boolean>\n";
    static final String PERMISSIONS_DOC = "The permission string must consist of a single digit. Which represents everyone's (other users)\npermissions. The least significant bit of the digit represents 'execute' permission, the\nsecond least significant bit represents 'write' permission and the third one represents\n'read' permission.\n\nThe owner always has all permissions, i.e. read, write and execute.\n\nExamples:\n\"4\" - grants all permissions to the owner and read permission to everyone else.\n\"0\" - grants all permissions to the owner and no permissions to everyone else.\n\n";
    static final String REMOTE_PATH_DOC = "The remote path can be a relative or an absolute one. If the path is a relative one then it is\nrelative to the work folder of the VSA Cluster Service, which is $PRODUCT_DIR/bin,\nwhere $PRODUCT_DIR is the product installation directory.\n\n";
    private static StorageClusterConfig clusterConfig;
    private static Double versionSupportingRepair;
    private static Date startTime;
    private static String commandName;
    private static String WARNING_TAG;
    private static String password;
    private static String mgmtIp;
    private static Long REPAIR_WAIT_MS;

    private SvaWebserviceInterfaceCli() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int exitCode = -7;
        WebServiceInterface m = null;
        try {
            String command;
            int passIndex;
            ArrayList<String> params = new ArrayList<String>(Arrays.asList(args));
            IPv4Address addr = new IPv4Address();
            if (params.size() > 0 && !"help".equalsIgnoreCase((String)params.get(0))) {
                addr.setIPAddress((String)params.remove(0));
            }
            if ((passIndex = params.indexOf("-pass")) != -1) {
                params.remove(passIndex);
                SvaWebserviceInterfaceCli.setPassword((String)params.remove(passIndex));
            }
            commandName = command = (String)params.remove(0);
            CommandInfo commandInfo = CommandInfo.get(command);
            if (commandInfo == null) {
                throw new UsageException("Unknown command: " + command);
            }
            if (!CommandType.CLIENT.equals((Object)commandInfo.commandType)) {
                String serviceType = commandInfo.commandType.toString().toLowerCase();
                m = WebServiceInterfaceFactory.getWSInterface(serviceType);
                m.connect(SvaWebserviceInterfaceCli.getWebServicesUrl(m, addr.getIPAddress(), serviceType + "service"));
                m.login("svaadmin", password);
            }
            exitCode = commandInfo.call(m, addr.getIPAddress(), params.toArray(new String[params.size()]));
            return;
        }
        catch (com.vmware.sva.messaging.ws.sas.Exception e) {
            e.printStackTrace();
            System.err.println(SvaWebserviceInterfaceCli.getSasExceptionMessage(e));
            exitCode = -7;
            return;
        }
        catch (com.vmware.sva.messaging.ws.sva.Exception e) {
            e.printStackTrace();
            System.err.println(SvaWebserviceInterfaceCli.getSvaExceptionMessage(e));
            exitCode = -7;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(SvaWebserviceInterfaceCli.getPsvaExceptionMessage(e));
            exitCode = -7;
            return;
        }
        catch (IndexOutOfBoundsException aiobe) {
            SvaWebserviceInterfaceCli.printUsage();
            exitCode = -5;
            return;
        }
        catch (UsageException ue) {
            if (ue.getMessage() != null) {
                System.err.println(ue.getMessage());
            }
            if (ue.getCause() != null) {
                System.err.println(ue.getCause().toString());
            }
            SvaWebserviceInterfaceCli.printUsage();
            exitCode = -5;
            return;
        }
        catch (UnknownHostException e) {
            System.err.println(e.getMessage());
            exitCode = -6;
            return;
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
            System.err.println("Failed to perform operation: " + e.getMessage());
            exitCode = -4;
            return;
        }
        finally {
            try {
                if (m != null) {
                    m.close();
                }
            }
            catch (java.lang.Exception e) {
                e.printStackTrace();
                System.err.println("Failed to terminate web service Session.");
                if (exitCode == 0) {
                    exitCode = -7;
                }
            }
            finally {
                if (exitCode != 0) {
                    System.exit(exitCode);
                }
            }
        }
    }

    private static int pingsva(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("pingsva", args));
        }
        return SvaWebserviceInterfaceCli.printPingResult(m.wsPing(), 1);
    }

    private static int createCluster(WebServiceInterface m, String ipAddress, String[] args) throws UsageException, UnknownHostException, java.lang.Exception {
        MemberSvaConfig[] svaconfigs;
        SvaWebServiceInterface wsiface = (SvaWebServiceInterface)m;
        if (args.length < 3) {
            throw new UsageException("Too few arguments to 'create'\nCommand usage:\ncreate <cluster-name> <mgmt-address/prefix>  [-vcs <vcs-ip-address>]\n  [<member-address> <member-internal-address/prefix>\n   <storage-entity-access-address/prefix>]...\n  [-acl <nfs-client-ip-address>...]\ncreate <cluster-name> <mgmt-address/prefix>  [-vcs <vcs-ip-address>]\n  [-inet <internal-network-address/prefix>] [<member-address>...]\n  [-acl <nfs-client-ip-address>...]");
        }
        StorageClusterConfig config = SvaWebserviceInterfaceCli.getStorageConfig(args);
        UUID taskId = UUID.randomUUID();
        for (MemberSvaConfig svaconfig : svaconfigs = config.getMembers()) {
            String brokerIp = svaconfig.getMgmtAddress().getIPAddress();
            new ManagementClientEventListener(brokerIp, "svaadmin", password, true);
        }
        SvaWebserviceInterfaceCli.setClusterConfig(config);
        Date before = new Date();
        TaskRef taskRef = wsiface.svaWSCreateStorageCluster(taskId.toString(), config);
        Date after = new Date();
        System.out.println("Task ID = " + taskRef.getTaskId().toString());
        System.out.format("[createStorageCluster web method took %.3f seconds.]", (double)(after.getTime() - before.getTime()) / 1000.0);
        return 0;
    }

    private static int repairCluster(WebServiceInterface m, String ipAddress, String[] args) throws UsageException, UnknownHostException, java.lang.Exception {
        try {
            SasWebServiceInterface wsiface = (SasWebServiceInterface)m;
            System.out.println(WARNING_TAG + "Attempting to repair cluster. This operation may take several minutes to " + "complete. Do not suspend or kill the process while this program is running.\n");
            if (args.length != 0) {
                throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("repairCluster", args));
            }
            System.out.println("Getting Storage Cluster");
            StorageCluster storageCluster = wsiface.svaWSStorageClusterInfo();
            try {
                SvaWebserviceInterfaceCli.verifySvaVersionForRepair(storageCluster);
            }
            catch (UsageException e) {
                throw e;
            }
            catch (java.lang.Exception e) {
                throw new java.lang.Exception("Verify that all nodes are online before attempting Repair", e);
            }
            System.out.println("Issuing Repair Cluster\n");
            try {
                wsiface.repairCluster();
            }
            catch (java.lang.Exception e) {
                System.out.println(e);
            }
            SvaWebserviceInterfaceCli.recreateHelper(storageCluster);
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
            System.out.println("------------------------------------------------");
            System.err.println(e);
        }
        return 0;
    }

    private static int recreateCluster(WebServiceInterface m, String ipAddress, String[] args) throws UsageException, UnknownHostException, java.lang.Exception {
        try {
            SvaWebServiceInterface wsiface = (SvaWebServiceInterface)m;
            System.out.println(WARNING_TAG + "Attempting to recreate cluster. This operation may take several minutes to complete. " + "Do not suspend or kill the process while this program is running.\n");
            if (args.length != 0) {
                throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("recreateCluster", args));
            }
            SvaWebserviceInterfaceCli.verifySvaVersionForRepair(wsiface);
            System.out.println("Validating nodes for recreate\n");
            StorageCluster storageCluster = wsiface.validateSvaForRecreate();
            if (storageCluster == null) {
                throw new UsageException("Cluster is not ready for ReCreate, this operation can only be performed if a repairCluster request had been issued, but failed/aborted. Try repairCluster");
            }
            SvaWebserviceInterfaceCli.recreateHelper(storageCluster);
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
            System.out.println("------------------------------------------------");
            System.err.println(e);
        }
        return 0;
    }

    private static void recreateHelper(StorageCluster storageCluster) throws InterruptedException, java.lang.Exception {
        String taskId = storageCluster.getId();
        SvaWebserviceInterfaceCli.setMgmtIp(storageCluster.getManagementInterface().getIpAddress().getIPAddress());
        System.out.println("Waiting for VSA nodes to reboot, this may take a few minutes...\n");
        Thread.sleep(REPAIR_WAIT_MS);
        ArrayList<MemberSva> memberSvaOffline = new ArrayList<MemberSva>(Arrays.asList(storageCluster.getMembers()));
        String serviceType = CommandType.SVA.toString().toLowerCase();
        SvaWebServiceInterface svaInterface = (SvaWebServiceInterface)WebServiceInterfaceFactory.getWSInterface(serviceType);
        long verifyNodesStartTime = new Date().getTime();
        boolean membersOffline = true;
        do {
            Iterator iterator = memberSvaOffline.iterator();
            while (iterator.hasNext()) {
                MemberSva memberSva = (MemberSva)iterator.next();
                String memberIP = memberSva.getManagementInterface().getIpAddress().getIPAddress();
                String memberMsg = "Node " + memberIP;
                try {
                    svaInterface.connect(SvaWebserviceInterfaceCli.getWebServicesUrl(svaInterface, memberIP, serviceType + "service"));
                    svaInterface.login("svaadmin", password);
                    svaInterface.svaWSGetSvaServerInfo();
                    System.out.println(memberMsg + " is Online\n");
                    iterator.remove();
                }
                catch (java.lang.Exception e) {
                    System.out.println(memberMsg + " is not Online; retrying in " + REPAIR_WAIT_MS / 1000L + " seconds\n");
                    Thread.sleep(REPAIR_WAIT_MS);
                    break;
                }
            }
            if (memberSvaOffline.size() <= 0) {
                membersOffline = false;
            }
            System.out.println();
            long verifyNodesIterationTime = new Date().getTime();
            if (verifyNodesIterationTime - verifyNodesStartTime <= 600000L) continue;
            throw new UsageException("Not all VSA nodes have restarted in over 10 minutes. Verify that all nodes are Online and try recreateCluster.");
        } while (membersOffline);
        System.out.println("Registering for Events on VSA nodes, this may take a few minutes...\n");
        Thread.sleep(REPAIR_WAIT_MS);
        ArrayList<MemberSva> memberSvas = new ArrayList<MemberSva>(Arrays.asList(storageCluster.getMembers()));
        block6: do {
            Iterator iterator = memberSvas.iterator();
            while (iterator.hasNext()) {
                MemberSva memberSva = (MemberSva)iterator.next();
                try {
                    String brokerIp = memberSva.getManagementInterface().getIpAddress().getIPAddress();
                    System.out.println("Try " + brokerIp);
                    new ManagementClientEventListener(brokerIp, "svaadmin", password, true);
                    iterator.remove();
                }
                catch (java.lang.Exception e) {
                    Thread.sleep(2000L);
                    System.out.print("-");
                    continue block6;
                }
            }
        } while (memberSvas.size() > 0);
        System.out.println("Finished registering for events");
        String masterIP = "";
        UUID masterId = UUID.fromString(storageCluster.getMasterId());
        for (MemberSva memberSva : memberSvas) {
            UUID memberId = UUID.fromString(memberSva.getId());
            if (!memberId.equals(masterId)) continue;
            masterIP = memberSva.getManagementInterface().getIpAddress().getIPAddress();
            svaInterface.connect(SvaWebserviceInterfaceCli.getWebServicesUrl(svaInterface, masterIP, serviceType + "service"));
            svaInterface.login("svaadmin", password);
            System.out.println("Logged in to master; issuing ReCreateStorageClusterRequest");
            break;
        }
        TaskRef taskRef = svaInterface.svaWSRecreateStorageCluster(taskId);
        System.out.println("Issued ReCreateStorageCluster, this may take a few minutes...");
        System.out.println("Task ID = " + taskRef.getTaskId().toString());
    }

    private static void verifySvaVersionForRepair(StorageCluster storageCluster) throws UsageException, java.lang.Exception {
        String serviceType = CommandType.SVA.toString().toLowerCase();
        SvaWebServiceInterface svaInterface = (SvaWebServiceInterface)WebServiceInterfaceFactory.getWSInterface(serviceType);
        for (MemberSva memberSva : Arrays.asList(storageCluster.getMembers())) {
            String memberIP = memberSva.getManagementInterface().getIpAddress().getIPAddress();
            System.out.println("Invoking member IP-" + memberIP);
            svaInterface.connect(SvaWebserviceInterfaceCli.getWebServicesUrl(svaInterface, memberIP, serviceType + "service"));
            svaInterface.login("svaadmin", password);
            System.out.println("Logged in to server");
            Double thisVersion = SvaWebserviceInterfaceCli.parseMajorNumber(svaInterface.getSvaVersion());
            System.out.println("Got version " + thisVersion);
            if (!(thisVersion < versionSupportingRepair)) continue;
            throw new UsageException("Operation can only be performed on VSA cluster version " + String.valueOf(thisVersion) + " or later");
        }
    }

    private static void verifySvaVersionForRepair(SvaWebServiceInterface svaInterface) throws UsageException, java.lang.Exception {
        Double thisVersion = SvaWebserviceInterfaceCli.parseMajorNumber(svaInterface.getSvaVersion());
        if (thisVersion < versionSupportingRepair) {
            throw new UsageException("Operation can only be performed on VSA cluster version " + String.valueOf(thisVersion) + " or later");
        }
    }

    private static StorageClusterConfig getStorageConfig(String[] args) throws java.lang.Exception {
        StorageClusterConfig config;
        String name = args[0];
        NetworkInterface internalNetwork = null;
        try {
            if (args[1].indexOf(47) == -1) {
                args[1] = args[1] + "/24";
            }
            SvaWebserviceInterfaceCli.setMgmtIp(args[1].split("/")[0]);
            config = new StorageClusterConfig();
            config.setName(name);
            NetworkInterface mgmtInterface = SvaWebserviceInterfaceCli.getNetInterface(args[1]);
            config.setMgmtInterface(mgmtInterface);
            config.setPseudoSvaAddress(null);
        }
        catch (java.lang.Exception e) {
            throw new UsageException("Invalid management address", e);
        }
        int aclIndex = -1;
        for (int j = 2; j < args.length; ++j) {
            if (!args[j].equals("-acl")) continue;
            aclIndex = j;
            break;
        }
        if (aclIndex == -1) {
            throw new UsageException("Must specify a trailing ACL list using -acl <ip-address>...");
        }
        ArrayList<String> aclEntries = new ArrayList<String>();
        for (int i = aclIndex + 1; i < args.length; ++i) {
            aclEntries.addAll(Arrays.asList(args[i].split("[,\\s]+")));
        }
        NfsAccessControl[] acl = new NfsAccessControl[aclEntries.size()];
        for (int i = 0; i < aclEntries.size(); ++i) {
            IPv4Address ipaddr = new IPv4Address();
            ipaddr.setIPAddress((String)aclEntries.get(i));
            acl[i] = new NfsAccessControl();
            acl[i].setIpAddress(ipaddr);
            acl[i].setReadWriteAccess(true);
        }
        String[] newArgs = Arrays.copyOfRange(args, 0, aclIndex);
        args = newArgs;
        for (int i = 2; i < args.length; ++i) {
            NetworkInterface internalInterface;
            IPv4Address addr;
            if (args[i].equals("-vcs")) {
                if (++i == args.length) {
                    throw new UsageException("Missing VSA Cluster Service address");
                }
                if (config.getPseudoSvaAddress() != null) {
                    throw new UsageException("Multiple VSA cluster service addresses specified");
                }
                addr = new IPv4Address();
                addr.setIPAddress(args[i]);
                config.setPseudoSvaAddress(addr);
                continue;
            }
            if (args[i].equals("-inet")) {
                if (++i == args.length) {
                    throw new UsageException("No internal network address specified!");
                }
                internalNetwork = new NetworkInterface();
                NetworkInterface inet = SvaWebserviceInterfaceCli.getNetInterface(args[i]);
                internalNetwork.setIpAddress(inet.getIpAddress());
                internalNetwork.setIpPrefix(inet.getIpPrefix());
                continue;
            }
            addr = new IPv4Address();
            addr.setIPAddress(args[i]);
            SvaWebServiceInterface ws2 = (SvaWebServiceInterface)WebServiceInterfaceFactory.getWSInterface("sva");
            ws2.connect(SvaWebserviceInterfaceCli.getWebServicesUrl(ws2, addr.getIPAddress(), "svaservice"));
            ws2.login("svaadmin", password);
            SvaServerInfo svaServerInfo = ws2.svaWSGetSvaServerInfo();
            UUID svaId = UUID.fromString(svaServerInfo.getId());
            IPv4Address mgmtAddress = svaServerInfo.getManagementInterface().getIpAddress();
            if (internalNetwork != null) {
                internalInterface = new NetworkInterface();
                IPv4Address intAddr = new IPv4Address();
                intAddr.setIPAddress(SvaWebserviceInterfaceCli.getNextIpAddr(internalNetwork.getIpAddress().getIPAddress()));
                internalInterface.setIpAddress(intAddr);
                internalInterface.setIpPrefix(internalNetwork.getIpPrefix());
                internalInterface.setState(NetworkState.UP);
                internalInterface.setNetConfigProtocol(NetConfigProtocol.NONE);
                internalNetwork = internalInterface;
            } else {
                if (++i >= args.length) {
                    throw new UsageException("Missing internal network");
                }
                internalInterface = SvaWebserviceInterfaceCli.getNetInterface(args[i]);
            }
            MemberSvaConfig mConfig = new MemberSvaConfig();
            mConfig.setSvaId(svaId.toString());
            mConfig.setMgmtAddress(mgmtAddress);
            mConfig.setBackendInterface(internalInterface);
            config.addMembers(mConfig);
            NFSv3StorageEntityConfig sec = new NFSv3StorageEntityConfig();
            if (++i >= args.length) {
                throw new UsageException("Missing storage entity access interface");
            }
            sec.setAccessInterface(SvaWebserviceInterfaceCli.getNetInterface(args[i]));
            NFSv3ExportConfig nec = new NFSv3ExportConfig();
            nec.setVolumeConfig(null);
            nec.setExportPath(null);
            nec.setAcl(acl);
            sec.addExports(nec);
            config.addStorageEntities(sec);
        }
        return config;
    }

    private static synchronized void setClusterConfig(StorageClusterConfig config) {
        clusterConfig = config;
    }

    private static synchronized void setMgmtIp(String mip) {
        mgmtIp = mip;
    }

    private static String getNextIpAddr(String ipaddr) {
        String nextIp = null;
        try {
            InetAddress addr = Inet4Address.getByName(ipaddr);
            byte[] bytes = addr.getAddress();
            int host = bytes[3];
            bytes[3] = (byte)(++host);
            addr = Inet4Address.getByAddress(bytes);
            nextIp = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return nextIp;
    }

    private static int getSvaServerInfo(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("getSvaServerInfo", args));
        }
        SvaWebserviceInterfaceCli.printSvaServerInfo(((SvaWebServiceInterface)m).svaWSGetSvaServerInfo());
        return 0;
    }

    private static int getSvaVersion(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length > 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("getSvaVersion", args));
        }
        SvaWebServiceInterface wsi = (SvaWebServiceInterface)m;
        String svaVersion = wsi.getSvaVersion();
        System.out.println("SVA Version: " + svaVersion);
        return 0;
    }

    private static int shutdownSvaServer(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length > 1) {
            throw new UsageException("Too many arguments: " + SvaWebserviceInterfaceCli.formatCommand("shutdownSvaServer", args) + "\nCommand usage: shutdownSvaServer [<boolean:maintenance-mode=false>]");
        }
        SvaWebServiceInterface swsi = (SvaWebServiceInterface)m;
        boolean maintenanceMode = args.length == 1 && SvaWebserviceInterfaceCli.parseBoolean(args[0]);
        swsi.shutdownSvaServer(maintenanceMode);
        return 0;
    }

    private static int exitMaintenanceMode(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length > 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("exitMaintenanceMode", args));
        }
        ((SvaWebServiceInterface)m).exitMaintenanceMode();
        return 0;
    }

    private static int svaReconfigureNetwork(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("reconfigureNetwork", args) + "\nCommand usage: reconfigureNetwork <network-config.properties>");
        }
        Properties props = new Properties();
        props.load(new FileInputStream(args[0]));
        NetworkInterface mgmtInterface = SvaWebserviceInterfaceCli.getNetInterface(props.getProperty("mgmt-interface"));
        System.out.println("MGMT INTERFACE: " + mgmtInterface.getIpAddress().getIPAddress() + "/" + mgmtInterface.getIpPrefix());
        IPv4Address pseudoSvaAddress = null;
        if (props.containsKey("vsa-mgr-service-address")) {
            pseudoSvaAddress = new IPv4Address();
            pseudoSvaAddress.setIPAddress(props.getProperty("vsa-mgr-service-address"));
        }
        System.out.println("PSEUDO SVA: " + (pseudoSvaAddress != null ? pseudoSvaAddress.getIPAddress() : "null"));
        int i = 1;
        String propKey = "vsa" + i;
        ArrayList<MemberSvaConfig> members = new ArrayList<MemberSvaConfig>();
        while (props.containsKey(propKey + ".mgmt-address")) {
            IPv4Address mgmtAddress = new IPv4Address();
            mgmtAddress.setIPAddress(props.getProperty(propKey + ".mgmt-address"));
            NetworkInterface backendInteface = SvaWebserviceInterfaceCli.getNetInterface(props.getProperty(propKey + ".backend-interface"));
            MemberSvaConfig memberSvaConfig = new MemberSvaConfig();
            memberSvaConfig.setBackendInterface(backendInteface);
            memberSvaConfig.setMgmtAddress(mgmtAddress);
            members.add(memberSvaConfig);
            System.out.println(propKey + ":");
            System.out.println("\tmgmt address: " + mgmtAddress.getIPAddress());
            System.out.println("\tbackend interface: " + backendInteface.getIpAddress().getIPAddress() + "/" + backendInteface.getIpPrefix());
            propKey = "vsa" + ++i;
        }
        System.out.println("Total vsa members found: " + members.size());
        propKey = "storage-entity.access-control-list";
        if (!props.containsKey(propKey)) {
            String errMsg = "ERROR: network reconfig properties file must contain a '" + propKey + "' key/value pair.";
            throw new UsageException(errMsg);
        }
        ArrayList<NfsAccessControl> accessControlList = new ArrayList<NfsAccessControl>();
        String propVal = props.getProperty(propKey);
        for (String addr : propVal.split(" ")) {
            NfsAccessControl acl = new NfsAccessControl();
            IPv4Address acladdress = new IPv4Address();
            acladdress.setIPAddress(addr);
            acl.setIpAddress(acladdress);
            accessControlList.add(acl);
        }
        i = 1;
        propKey = "storage-entity" + i;
        ArrayList<StorageEntityNetworkReconfig> storageEntities = new ArrayList<StorageEntityNetworkReconfig>();
        while (props.containsKey(propKey + ".access-interface")) {
            NetworkInterface accessInteface = SvaWebserviceInterfaceCli.getNetInterface(props.getProperty(propKey + ".access-interface"));
            StorageEntityNetworkReconfig seConfig = new StorageEntityNetworkReconfig();
            seConfig.setAccessInterface(accessInteface);
            seConfig.setAccessControlList(accessControlList.toArray(new NfsAccessControl[0]));
            storageEntities.add(seConfig);
            System.out.println(propKey + ":");
            System.out.println("\taccess interface: " + accessInteface.getIpAddress().getIPAddress() + "/" + accessInteface.getIpPrefix());
            propKey = "storage-entity" + ++i;
        }
        System.out.println("Total storage entities found: " + storageEntities.size());
        assert (members.size() == storageEntities.size()) : "Number of storage entities must match number of members.";
        TaskRef taskRef = ((SvaWebServiceInterface)m).reconfigureNetwork(mgmtInterface, members, storageEntities, pseudoSvaAddress);
        System.out.println("BLC id = " + (taskRef != null ? taskRef.getTaskId() : "-null-"));
        return 0;
    }

    private static int svaGetDiagnosticInfo(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length > 1) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("svaGetDiagnosticInfo", args) + "\nCommand usage: svaGetDiagnosticInfo [<boolean:includeDump=false>]");
        }
        int BUF_SIZE = 1024;
        InputStream in = null;
        try {
            SvaWebServiceInterface wsi;
            if (m instanceof PseudosvaWebServiceInterfaceImpl) {
                wsi = (PseudosvaWebServiceInterface)m;
                in = wsi.getDiagnosticInfo();
            } else {
                wsi = (SvaWebServiceInterface)m;
                in = wsi.getDiagnosticInfo(args.length == 1 && SvaWebserviceInterfaceCli.parseBoolean(args[0]));
            }
        }
        catch (java.lang.Exception e) {
            throw new java.lang.Exception("Error while retrieving support bundle: " + e.getMessage(), e);
        }
        assert (in != null) : "getDiagnosticInfo() returned a null InputStream.";
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MMM.dd-HH.mm.ss");
        String outName = ipAddress + "-diag-info-" + formatter.format(now) + ".zip";
        FilterOutputStream bout = null;
        BufferedInputStream bin = null;
        try {
            FileOutputStream out = new FileOutputStream(outName);
            bout = new BufferedOutputStream(out);
            bin = new BufferedInputStream(in);
            byte[] buf = new byte[BUF_SIZE];
            int fileSize = 0;
            int bRead = 0;
            while ((bRead = bin.read(buf)) != -1) {
                ((BufferedOutputStream)bout).write(buf, 0, bRead);
                fileSize += bRead;
            }
            System.out.println("Wrote support bundle (" + fileSize + " bytes) to: " + outName);
        }
        catch (IOException e) {
            throw new java.lang.Exception("I/O Problem while reading support bundle: " + e.getMessage(), e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {}
            }
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return 0;
    }

    private static int faultInsertion(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length < 1) {
            throw new UsageException("Missing required arguments\nCommand usage:\nfault clear [-name <name>]\nfault crash\nfault hang\nfault list [-name <name>]\nfault reset [-name <name>]\nfault saveAll\nfault set -name <name> [-repeat <repeat-count>] [-skip <skip-count>]\n  [-delay <delay-in-seconds>] [-reboot | -noreboot]\nfault set -name blc.edge [-repeat <repeat-count>] [-skip <skip-count>]\n  [-delay <delay-in-seconds>] [-reboot | -noreboot]\n  [-blcClass <classname>] [-blcState <state-number>]\n  [-eventClass <classname>] [-failNextPlatformCommand <boolean>]\nfault ssh <boolean>\n");
        }
        SvaWebServiceInterface wsi = (SvaWebServiceInterface)m;
        ArrayList<String> cArgs = new ArrayList<String>();
        for (String arg : args) {
            cArgs.add(arg);
        }
        try {
            String response = wsi.faultInsertion(cArgs);
            if (response != null) {
                System.out.println(response);
            }
        }
        catch (com.vmware.sva.messaging.ws.sva.Exception e) {
            String error = SvaWebserviceInterfaceCli.getSvaExceptionMessage(e);
            System.err.println(error);
            if (!error.contains("Debugging Command Disabled")) {
                System.out.println(FAULT_USAGE);
            }
            return -5;
        }
        return 0;
    }

    private static int resetSva(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length > 1) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("reset", args) + "\nCommand usage: reset [boolean:force=false]");
        }
        boolean force = args.length == 1 && SvaWebserviceInterfaceCli.parseBoolean(args[0]);
        SvaWebServiceInterface svaWebServiceInterface = (SvaWebServiceInterface)m;
        svaWebServiceInterface.reset(force);
        return 0;
    }

    private static int listConstants(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("listConstants", args));
        }
        SvaWebServiceInterface wsi = (SvaWebServiceInterface)m;
        try {
            String response = wsi.listConstants();
            if (response != null) {
                System.out.println(response);
            }
        }
        catch (com.vmware.sva.messaging.ws.sva.Exception e) {
            System.err.println(SvaWebserviceInterfaceCli.getSvaExceptionMessage(e));
            return -5;
        }
        return 0;
    }

    private static int listDebug(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("listDebug", args));
        }
        SvaWebServiceInterface wsi = (SvaWebServiceInterface)m;
        try {
            String response = wsi.listDebug();
            if (response != null) {
                System.out.println(response);
            }
        }
        catch (com.vmware.sva.messaging.ws.sva.Exception e) {
            System.err.println(SvaWebserviceInterfaceCli.getSvaExceptionMessage(e));
            return -5;
        }
        return 0;
    }

    private static int pingsas(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("pingsas", args));
        }
        return SvaWebserviceInterfaceCli.printPingResult(m.wsPing(), 1);
    }

    private static int getTaskList(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("getTaskList", args));
        }
        TaskRef[] taskList = ((SasWebServiceInterface)m).getTaskList();
        if (taskList != null) {
            System.out.println("\tNumber of active tasks = " + taskList.length);
            for (TaskRef taskRef : taskList) {
                if (taskRef == null) continue;
                System.out.println("\t\t ID = " + taskRef.getTaskId());
            }
        } else {
            System.out.println("No tasks are running in SVA Server!\n");
        }
        return 0;
    }

    private static int sasGetTaskStatus(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasGetTaskStatus", args) + "\nCommand usage: sasGetTaskStatus <uuid:task-id>");
        }
        UUID taskId = UUID.fromString(args[0]);
        TaskStatus taskStatus = ((SasWebServiceInterface)m).getTaskStatus(taskId.toString());
        if (taskStatus != null) {
            System.out.println("Task ID = " + taskStatus.getTaskId());
            System.out.println("Start time = " + taskStatus.getStartTime());
            if (taskStatus.getCompletionTime() != null) {
                System.out.println("Completion time = " + taskStatus.getCompletionTime());
            }
            System.out.println("Progress = " + taskStatus.getProgress());
            System.out.println("Status time = " + taskStatus.getStatusTime());
            System.out.println("State = " + taskStatus.getState());
            if (taskStatus.getFailureException() != null) {
                System.out.println("Failure exception = " + taskStatus.getFailureException());
            }
            if (taskStatus.getResult() != null) {
                System.out.println("Result = " + taskStatus.getResult());
            }
        } else {
            System.out.println("No task status received for this task!\n");
        }
        return 0;
    }

    private static int sasGatherDiagnosticInfo(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasGatherDiagnosticInfo", args));
        }
        TaskRef taskRef = null;
        try {
            taskRef = ((SasWebServiceInterface)m).gatherDiagnosticInfo();
        }
        catch (java.lang.Exception e) {
            String msg = SvaWebserviceInterfaceCli.extractOriginalExceptionMsg(e);
            throw new java.lang.Exception("Error while gathering SAS support bundle: " + msg, e);
        }
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int sasGetDiagnosticInfo(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasGetDiagnosticInfo", args));
        }
        int BUF_SIZE = 1024;
        InputStream in = null;
        try {
            in = ((SasWebServiceInterface)m).getDiagnosticInfo();
        }
        catch (java.lang.Exception e) {
            String msg = SvaWebserviceInterfaceCli.extractOriginalExceptionMsg(e);
            throw new java.lang.Exception("Error while retrieving storage cluster support bundle: " + msg, e);
        }
        assert (in != null) : "sas.getDiagnosticInfo() returned a null InputStream.";
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MMM.dd-HH.mm.ss");
        String outName = "storage-cluster-" + ipAddress + "-" + formatter.format(now) + ".zip";
        FilterOutputStream bout = null;
        BufferedInputStream bin = null;
        try {
            FileOutputStream out = new FileOutputStream(outName);
            bout = new BufferedOutputStream(out);
            bin = new BufferedInputStream(in);
            byte[] buf = new byte[BUF_SIZE];
            int fileSize = 0;
            int bRead = 0;
            while ((bRead = bin.read(buf)) != -1) {
                ((BufferedOutputStream)bout).write(buf, 0, bRead);
                fileSize += bRead;
            }
            System.out.println("Wrote storage cluster support bundle (" + fileSize + " bytes) to: " + outName);
        }
        catch (IOException e) {
            throw new java.lang.Exception("I/O Problem while reading storage cluster support bundle: " + e.getMessage(), e);
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {}
            }
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return 0;
    }

    private static int sasGetAllParameters(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasGetAllParameters", args));
        }
        Map<String, Object> map = ((SasWebServiceInterface)m).getAllParameters();
        System.out.println("SAS parameter table");
        System.out.println("----------------------------------");
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object val = e.getValue();
            System.out.println("  " + e.getKey() + ":  " + val + " [" + val.getClass().getName() + "]");
        }
        return 0;
    }

    private static int sasSetParameter(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length < 1 || args.length > 3) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasSetParameter", args) + "\nCommand usage: sasSetParameter <param-name> [<param-value>" + " [<param-value-type>]]");
        }
        String name = args[0];
        String value = args.length >= 2 ? args[1] : null;
        String type = args.length >= 3 ? args[2] : "java.lang.String";
        Object inst = null;
        if (value != null) {
            Class<?> cls = Class.forName(type);
            Constructor<?> constr = cls.getConstructor(String.class);
            inst = constr.newInstance(value);
        }
        ((SasWebServiceInterface)m).setParameter(name, inst);
        System.out.format("name: %s; value: %s %s\n", name, inst, inst != null ? "[" + inst.getClass().getName() + "]" : "");
        return 0;
    }

    private static int sasGetParameter(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasGetParameter", args) + "\nCommand usage: sasGetParameter <param-name>");
        }
        Object val = ((SasWebServiceInterface)m).getParameter(args[0]);
        System.out.print(args[0] + ":  ");
        if (val != null) {
            System.out.println(val + " [" + val.getClass().getName() + "]");
        } else {
            System.out.println("null");
        }
        return 0;
    }

    private static int sasChangePassword(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 3) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasChangePassword", args) + "\nCommand usage: sasChangePassword <user> <old-password> <new-password>");
        }
        try {
            TaskRef taskref = ((SasWebServiceInterface)m).changePassword(args[0], args[1], args[2]);
            System.out.println("Task Id: " + taskref.getTaskId());
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int getStorageCluster(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        int i;
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("getStorageCluster", args));
        }
        StorageCluster storageCluster = ((SasWebServiceInterface)m).svaWSStorageClusterInfo();
        System.out.println("Storage Cluster ID = " + storageCluster.getId());
        System.out.println("Name = " + storageCluster.getName());
        System.out.println("Maintenance mode = " + storageCluster.getInMaintenanceMode());
        System.out.println("Management interface = " + SvaWebserviceInterfaceCli.interfaceString(storageCluster.getManagementInterface()));
        System.out.println("Master = " + storageCluster.getMasterId());
        IPv4Address pseudoSvaAddress = storageCluster.getPseudoSvaAddress();
        if (pseudoSvaAddress == null) {
            System.out.println("No VSA Cluster Service");
        } else {
            System.out.println("VSA Cluster Service address = " + pseudoSvaAddress.getIPAddress());
            System.out.println("VSA Cluster Service state = " + storageCluster.getPseudoSvaOnline());
        }
        long cap = storageCluster.getPhysicalCapacity();
        System.out.format("Physical capacity = %d KB (%.2f GB)\n", cap, (double)cap / 1024.0 / 1024.0);
        cap = storageCluster.getStorageCapacity();
        System.out.format("Storage capacity = %d KB (%.2f GB)\n", cap, (double)cap / 1024.0 / 1024.0);
        System.out.println("### Members:");
        List<MemberSva> members = Arrays.asList(storageCluster.getMembers());
        Collections.sort(members, new MemberSvaComparator());
        if (members != null) {
            i = 0;
            for (MemberSva member : members) {
                System.out.println("Member " + i++ + ":");
                SvaWebserviceInterfaceCli.printMember(member);
            }
        } else {
            System.out.println("\t<No Members>");
        }
        System.out.println("### Storage Entities:");
        List<AbstractStorageEntity> storageEntities = Arrays.asList(storageCluster.getStorageEntities());
        Collections.sort(storageEntities, new StorageEntityComparator());
        if (storageEntities != null) {
            i = 0;
            for (AbstractStorageEntity storageEntity : storageEntities) {
                System.out.println("Storage entity " + i++ + ":");
                SvaWebserviceInterfaceCli.printStorageEntity(storageEntity);
            }
        } else {
            System.out.println("\t<No Storage Entities>");
        }
        return 0;
    }

    private static int getExportPaths(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("getExportPaths", args));
        }
        StorageCluster svaWSStorageClusterInfo = ((SasWebServiceInterface)m).svaWSStorageClusterInfo();
        if (svaWSStorageClusterInfo.getStorageEntities() == null) {
            System.out.println("No exported Storage Entities found on the storage cluster!\n");
        } else {
            for (AbstractStorageEntity ent : svaWSStorageClusterInfo.getStorageEntities()) {
                String accessAddress = ent.getAccessInterface().getIpAddress().getIPAddress();
                for (AbstractExport exp : ent.getExports()) {
                    System.out.println(accessAddress + ":" + ((NFSv3Export)exp).getExportPath());
                }
            }
        }
        return 0;
    }

    private static int sasGetSvaServer(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("sasGetSvaServer", args) + "\nCommand usage: sasGetSvaServer <uuid:sva-id>");
        }
        UUID svaId = UUID.fromString(args[0]);
        SvaWebserviceInterfaceCli.printSvaServerInfo(((SasWebServiceInterface)m).svaWSGetSvaServerInfo(svaId.toString()));
        return 0;
    }

    private static int renameStorageCluster(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("renameStorageCluster", args) + "\nCommand usage: renameStorageCluster <new-name>");
        }
        ((SasWebServiceInterface)m).renameStorageCluster(args[0]);
        return 0;
    }

    private static int setStorageClusterNetworkConfig(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length < 1 || args.length > 2) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("setStorageClusterNetworkConfig", args) + "\nCommand usage: setStorageClusterNetworkConfig <mgmt-address/prefix>" + " [<long:timeout-in-ms=-1>]");
        }
        NetworkInterface networkConfig = SvaWebserviceInterfaceCli.getNetInterface(args[0]);
        long timeout = args.length == 2 ? Long.parseLong(args[1]) : -1L;
        TaskRef taskRef = ((SasWebServiceInterface)m).setStorageClusterNetworkConfig(networkConfig, timeout);
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int confirmStorageClusterNetworkConfig(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("confirmStorageClusterNetworkConfig", args) + "\nCommand usage: confirmStorageClusterNetworkConfig <uuid:task-id>");
        }
        ((SasWebServiceInterface)m).confirmStorageClusterNetworkConfig(args[0]);
        return 0;
    }

    private static int enterStorageClusterMaintenanceMode(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length > 1) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("enterStorageClusterMaintenanceMode", args) + "\nCommand usage: enterStorageClusterMaintenanceMode" + " [<boolean:stop-SvaServer=false]");
        }
        boolean stopSvaService = args.length == 1 && SvaWebserviceInterfaceCli.parseBoolean(args[0]);
        TaskRef taskRef = ((SasWebServiceInterface)m).enterStorageClusterMaintenanceMode(stopSvaService);
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int exitStorageClusterMaintenanceMode(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("exitStorageClusterMaintenanceMode", args));
        }
        TaskRef taskRef = ((SasWebServiceInterface)m).exitStorageClusterMaintenanceMode();
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int repairPseudoSva(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("repairVCS", args));
        }
        ((SasWebServiceInterface)m).repairPseudoSva();
        return 0;
    }

    private static int replaceMember(WebServiceInterface clusterInterface, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 2) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("replaceMember", args) + "\nCommand usage:" + "replaceMember <uuid:sva-id-to-replace> <new-sva-ip-address>");
        }
        SasWebServiceInterface sasWebServiceInterface = (SasWebServiceInterface)clusterInterface;
        String oldSvaId = args[0];
        String newSvaIp = args[1];
        WebServiceInterface m = WebServiceInterfaceFactory.getWSInterface("sva");
        m.connect(SvaWebserviceInterfaceCli.getWebServicesUrl(m, newSvaIp, "svaservice"));
        m.login("svaadmin", password);
        SvaServerInfo svaServerInfo = ((SvaWebServiceInterface)m).svaWSGetSvaServerInfo();
        String svaId = svaServerInfo.getId();
        TaskRef taskRef = sasWebServiceInterface.replaceMember(oldSvaId, svaId);
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int shutdownStorageClusterMember(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length < 1 || args.length > 2) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("shutdownStorageClusterMember", args) + "\nCommand usage: shutdownStorageClusterMember <uuid:sva-id>" + " [<boolean:maintenance-mode=false>]");
        }
        boolean maintenanceMode = args.length == 2 && SvaWebserviceInterfaceCli.parseBoolean(args[1]);
        TaskRef taskRef = ((SasWebServiceInterface)m).shutdownStorageClusterMember(args[0], maintenanceMode);
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int getStorageEntity(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("getStorageEntity", args) + "\nCommand usage: getStorageEntity <uuid:storage-entity-id>");
        }
        NFSv3StorageEntity nfsse = (NFSv3StorageEntity)((SasWebServiceInterface)m).getStorageEntity(args[0]);
        SvaWebserviceInterfaceCli.printStorageEntity(nfsse);
        return 0;
    }

    private static int setStorageEntityNetworkConfig(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 2) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("setStorageEntityNetworkConfig", args) + "\nCommand usage: setStorageEntityNetworkConfig <uuid:storage-entity-id>" + " <storage-entity-access-address/prefix>");
        }
        NetworkInterface networkConfig = SvaWebserviceInterfaceCli.getNetInterface(args[1]);
        TaskRef taskRef = ((SasWebServiceInterface)m).setStorageEntityNetworkConfig(args[0], networkConfig);
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int setStorageEntityExportACL(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length < 3 || !args[1].equals("-acl")) {
            throw new UsageException("Incorrect arguments: " + SvaWebserviceInterfaceCli.formatCommand("setStorageEntityExportACL", args) + "\nCommand usage: setStorageEntityExportACL <uuid:storage-entity-id>" + " -acl <nfs-client-ip-address> ...");
        }
        NfsAccessControl[] acl = new NfsAccessControl[args.length - 2];
        for (int i = 0; i < acl.length; ++i) {
            IPv4Address ipaddr = new IPv4Address();
            ipaddr.setIPAddress(args[i + 2]);
            acl[i] = new NfsAccessControl();
            acl[i].setIpAddress(ipaddr);
            acl[i].setReadWriteAccess(true);
        }
        ((SasWebServiceInterface)m).setStorageEntityAccessControlList(args[0], acl);
        return 0;
    }

    private static int growStorage(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("growStorage", args));
        }
        TaskRef taskRef = ((SasWebServiceInterface)m).growStorage();
        System.out.println("Task ID = " + taskRef.getTaskId());
        return 0;
    }

    private static int startListener(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("startListener", args));
        }
        System.out.println("Starting Listener on " + ipAddress + "....");
        new ManagementClientEventListener(ipAddress, "svaadmin", password, false);
        System.out.println("Listener started on " + ipAddress + "....");
        return 0;
    }

    private static int help(WebServiceInterface m, String ipAddress, String[] args) {
        Object command = null;
        if (args.length > 0) {
            CommandInfo commandInfo = CommandInfo.get(args[0]);
            if (commandInfo != null) {
                System.out.println("Command usage:");
                SvaWebserviceInterfaceCli.printlnTabs(commandInfo.usage);
                System.out.println();
                SvaWebserviceInterfaceCli.printlnTabs(commandInfo.doc);
                return 0;
            }
            System.out.println("Command not found: " + args[0]);
        }
        SvaWebserviceInterfaceCli.printUsage();
        return 0;
    }

    private static int vcsUploadFile(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 3) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <local file> <remote file> <permissions>. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).uploadFile(args[0], args[1], args[2]);
        return 0;
    }

    private static int vcsGetAvailableSpace(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: no additional arguments. Received", args));
        }
        long space = ((PseudosvaWebServiceInterface)m).getAvailableSpace();
        System.out.println("Available space is " + space + " kilobytes.");
        return 0;
    }

    private static int vcsGetProductDirectory(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: no additional arguments. Received", args));
        }
        String directory = ((PseudosvaWebServiceInterface)m).getProductDirectoryName();
        System.out.println("The product directory name is " + directory + ".");
        return 0;
    }

    private static int vcsCreateDirectory(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 2) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <directory name> <permissions>. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).createDirectory(args[0], args[1]);
        return 0;
    }

    private static int vcsCreateFile(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 2) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <file name> <permissions>. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).createFile(args[0], args[1]);
        return 0;
    }

    private static int vcsAppendToFile(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 2) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <local file> <remote file>. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).appendToFile(args[0], args[1]);
        return 0;
    }

    private static int vcsDeleteFile(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <remote file>. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).deleteFile(args[0]);
        return 0;
    }

    private static int vcsChangePermissions(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length < 2) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <remote file> <permissions> [recursive]. Received", args));
        }
        boolean recursive = args.length == 3 ? Boolean.valueOf(args[2]) : false;
        ((PseudosvaWebServiceInterface)m).changePermissions(args[0], args[1], recursive);
        return 0;
    }

    private static int vcsExecute(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        String standardInput;
        String[] parameters;
        boolean async;
        if (args.length < 1) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <remote file> [work directory] [async] [parameters] [stdin]. Received", args));
        }
        String filename = args[0];
        String workDirectory = args.length >= 2 ? args[1] : null;
        ExecuteResponse response = ((PseudosvaWebServiceInterface)m).execute(filename, workDirectory, async = args.length >= 3 ? Boolean.valueOf(args[2]) : false, parameters = args.length >= 4 ? args[3].split(" ") : null, standardInput = args.length >= 5 ? args[4] : null);
        if (response.getStdoutData() != null && response.getStdoutData().length() > 0) {
            System.out.println("Standard output result: " + response.getStdoutData());
        }
        System.out.println("Remote process return code: " + response.getErrorCode());
        return response.getErrorCode();
    }

    private static int vcsRestart(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: no additional arguments. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).restart();
        return 0;
    }

    private static int vcsEnterMaintenanceMode(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: <shutdown RMI>. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).enterMaintenanceMode(Boolean.valueOf(args[0]));
        return 0;
    }

    private static int vcsExitMaintenanceMode(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected: no additional arguments. Received", args));
        }
        ((PseudosvaWebServiceInterface)m).exitMaintenanceMode();
        return 0;
    }

    private static int getVCSInfo(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 1) {
            throw new UsageException("Unexpected arguments: " + SvaWebserviceInterfaceCli.formatCommand("Expected getVCSInfo IP: Received", args));
        }
        SvaWebserviceInterfaceCli.printPseudoSvaServerInfo(((PseudosvaWebServiceInterface)m).getPseudoSvaServerInfo(args[0]));
        return 0;
    }

    private static int destroyPseudoSva(WebServiceInterface m, String ipAddress, String[] args) throws java.lang.Exception {
        if (args.length != 0) {
            System.out.println("This method does not require any arguments. Ignoring..." + args[0]);
        }
        try {
            ((PseudosvaWebServiceInterface)m).destroyPseudoSva();
        }
        catch (java.lang.Exception e) {
            System.out.println("Failed to destroy cluster");
            throw e;
        }
        return 0;
    }

    private static void printPseudoSvaServerInfo(PseudoSvaServerInfo psva) {
        System.out.println("\tid = " + psva.getId());
        System.out.println("\tname = " + psva.getName());
        System.out.println("\tmaintenance mode = " + psva.getMaintenanceMode());
        System.out.println("\tRMI running = " + psva.getRmiRunning());
        System.out.println("\tDomain name = " + psva.getDomainName());
        System.out.println("\tStorage Cluster ID = " + psva.getStorageClusterId());
        String[] dnsServers = psva.getDnsServers();
        if (dnsServers == null) {
            System.out.println("\tNo DNS server");
        } else {
            System.out.print("\tDNS servers:");
            for (String dnsServer : dnsServers) {
                System.out.print(" " + dnsServer);
            }
            System.out.println();
        }
        NetworkInterface net = psva.getNetworkInterface();
        System.out.println("\tInterface name = " + net.getInterfaceName());
        System.out.println("\tIP address = " + net.getIpAddress().getIPAddress() + "/" + net.getIpPrefix());
        System.out.println("\tInterface state = " + net.getState());
    }

    private static void addPsvaCommand(String command, String method, String usage, String doc) {
        new CommandInfo(command, CommandType.PSEUDOSVA, method, usage, doc);
    }

    public static synchronized void validateCluster() {
        try {
            SasWebServiceInterface sasservice = (SasWebServiceInterface)WebServiceInterfaceFactory.getWSInterface("sas");
            sasservice.connect(SvaWebserviceInterfaceCli.getWebServicesUrl(sasservice, mgmtIp, "sasservice"));
            sasservice.login("svaadmin", password);
            sasservice.svaWSStorageClusterInfo();
        }
        catch (RemoteException e) {
            System.err.println("SAS RMI service is not available, create cluster failed!\n");
            e.printStackTrace();
            System.exit(-3);
        }
        catch (com.vmware.sva.messaging.ws.sas.Exception e) {
            System.err.println("Cluster creation failed!\n");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (NoPermissionException e) {
            System.err.println("Authentication to SAS service failed!\n");
            e.printStackTrace();
            System.exit(-2);
        }
        catch (java.lang.Exception e) {
            System.err.println("SAS Web service is not available, create cluster failed!\n");
            e.printStackTrace();
            System.exit(-4);
        }
        Date endTime = new Date();
        System.out.format("[" + commandName + " web method took %.3f seconds.]\n", (double)(endTime.getTime() - startTime.getTime()) / 1000.0);
        System.exit(0);
    }

    public static void printSvaServerInfo(SvaServerInfo info) {
        System.out.println("\tid = " + info.getId());
        System.out.println("\tname = " + info.getName());
        System.out.println("\tmaintenance mode = " + info.getMaintenanceMode());
        System.out.println("\tDomain name = " + info.getDomainName());
        System.out.println("\tStorage Cluster ID = " + info.getStorageClusterId());
        System.out.println("\tPrimary member = " + info.getPrimaryMember());
        String[] dnsServers = info.getDnsServers();
        if (dnsServers == null) {
            System.out.println("\tNo DNS server");
        } else {
            System.out.print("\tDNS servers:");
            for (String dnsServer : dnsServers) {
                System.out.print(" " + dnsServer);
            }
            System.out.println();
        }
        NetworkInterface internalInterface = info.getInternalInterface();
        if (internalInterface == null) {
            System.out.println("\tUnable to get internal network configuration");
        } else {
            System.out.println("\tInternal interface = " + SvaWebserviceInterfaceCli.interfaceString(internalInterface));
        }
        NetworkInterface managementInterface = info.getManagementInterface();
        if (managementInterface == null) {
            System.out.println("\tUnable to get management network configuration");
        } else {
            System.out.println("\tManagement interface = " + SvaWebserviceInterfaceCli.interfaceString(managementInterface));
        }
        System.out.println("\tGateway = " + info.getGateway());
        StoragePool[] storagePools = info.getStoragePools();
        if (storagePools == null) {
            System.out.println("\tNo storage pools");
        } else {
            int i = 0;
            for (StoragePool storagePool : storagePools) {
                System.out.println("\tStorage pool " + i++ + ":");
                System.out.println("\t\tID = " + storagePool.getId());
                System.out.println("\t\tTotal storage = " + storagePool.getTotalStorage() + "KB");
                System.out.println("\t\tFree storage = " + storagePool.getFreeStorage() + "KB");
                System.out.println("\t\tUsed storage = " + storagePool.getUsedStorage() + "KB");
            }
        }
        System.out.println("\tFree storage = " + info.getFreeStorage() + "KB");
        System.out.println("\tTotal storage = " + info.getTotalStorage() + "KB");
        System.out.println("\tUsed storage = " + info.getUsedStorage() + "KB");
    }

    public static void printMember(MemberSva member) {
        System.out.println("\tSVA ID = " + member.getId());
        System.out.println("\tName = " + member.getName());
        System.out.println("\tMaintenance mode = " + member.getMaintenanceMode());
        System.out.println("\tDomain name = " + member.getDomainName());
        System.out.println("\tMember ID = " + member.getMemberId());
        System.out.println("\tStorage Cluster ID = " + member.getStorageClusterId());
        System.out.println("\tPrimary member = " + member.getPrimaryMember());
        System.out.println("\tState = " + member.getState());
        NetworkInterface managementInterface = member.getManagementInterface();
        if (managementInterface == null) {
            System.out.println("\tUnable to get management interface configuraton");
        } else {
            System.out.println("\tManagement interface = " + SvaWebserviceInterfaceCli.interfaceString(managementInterface));
        }
        NetworkInterface internalInterface = member.getInternalInterface();
        if (internalInterface == null) {
            System.out.println("\tUnable to get internal interface configuration");
        } else {
            System.out.println("\tInternal interface = " + SvaWebserviceInterfaceCli.interfaceString(internalInterface));
        }
        String[] dnsServers = member.getDnsServers();
        if (dnsServers == null) {
            System.out.println("\tNo DNS servers");
        } else {
            System.out.print("\tDNS servers:");
            for (String dnsServer : dnsServers) {
                System.out.print(" " + dnsServer);
            }
            System.out.println();
        }
        String gateway = member.getGateway();
        if (gateway == null) {
            System.out.println("\tNo gateway");
        }
        System.out.println("\tGateway = " + gateway);
        System.out.println("\tTotal storage = " + member.getTotalStorage() + "KB");
        System.out.println("\tFree storage = " + member.getFreeStorage() + "KB");
        System.out.println("\tUsed storage = " + member.getUsedStorage() + "KB");
        StoragePool[] storagePools = member.getStoragePools();
        if (storagePools == null) {
            System.out.println("\tNo storage pools");
        } else {
            int i = 0;
            for (StoragePool storagePool : storagePools) {
                System.out.println("\tStorage pool " + i++ + ":");
                SvaWebserviceInterfaceCli.printStoragePool(storagePool);
            }
        }
        String[] exportedStorageEnties = member.getExportedStorageEntities();
        if (exportedStorageEnties == null) {
            System.out.println("\tNo exported storage entities");
        } else {
            System.out.println("\tExport storage entities:");
            for (String eseId : exportedStorageEnties) {
                System.out.println("\t\t" + eseId);
            }
            System.out.println();
        }
    }

    private static void printStoragePool(StoragePool storagePool) {
        System.out.println("\t\tID = " + storagePool.getId());
        System.out.println("\t\tTotal storage = " + storagePool.getTotalStorage());
        System.out.println("\t\tFree storage = " + storagePool.getFreeStorage());
        System.out.println("\t\tUsed storage = " + storagePool.getUsedStorage());
    }

    private static void printUsage() {
        System.out.println("Usage: WSCli {<sva-server-address> | <sas-server-address> | <vcs-server-address>} <command> [<arg>...]");
        System.out.println();
        System.out.println("All commands support the -pass <new-password> option, which can be\nspecified to provide a non-default password.\n\nAll boolean arguments should be specified as 'true' or 'false', ignoring\ncase.");
        CommandType commandType = null;
        for (CommandInfo commandInfo : CommandInfo.commandList) {
            if (commandInfo.command.equalsIgnoreCase("repairCluster") || commandInfo.command.equalsIgnoreCase("recreateCluster")) continue;
            if (!commandInfo.commandType.equals((Object)commandType)) {
                commandType = commandInfo.commandType;
                System.out.println();
                String header = commandType.prettyName + " commands:";
                System.out.println(header);
                System.out.println(SvaWebserviceInterfaceCli.dashes(header.length()));
            }
            SvaWebserviceInterfaceCli.printlnTabs(commandInfo.usage);
        }
    }

    private static String getSvaExceptionMessage(com.vmware.sva.messaging.ws.sva.Exception e) {
        com.vmware.sva.messaging.ws.model.Exception exp;
        String message = "Reason unknown.";
        ExceptionMsg msg = e.getFaultMessage();
        if (msg != null && (exp = msg.getExceptionMsg()) != null) {
            message = exp.getMessage();
        }
        return message;
    }

    private static String getPsvaExceptionMessage(Exception e) {
        com.vmware.sva.messaging.ws.model.Exception exp;
        String message = "Reason unknown.";
        ExceptionMsg msg = e.getFaultMessage();
        if (msg != null && (exp = msg.getExceptionMsg()) != null) {
            message = exp.getMessage();
        }
        return message;
    }

    private static String getSasExceptionMessage(com.vmware.sva.messaging.ws.sas.Exception e) {
        com.vmware.sva.messaging.ws.model.Exception exp;
        String message = "Reason unknown.";
        ExceptionMsg msg = e.getFaultMessage();
        if (msg != null && (exp = msg.getExceptionMsg()) != null) {
            message = exp.getMessage();
        }
        return message;
    }

    private static int printPingResult(PingResult pingResult, int tabs) {
        for (int i = 0; i < tabs; ++i) {
            System.out.print("   ");
        }
        if (pingResult != null) {
            System.out.println(pingResult.getMessage());
            PingResult[] subPings = pingResult.getLayerResponses();
            if (subPings != null) {
                for (PingResult subPing : subPings) {
                    SvaWebserviceInterfaceCli.printPingResult(subPing, tabs + 1);
                }
            }
            return 0;
        }
        return -7;
    }

    private static String interfaceString(NetworkInterface networkInterface) {
        return networkInterface.getIpAddress().getIPAddress() + "/" + networkInterface.getIpPrefix();
    }

    private static void printStorageEntity(AbstractStorageEntity storageEntity) {
        NFSv3StorageEntity nfsse = (NFSv3StorageEntity)storageEntity;
        System.out.println("NFSv3StorageEntity:");
        System.out.println("\tId = " + nfsse.getId());
        System.out.println("\tName = " + nfsse.getName());
        System.out.println("\tState = " + nfsse.getState());
        System.out.println("\tAccessInterface = " + SvaWebserviceInterfaceCli.interfaceString(nfsse.getAccessInterface()));
        System.out.println("\tExport Member SVA Id = " + nfsse.getExportMemberSvaId());
        System.out.println("\t# Exports = " + nfsse.getExports().length);
        int i = 0;
        for (AbstractExport exp : nfsse.getExports()) {
            NFSv3Export nfsexp = (NFSv3Export)exp;
            System.out.println("\tExport[" + i + "]:");
            System.out.println("\t\tName = " + nfsexp.getName());
            System.out.println("\t\tId = " + nfsexp.getId());
            System.out.println("\t\tStorageEntity Id = " + nfsexp.getStorageEntityId());
            System.out.println("\t\tExport Path = " + nfsexp.getExportPath());
            System.out.print("\t\tAcl[] = [");
            for (NfsAccessControl n : nfsexp.getAcl()) {
                System.out.print(n.getIpAddress().getIPAddress() + " ");
            }
            System.out.println("]");
            Volume v = nfsexp.getVolume();
            System.out.println("\t\tVolume:");
            System.out.println("\t\t\tName = " + v.getName());
            System.out.println("\t\t\tId = " + v.getId());
            System.out.println("\t\t\tSize = " + v.getSize());
            String primaryVolumeOwner = v.getPrimaryVolumeOwner();
            System.out.println("\t\t\tPrimary Owner = " + primaryVolumeOwner);
            String currentVolumeOwner = v.getCurrentVolumeOwner();
            System.out.println("\t\t\tCurrent Owner = " + currentVolumeOwner);
            System.out.println("\t\t\tExport Id = " + v.getExportId());
            String onlineOwnerState = "";
            VolumeState volumeState = v.getState();
            if (primaryVolumeOwner != null && !primaryVolumeOwner.equals(currentVolumeOwner) && volumeState == VolumeState.ONLINE) {
                onlineOwnerState = " (current owner not primary)";
            }
            System.out.println("\t\t\tState = " + volumeState + onlineOwnerState);
            System.out.println("\t\t\tType = " + v.getType());
            System.out.println("\t\t\t# Disks = " + v.getDiskCount());
            System.out.format("\t\t\tSync Percent = %.2f %%\n", Float.valueOf(v.getSyncPercent() * 100.0f));
            System.out.println("\t\t\tSync Time-to-Complete = " + v.getSyncTimeToComplete() + " sec.");
            System.out.println("\t\t\tSync Speed = " + v.getSyncSpeed() + " KB/s");
            int j = 0;
            for (Disk d : v.getDisks()) {
                System.out.println("\t\t\t\tDisk[" + j + "]");
                System.out.println("\t\t\t\t\tName = " + d.getName());
                System.out.println("\t\t\t\t\tId = " + d.getId());
                System.out.println("\t\t\t\t\tOwner Id = " + d.getOwnerSvaId());
                System.out.println("\t\t\t\t\tState = " + d.getState());
                System.out.println("\t\t\t\t\tSynced = " + d.getDiskSynced());
                ++j;
            }
            ++i;
        }
    }

    private static NetworkInterface getNetInterface(String ipAndPrefix) {
        NetworkInterface netInterface = new NetworkInterface();
        String[] split = ipAndPrefix.split("/");
        IPv4Address ipAddr = new IPv4Address();
        ipAddr.setIPAddress(split[0]);
        netInterface.setIpAddress(ipAddr);
        netInterface.setIpPrefix(Integer.parseInt(split[1]));
        netInterface.setState(NetworkState.UP);
        netInterface.setNetConfigProtocol(NetConfigProtocol.NONE);
        return netInterface;
    }

    private static synchronized void setPassword(String password) {
        SvaWebserviceInterfaceCli.password = password;
    }

    private static void addSvaCommand(String command, String method, String usage, String doc) {
        new CommandInfo(command, CommandType.SVA, method, usage, doc);
    }

    private static void addSasCommand(String command, String method, String usage, String doc) {
        new CommandInfo(command, CommandType.SAS, method, usage, doc);
    }

    private static void addClientCommand(String command, String method, String usage, String doc) {
        new CommandInfo(command, CommandType.CLIENT, method, usage, doc);
    }

    private static void printlnTabs(String s) {
        int len = s.length();
        int start = 0;
        while (start < len) {
            int end = s.indexOf(10, start);
            if (end != start) {
                System.out.print('\t');
            }
            if (end >= start) {
                System.out.print(s.substring(start, end + 1));
                start = end + 1;
                continue;
            }
            System.out.print(s.substring(start));
            break;
        }
        System.out.println();
    }

    private static String dashes(int len) {
        char[] chars = new char[len];
        Arrays.fill(chars, '=');
        return new String(chars);
    }

    private static String formatCommand(String command, String[] args) {
        StringBuilder sb = new StringBuilder(command);
        for (String arg : args) {
            sb.append(' ').append(arg);
        }
        return sb.toString();
    }

    private static boolean parseBoolean(String string) throws UsageException {
        if ("true".equalsIgnoreCase(string)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        throw new UsageException("Unknown value for boolean -- should be 'true' or 'false': " + string);
    }

    private static double parseMajorNumber(String version) {
        String versionString = version.substring(0, 3);
        return Double.parseDouble(versionString);
    }

    private static String extractOriginalExceptionMsg(java.lang.Exception e) {
        String msg;
        if (e instanceof com.vmware.sva.messaging.ws.sas.Exception) {
            com.vmware.sva.messaging.ws.sas.Exception sasEx = (com.vmware.sva.messaging.ws.sas.Exception)e;
            msg = sasEx.getFaultMessage().getExceptionMsg().getMessage();
        } else {
            msg = e.getMessage();
        }
        return msg;
    }

    private static String getWebServicesUrl(WebServiceInterface wsi, String ip, String servicePath) {
        return String.format("https://%s:%s/services/", ip, wsi instanceof PseudosvaWebServiceInterface ? "4336" : "8443") + servicePath;
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        SvaWebserviceInterfaceCli.addSvaCommand("pingsva", "pingsva", "pingsva", "Sends a test message to a node and print the results.");
        SvaWebserviceInterfaceCli.addSvaCommand("create", "createCluster", "create <cluster-name> <mgmt-address/prefix> [-vcs <vcs-ip-address>]\n    [<member-address> <member-internal-address/prefix>\n     <storage-entity-access-address/prefix>]...\n    [-acl <nfs-client-ip-address>...]\ncreate <cluster-name> <mgmt-address/prefix> [-vcs <vcs-ip-address>]\n    [-inet <internal-network-address/prefix>] [<member-address>...]\n    [-acl <nfs-client-ip-address>...]", "Parameters:\n  cluster-name - the name of the cluster\n  mgmt-address/prefix - the IP address, with prefix, for the management\n    interface\n  vcs-ip-address - the IP address of the VSA Cluster Service\n  member-address - the IP address a cluster member on the front end\n    network\n  member-internal-address/prefix - the IP address, with prefix, of a\n    cluster member on the back end network\n  storage-entity-access-address/prefix - the IP address, with prefix, of\n    a storage entity's management interface\n  nfs-client-ip-address - the IP address of an NFS client\n  internal-network-address/prefix - the IP address, with prefix, of a\n    cluster member on the back end network\n\nInitiates an asynchronous task to create a storage cluster with the\nspecified configuration, printing the task ID for monitoring the progress\nof the task.\n\nThe task sends CreateStorageClusterTaskStartedEvent,\nCreateStorageClusterTaskProgressEvent,\nCreateStorageClusterTaskCompletedEvent, and\nCreateStorageClusterTaskFailedEvent management events to provide\ninformation on its progress, a StorageClusterCreatedEvent when the\ncluster has been created, a StorageClusterOnlineEvent when the\ncluster goes online, a MemberJoinedEvent when a member joins the\ncluster, and a MemberJoinFailedEvent when there is a failure when\nasking a node to join the cluster.\n\nThe CreateStorageClusterTaskFailedEvent includes an\nInvalidStorageClusterConfigException if the storage configuration is\ninvalid, an InvalidStorageEntityConfigException if the storage entity\nconfiguration is invalid, a StorageEntityCreateFailedException if an\nattempt to create a storage entity failed, an SvaMemberOfflineException\nif a member goes offline, and a JoinStorageClusterException if a node\nfails to join the cluster.\n\nThe command will fail if the node is already a member of a cluster, or if\nit is in maintenance mode.");
        SvaWebserviceInterfaceCli.addSasCommand("repairCluster", "repairCluster", "repairCluster", "Repairs cluster by recreating FT domains");
        SvaWebserviceInterfaceCli.addSvaCommand("recreateCluster", "recreateCluster", "recreateCluster", "Recreates cluster from given meta-data by recreating FT domains");
        SvaWebserviceInterfaceCli.addSvaCommand("getSvaServerInfo", "getSvaServerInfo", "getSvaServerInfo", "Prints information about the node.");
        SvaWebserviceInterfaceCli.addSvaCommand("getSvaVersion", "getSvaVersion", "getSvaVersion", "Prints the version string for the VSA service running on the node.");
        SvaWebserviceInterfaceCli.addSvaCommand("shutdownSvaServer", "shutdownSvaServer", "shutdownSvaServer [<boolean:maintenance-mode=false>]", "Parameters:\n  maintenance - whether the node should enter maintenance mode on\n    restart, defaults to false\n\nPrepares the node for a shutdown.\n\nThis command does not actually perform a shutdown of this node's VSA\nservice or of its virtual machine.  Instead, any test coverage data\nbeing collected is saved, all open files are synced, whether the node\nshould enter maintenance mode on restart is persisted, and the\nZooKeeper configuration is updated if the node will be entering\nmaintenance mode, but the actual shutdown is not performed.  The\ncaller should arrange to power off the node on receiving the\nSvaShutdownEvent.  Calls to this method are not counted when\ndetermining whether this node should be placed in maintenance mode\nbecause it appears to be in a continuous cycle of reboots.\n\nThis operation sends an SvaEnterMaintenanceModeEvent management event\nwhen the node is marked for entering maintenance mode, and a\nSvaShutdownEvent when the VSA service is ready to shut down.");
        SvaWebserviceInterfaceCli.addSvaCommand("exitMaintenanceMode", "exitMaintenanceMode", "exitMaintenanceMode", "Causes the node to exit maintenance mode.\n\nThis operation sends an SvaExitMaintenanceModeEvent management\nevent when the node exits maintenance mode.\n\nThe command fails if the node is not in maintenance mode.");
        SvaWebserviceInterfaceCli.addSvaCommand("reconfigureNetwork", "svaReconfigureNetwork", "reconfigureNetwork <network-config.properties>", "Parameters:\n  network-config.properties - the name of a properties file that contains\n    the network configuration\n\nInitiates an asynchronous task to reconfigure the management network of\nthe node, which should be a cluster member that is currently in\nmaintenance mode, returning a task reference for monitoring the progress\nof the task.\n\nThe task sends ReconfigureNetworkTaskStartedEvent,\nReconfigureNetworkTaskProgressEvent,\nReconfigureNetworkTaskCompletedEvent, and\nReconfigureNetworkTaskFailedEvent management events to provide\ninformation on its progress.\n\nThe ReconfigureNetworkTaskFailedEvent includes a\nReconfigureNetworkException if the operation failed.\n\nThe command will fail if the node is not in maintenance mode or if it is\nnot a member of a cluster.\n\nHere are the contents of a sample configuration file:\n\nmgmt-interface = <ip-address/ip-prefx>\n# The property is required for a 2-node cluster only.\n# Comment it out for a 3-node cluster.\nvsa-mgr-service-address = 10.115.66.xx\ngateway = 10.115.67.253\ndns = 10.25.0.110\nvsa1.id = <uuid>\nvsa1.mgmt-address = 10.115.66.248\nvsa1.backend-interface = 192.168.0.248/24\nvsa2.id = <uuid>\nvsa2.mgmt-address = 10.115.66.249\nvsa2.backend-interface = 192.168.0.249/24\nvsa3.id = <uuid>\nvsa3.mgmt-address = 10.115.66.250\nvsa3.backend-interface = 192.168.0.250/24\nstorage-entity1.id = <uuid>\nstorage-entity1.access-interface = 10.115.67.8/23\nstorage-entity2.id = <uuid>\nstorage-entity2.access-interface = 10.115.67.9/23\nstorage-entity3.id = <uuid>\nstorage-entity3.access-interface = 10.115.67.10/23\nstorage-entity.access-control-list = 10.115.66.248 10.115.66.249 10.115.66.250");
        SvaWebserviceInterfaceCli.addSvaCommand("svaGetDiagnosticInfo", "svaGetDiagnosticInfo", "svaGetDiagnosticInfo [<boolean:includeDump=false>]", "Parameters:\n  includeDump - whether to include crash dumps\n\nObtains diagnostic information for this node, printing the name of the\nfile in the current directory where the results have been stored.\n\nThe command will fail if the node is restarted while the operation is\nunderway or if collecting the diagnostic information takes too long.");
        SvaWebserviceInterfaceCli.addSvaCommand("fault", "faultInsertion", "fault <command> [<args>...]", "fault clear [-name <name>]\nfault crash\nfault hang\nfault list [-name <name>]\nfault reset [-name <name>]\nfault saveAll\nfault set -name <name> [-repeat <repeat-count>] [-skip <skip-count>]\n  [-delay <delay-in-seconds>] [-reboot | -noreboot]\nfault set -name blc.edge [-repeat <repeat-count>] [-skip <skip-count>]\n  [-delay <delay-in-seconds>] [-reboot | -noreboot]\n  [-blcClass <classname>] [-blcState <state-number>]\n  [-eventClass <classname>] [-failNextPlatformCommand <boolean>]\nfault ssh <boolean>\n\nParameters:\n  name             - name of a fault\n  repeat-count     - number of times to repeat a fault\n  skip-count       - number of times to skip a fault before enabling it\n  delay-in-seconds - how long to pause before triggering a fault\n  classname        - fully qualified name of a class\n  state-number     - numeric value of a BLC state\n\nCommands:\n  clear   - set fault attributes to default settings, which include\n            repeat=0 (fault disabled), skip=0, delay=0\n  crash   - cause the system to crash and take a crash dump.\n  hang    - cause the system to hang.\n  list    - list the attributes of one or all faults.\n  reset   - set fault attributes to initial settings, which are either\n            settings previously saved with the 'saveAll' command or\n            default settings (see the 'clear' command) if none have\n            been saved.\n  saveAll - saveAll all attributes to /etc/sva/fault.properties.\n  set     - set fault attributes (see the list of parameters above).\n  ssh     - pass 'true' to enable SSH or 'false' to disable SSH.\n\nPerforms one of several debugging operations, including inserting\nfaults, causing the operating system to crash or hang, or enabling\nor disabling SSH access.  This command is disabled by default.");
        SvaWebserviceInterfaceCli.addSvaCommand("reset", "resetSva", "reset [boolean:force=false]", "Parameters:\n  force - whether to force a reboot without shutting down services\n\nA debugging command that reboots this node.  This command is disabled by\ndefault.  If force is false, performs an ordinary operating system\nshutdown, including shutting down services, before performing a reboot.\nIf force is true, does not shutdown any services, and performs an\nimmediate reboot.");
        SvaWebserviceInterfaceCli.addSvaCommand("listConstants", "listConstants", "listConstants", "A debugging command that prints information about constant names and\nvalues that control the behavior of the node.  This command is\ndisabled by default.");
        SvaWebserviceInterfaceCli.addSvaCommand("listDebug", "listDebug", "listDebug", "A debugging command that prints information about debugging constant\nnames and values that control the behavior of the node.  This command\nis disabled by default.");
        SvaWebserviceInterfaceCli.addSasCommand("pingsas", "pingsas", "pingsas", "Sends a test message to the storage cluster and print the results.");
        SvaWebserviceInterfaceCli.addSasCommand("getTaskList", "getTaskList", "getTaskList", "Print information about the list of current tasks.  The list includes\ntasks that are completed but will not be removed from the list until they\nexpire.");
        SvaWebserviceInterfaceCli.addSasCommand("sasGetTaskStatus", "sasGetTaskStatus", "sasGetTaskStatus <uuid:task-id>", "Parameters:\n  task-id - the ID of task\n\nPrints the status of the task with the specified ID.  Prints an error\nmessage if the specified task is not found.");
        SvaWebserviceInterfaceCli.addSasCommand("sasGatherDiagnosticInfo", "sasGatherDiagnosticInfo", "sasGatherDiagnosticInfo", "Initiates an asynchronous task to gather diagnostic information from\nall storage cluster members, deleting any previous diagnostic\ninformation, and printing the task ID for monitoring the progress of the\ntask.  Call sasGetDiagnosticInfo to obtain the resulting diagnostic\ninformation after the task created by this call is complete.\n\nThe task sends GatherDiagnosticInfoTaskStartedEvent,\nGatherDiagnosticInfoTaskProgressEvent,\nGatherDiagnosticInfoTaskCompletedEvent, and\nGatherDiagnosticInfoTaskFailedEvent management events to provide\ninformation on its progress.\n\nThe GatherDiagnosticInfoTaskFailedEvent includes a\nGatherDiagnosticInfoException if the cluster is restarted or fails\nover to a new master while the task is underway, and a\nStorageClusterNotReadyException if the cluster has not already been\ncreated successfully.  If a request to a particular member to gather\ndiagnostic information takes too long, then its information will be\nomitted from the results.");
        SvaWebserviceInterfaceCli.addSasCommand("sasGetDiagnosticInfo", "sasGetDiagnosticInfo", "sasGetDiagnosticInfo", "Obtains diagnostic information collected by the previously completed\ntask initiated by a call to sasGatherDiagnosticInfo, printing the name of\nthe file in the current directory where the results have been stored.\n\nThe command will fail if no previously collected diagnostic information\nis found.");
        SvaWebserviceInterfaceCli.addSasCommand("sasGetAllParameters", "sasGetAllParameters", "sasGetAllParameters", "Prints the names and values in the SAS parameters table.");
        SvaWebserviceInterfaceCli.addSasCommand("sasSetParameter", "sasSetParameter", "sasSetParameter <param-name> [<param-value> [param-value-type]]", "Parameters:\n  param-name - the parameter name\n  param-value - the parameter value\n  param-value-type - the type of the parameter value\n\nSets the value of a parameter in the SAS parameters table.  If no value\nis specified, then the parameter is deleted.\n\nThe command will fail if param-name is empty or too long, or if the\nparameters table is full.\n\nIf no param-value-type argument is specified, the value will be\nstored as a java.lang.String.\n\nThe supported values for param-value-type are:\n  java.lang.String\n  java.lang.Boolean\n  java.lang.Byte\n  java.lang.Short\n  java.lang.Integer\n  java.lang.Long\n  java.lang.Float\n  java.lang.Double\n");
        SvaWebserviceInterfaceCli.addSasCommand("sasGetParameter", "sasGetParameter", "sasGetParameter <param-name>", "Parameters:\n  param-name - the name of the parameter\n\nPrints the value of a parameter in the SAS parameters table, printing\nnull if the parameter is not found.\n");
        SvaWebserviceInterfaceCli.addSasCommand("sasChangePassword", "sasChangePassword", "sasChangePassword <user> <old-password> <new-password>", "Parameters:\n  user - the user name\n  old-password - the old password\n  new-password - the new password\n\nInitiates an asynchronous task to change a user password on all storage\ncluster members, printing the task ID for monitoring the progress\nof the task.\n\nThe task sends ChangePasswordTaskStartedEvent,\nChangePasswordTaskProgressEvent, ChangePasswordTaskCompletedEvent,\nand ChangePasswordTaskFailedEvent management events to provide\ninformation on its progress.\n\nThe ChangePasswordTaskFailedEvent includes an\nAuthenticationFailedException if old-password does not match the\ncurrent password for the specified user.");
        SvaWebserviceInterfaceCli.addSasCommand("getStorageCluster", "getStorageCluster", "getStorageCluster", "Prints information describing the storage cluster.");
        SvaWebserviceInterfaceCli.addSasCommand("getExportPaths", "getExportPaths", "getExportPaths", "Print the paths of the exports provided by the cluster.\n\nPrints each export path in the following format, one per line:\n\n  <access-address>:<export-path>\n\nFor example:\n\n  192.168.0.100:/exports/246c4b39-ff74-42d8-8acb-bf157caf8450\n\nOn a Linux system, that format can be passed to the mount command.");
        SvaWebserviceInterfaceCli.addSasCommand("sasGetSvaServer", "sasGetSvaServer", "sasGetSvaServer <uuid:sva-id>", "Parameters:\n  sva-id - the SVA ID of the member\n\nPrints information describing the storage cluster member with the\nspecified SVA ID.");
        SvaWebserviceInterfaceCli.addSasCommand("renameStorageCluster", "renameStorageCluster", "renameStorageCluster <new-name>", "Parameters:\n  new-name - the new name for the storage cluster\n\nChanges the name of the storage cluster to the specified name.  The name\nmust satisfy the following requirements:\n\n* Contain only letters, digits, or minus signs ('-')\n* Contain a least 1 character and no more than 63 characters\n* Not contain only digits\n* Not start or end with a minus sign ('-')\n\nThis command sends a {@link StorageClusterRenameEvent} when the storage\ncluster is renamed.");
        SvaWebserviceInterfaceCli.addSasCommand("setStorageClusterNetworkConfig", "setStorageClusterNetworkConfig", "setStorageClusterNetworkConfig <mgmt-address/prefix>\n    [<long:timeout-in-ms=-1>]", "Parameters:\n  mgmt-address/prefix - the new management IP address and prefix\n  timeout-in-ms - the confirmation timeout or -1\n\nInitiates an asynchronous task to change the management interface for\nthe storage cluster, specifying the time in milliseconds to wait for\na confirmation call, and printing the task ID for monitoring the progress\nof the task.  A timeout of -1 specifies the default wait time of 30\nseconds.  If this method returns successfully, then the new network\ninterface has been added, but the old one is still present.\n\nThe caller must call confirmStorageClusterNetworkConfig, making the\ncall over the new interface, and providing the task ID printed by this\ncall, before the timeout elapses, to confirm that the new interface is\nworking properly.  If that call is made in time, the old interface will\nbe removed.  Otherwise, the new interface will be removed.\n\nThe task sends SetStorageClusterNetworkConfigTaskStartedEvent,\nSetStorageClusterNetworkConfigTaskProgressEvent,\nSetStorageClusterNetworkConfigTaskCompletedEvent, and\nSetStorageClusterNetworkConfigTaskFailedEvent management events to\nprovide information on its progress, and sends a\nStorageClusterChangeNetworkConfigEvent when the storage cluster's\nnetwork configuration is changed.\n\nThe SetStorageClusterNetworkConfigTaskFailedEvent includes a\nConfirmStorageClusterNetworkConfigTimeoutException if the\nconfirmStorageClusterNetworkConfig method is not called before the\ntimeout expires, and an\nUnableToUpdateStorageClusterConfigurationException if there is a\nproblem updating the storage cluster configuration.");
        SvaWebserviceInterfaceCli.addSasCommand("confirmStorageClusterNetworkConfig", "confirmStorageClusterNetworkConfig", "confirmStorageClusterNetworkConfig <uuid:task-id>", "Parameters:\n  task-id - the task ID printed by the setStorageClusterNetworkConfig\n    command\n\nConfirms a change to the management interface for the storage\ncluster, specifying the task ID printed by the call to\nsetStorageClusterNetworkConfig.  This command should be called using\nthe address of the new network interface.  If the command is called with\nthe proper task ID before the timeout for the confirmation elapses, the\nold network interface will be removed and the call will return\nsuccessfully.  If the call is received too late, or other problems\noccur, the new interface will be removed, leaving the original\ninterface in place, and an exception will be thrown.");
        SvaWebserviceInterfaceCli.addSasCommand("enterStorageClusterMaintenanceMode", "enterStorageClusterMaintenanceMode", "enterStorageClusterMaintenanceMode [<boolean:stop-SvaServer=false]", "Parameters:\n  stop-SvaServer -- whether to place members in maintenance mode and\n    shut down the VSA service on each member\n\nInitiates an asynchronous task to place the cluster in maintenance\nmode, optionally placing the storage cluster members in maintenance\nmode and stopping the VSA service on each member, and printing the task\nID to monitor the progress of the task.  If stopSvaService is false, then\nthe cluster is placed in maintenance mode, with no other changes.  If\nstopSvaService is true, then the cluster is placed in maintenance mode,\neach member is marked to be placed in maintenance mode when it restarts,\nany test coverage data being collected is saved, all open files are\nsynced, the ZooKeeper configuration is updated, and the VSA service on\neach member is shut down.\n\nThe task sends EnterStorageClusterMaintenanceModeTaskStartedEvent,\nEnterStorageClusterMaintenanceModeTaskProgressEvent,\nEnterStorageClusterMaintenanceModeTaskCompletedEvent, and\nEnterStorageClusterMaintenanceModeTaskFailedEvent management events to\nprovide information on its progress.\n\nUse the exitStorageClusterMaintenanceMode command to cause the cluster\nto exit maintenance mode.  If stopSvaService was true, all members\nneed to be rebooted before attempting other operations on the members\n(the VSA service does not currently support being restarted without a\nreboot), and then use the exitMaintenanceMode command to cause the\nmembers to exit maintenance mode and rejoin the cluster before\nrequesting the cluster to exit maintenance mode.\n\nThe command will fail if the storage cluster is already in\nmaintenance mode.");
        SvaWebserviceInterfaceCli.addSasCommand("exitStorageClusterMaintenanceMode", "exitStorageClusterMaintenanceMode", "exitStorageClusterMaintenanceMode", "Initiates an asynchronous task to cause the cluster to exit\nmaintenance mode, printing the task ID for monitoring the progress of the\ntask.\n\nThe task sends ExitStorageClusterMaintenanceModeTaskStartedEvent,\nExitStorageClusterMaintenanceModeTaskProgressEvent,\nExitStorageClusterMaintenanceModeTaskCompletedEvent, and\nExitStorageClusterMaintenanceModeTaskFailedEvent management events to\nprovide information on its progress.\n\nThe ExitStorageClusterMaintenanceModeTaskFailedEvent includes a\nStorageClusterFailedToExitMaintenanceModeException if none of the\nstorage entities exited maintenance mode.\n\nThe command will fail if the storage cluster is not in maintenance mode.");
        SvaWebserviceInterfaceCli.addSasCommand("repairVCS", "repairPseudoSva", "repairVCS", "Updates the configuration of the VSA Cluster Service to match the\ncurrent configuration of the cluster.\n\nThe command will fail if the cluster does not have a VSA Cluster Service,\nor if the VSA Cluster Service is not found.");
        SvaWebserviceInterfaceCli.addSasCommand("replaceMember", "replaceMember", "replaceMember <uuid:sva-id-to-replace> <new-sva-ip-address>", "Parameters:\n  sva-id-to-replace - the SVA ID of the old member\n  new-sva-ip-address - the IP address of the new member\n\nInitiates an asynchronous task to replace an old storage cluster member\nwith a new member, printing the task ID for monitoring the progress of\nthe task.\n\nThe task sends ReplaceMemberTaskStartedEvent,\nReplaceMemberTaskProgressEvent, ReplaceMemberTaskCompletedEvent,\nand ReplaceMemberTaskFailedEvent management events to provide information\non its progress, and sends a MemberJoinedEvent management event when the\nnew member joins the cluster.\n\nThe ReplaceMemberTaskFailedEvent includes a ReplaceMemberException if the\nattempt to replace the member failed.\n\nThe command fails if sva-id-to-replace is not the SVA ID of a member of\nthe cluster.");
        SvaWebserviceInterfaceCli.addSasCommand("shutdownStorageClusterMember", "shutdownStorageClusterMember", "shutdownStorageClusterMember <uuid:sva-id>\n    [<boolean:maintenance-mode=false>]", "Parameters:\n  sva-id -- the SVA ID of the member\n  maintenance-mode -- whether the member should enter maintenance mode\n    on restart\n\nInitiates an asynchronous task to prepare to shutdown a storage cluster\nmember, printing the task ID for monitoring the progress of the task.\n\nThis command does not actually perform a shutdown of the member's VSA\nservice or of its virtual machine.  Instead, any test coverage data\nbeing collected is saved, all open files are synced, whether the node\nshould enter maintenance mode on restart is persisted, and the\nZooKeeper configuration is updated if the node will be entering\nmaintenance mode, but the actual shutdown is not performed.  The\ncaller should arrange to power off the node on receiving the\nSvaShutdownEvent.  Calls to this method are not counted when\ndetermining whether this node should be placed in maintenance mode\nbecause it appears to be in a continuous cycle of reboots.\n\nThis method will throw an exception if the cluster is already degraded\nbecause another member is offline or in maintenance mode.\n\nThe task sends {@link ShutdownStorageClusterMemberTaskStartedEvent},\nShutdownStorageClusterMemberTaskProgressEvent,\nShutdownStorageClusterMemberTaskCompletedEvent, and\nShutdownStorageClusterMemberTaskFailedEvent management events to\nprovide information on its progress, sends a\nSvaEnterMaintenanceModeEvent management event when the member is\nmarked for entering maintenance mode, and an SvaShutdownEvent when the\nVSA service is ready to shut down.\n\nThe ShutdownStorageClusterMemberTaskFailedEvent includes a\nSvaNotMemberOfClusterException if the specified node is not part of\nthe cluster, and an SvaMemberOfflineException if the specified member\nis offline.\n\nThe command will fail if the specified node is not part of the cluster,\nif the specified member is offline, or if any other members are offline\nor in maintenance mode.");
        SvaWebserviceInterfaceCli.addSasCommand("getStorageEntity", "getStorageEntity", "getStorageEntity <uuid:storage-entity-id>", "Parameters:\n  storage-entity-id - the ID of the storage entity\n\nPrints information about the specified storage entity.");
        SvaWebserviceInterfaceCli.addSasCommand("setStorageEntityNetworkConfig", "setStorageEntityNetworkConfig", "setStorageEntityNetworkConfig <uuid:storage-entity-id>\n    <storage-entity-access-address/prefix>", "  storage-entity-id -- the ID of the storage entity\n  storage-entity-access-address/prefix -- the new network configuration\n\nInitiates an asynchronous task to set the network configuration of the\nspecified storage entity, printing the task ID for monitoring the\nprogress of the task.\n\nThe task sends SetStorageEntityNetworkConfigTaskStartedEvent,\nSetStorageEntityNetworkConfigTaskProgressEvent,\nSetStorageEntityNetworkConfigTaskCompletedEvent, and\nSetStorageEntityNetworkConfigTaskFailedEvent management events to\nprovide information on its progress, and sends a\nStorageEntityNetworkChangedEvent when the network configuration is\nchanged.\n\nThe SetStorageEntityNetworkConfigTaskFailedEvent includes a\nUnknownStorageEntityException if the specified storage entity is not\nfound.\n\nThe command will fail if the specified storage entity is not found.");
        SvaWebserviceInterfaceCli.addSasCommand("setStorageEntityExportACL", "setStorageEntityExportACL", "setStorageEntityExportACL <uuid:storage-entity-id>\n    -acl <nfs-client-ip-address> ...", "Parameters:\n  storage-entity-id - the ID of the storage entity\n  nfs-client-ip-address - the IP address of a client to grant access\n\nSets the access control list for the specified storage entity.");
        SvaWebserviceInterfaceCli.addSasCommand("growStorage", "growStorage", "growStorage", "Parameters:\n  NONE\n\nRequests that the storage cluster scale-up its storage capacity,\nby equally expanding storage entities to use up any new storage found\nin resized VMDKs.");
        SvaWebserviceInterfaceCli.addClientCommand("startListener", "startListener", "startListener", "Start listening for management events and print out a message for each\nevent received.");
        SvaWebserviceInterfaceCli.addClientCommand("help", "help", "help [command]", "Parameters:\n  command -- the name of a command\n\nPrint a help message.  With no arguments, prints basic usage information\nfor all commands.  If a command name is specified, prints detailed\ninformation for that command.");
        SvaWebserviceInterfaceCli.addPsvaCommand("pingvcs", "pingsva", "pingvcs", "Sends a test message to VSA Cluster Service and print the results.");
        SvaWebserviceInterfaceCli.addPsvaCommand("getVCSVersion", "getSvaVersion", "getVCSVersion", "Prints the version string for the VSA Cluster Service running on the node.");
        SvaWebserviceInterfaceCli.addPsvaCommand("getVCSInfo", "getVCSInfo", "getVCSInfo [<service-IP>]", "Parameters:\n    service-IP -- the IP address of VSA Cluster Service\nPrints information about the VSA Cluster Service.");
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsGetDiagnosticInfo", "svaGetDiagnosticInfo", "vcsGetDiagnosticInfo", "Obtains diagnostic information for VSA Cluster Service, printing the name of the\nfile in the current directory where the results have been stored.\n\nThe command will fail if the node is restarted while the operation is\nunderway or if collecting the diagnostic information takes too long.");
        String usage = "vcsUploadFile <local file> <remote file> <permissions>";
        StringBuilder doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <local file>  - name of a local file to upload.\n");
        doc.append("    <remote file> - name of a remote file to create. The file path must contain \ufffd\ufffd\ufffdupload\ufffd\ufffd\ufffd\n                    substring.\n");
        doc.append("    <permissions> - permissions to set.\n");
        doc.append("\n");
        doc.append("Uploads a file to a remote VSA Cluster Service machine and sets the file permissions.\nIf a file already exists then it will be deleted. In order to upload a file, it is\nnecessary to have available space twice as big as the size of the file being uploaded.\nOnly files that contain \ufffd\ufffd\ufffdupload\ufffd\ufffd\ufffd substring in their remote path can be uploaded.\nvcsUploadFile is a convenience method. The same functionality can be achieved by\ncalling a sequence of lower level WSCLI commands vcsDeleteFile, vcsCreateFile and\nvcsAppendToFile\n");
        doc.append("\n");
        doc.append(PERMISSIONS_DOC);
        doc.append(REMOTE_PATH_DOC);
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsUploadFile", "vcsUploadFile", usage.toString(), doc.toString());
        usage = "vcsGetAvailableSpace";
        doc = new StringBuilder();
        doc.append("Returns available disk space on the remote machine where VSA\nCluster Service is installed. The returned value is in kilobytes.\n");
        doc.append("\n");
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsGetAvailableSpace", "vcsGetAvailableSpace", usage, doc.toString());
        usage = "vcsGetProductDirectory";
        doc = new StringBuilder();
        doc.append("Returns the name of a directory where VSA Cluster Service is installed.\n");
        doc.append("\n");
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsGetProductDirectory", "vcsGetProductDirectory", usage, doc.toString());
        usage = "vcsCreateDirectory <directory name> <permissions>";
        doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <directory name> - name of a directory to create.\n");
        doc.append("    <permissions>    - permissions to set.\n");
        doc.append("\n");
        doc.append("Creates a remote directory with a given name. If the directory already exists,\nan exception will be thrown.\n");
        doc.append("\n");
        doc.append(PERMISSIONS_DOC);
        doc.append(REMOTE_PATH_DOC);
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsCreateDirectory", "vcsCreateDirectory", usage, doc.toString());
        usage = "vcsCreateFile <file name> <permissions>";
        doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <file name>   - name of a remote file to create.\n");
        doc.append("    <permissions> - permissions to set.\n");
        doc.append("\n");
        doc.append("Creates a remote file with a given name. If the file already exists, an exception\nwill be thrown.\n");
        doc.append("\n");
        doc.append(PERMISSIONS_DOC);
        doc.append(REMOTE_PATH_DOC);
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsCreateFile", "vcsCreateFile", usage, doc.toString());
        usage = "vcsAppendToFile <local file> <remote file>";
        doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <local file>  - name of a local file to copy.\n");
        doc.append("    <remote file> - name of a remote file to append to.\n");
        doc.append("\n");
        doc.append("Appends the content of a local file to the content of a remote file. If the remote\nfile does not exist, it will be created with default permissions.\n");
        doc.append("\n");
        doc.append(REMOTE_PATH_DOC);
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsAppendToFile", "vcsAppendToFile", usage, doc.toString());
        usage = "vcsDeleteFile <remote file>";
        doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <remote file> - file name or a directory to delete.\n");
        doc.append("\n");
        doc.append("Deletes a remote file or directory. If a file is a directory then all its content\nwill be recursively deleted. If the file or directory does not exist, the command\nwill finish silently with no error messages. Only files or directories with names\ncontaining the substring 'upload' can be deleted.\n");
        doc.append("\n");
        doc.append(REMOTE_PATH_DOC);
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsDeleteFile", "vcsDeleteFile", usage, doc.toString());
        usage = "vcsChangePermissions <remote file> <permissions> [recursive]";
        doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <remote file> - name of the file or directory.\n");
        doc.append("    <permissions> - permissions to set.\n");
        doc.append("    [recursive]   - in case of a directory, specifies whether the permission change has\n                    to be applied recursively. The legal values are (true|false).\n                    By default, the value is false.\n");
        doc.append("\n");
        doc.append("Changes permissions of a remote file or directory.\n");
        doc.append("\n");
        doc.append(PERMISSIONS_DOC);
        doc.append(REMOTE_PATH_DOC);
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsChangePermissions", "vcsChangePermissions", usage, doc.toString());
        usage = "vcsExecute <remote file> [work directory] [async] [parameters] [stdin]";
        doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <remote file>    - a remote file to execute. If VSA Cluster Service is run on a\n                       Windows platform, the remote file path is relative to bin folder\n                       inside the service installation path. On Linux, the path is\n                       relative to the work directory (see the next parameter).\n");
        doc.append("    [work directory] - a work directory to set. If the value is not set, the work directory\n                       will be the same as the work directory of the VSA Cluster Service,\n                       i.e. the product bin directory. Setting the work directory is\n                       equivalent to changing the current directory and issuing\n                       the <remote file> command from there.\n");
        doc.append("    [async]          - specifies whether the process has to be executed in asynchronous\n                       mode, i.e. non-blocking mode similar to cmd&. The valid values are\n                       (true|false). If the process is executed in asynchronous mode then\n                       the return code is always equal to '0' and the stdin/stderr output\n                       is not available.\n");
        doc.append("    [parameters]     - parameters to pass to the process. In case if multiple parameters\n                       have to be passed, the parameters must be separated by a space and\n                       be enclosed in double quotes.\n");
        doc.append("    [stdinData]      - a string to pass to the standard input of the process. E.g., it\n                       can be used to securely pass a password instead of using standard\n                       parameters which can be seen, e.g. by calling ps -af on a Linux\n                       platform.\n");
        doc.append("\n");
        doc.append("Executes a file on a remote machine. VSA Cluster Service process has to have the rights\nto execute the given file. The command uses a regular socket timeout interval, i.e. it\nwill time out if the server does not respond within 1 minute interval.\n");
        doc.append("\n");
        doc.append("Returns:\n");
        doc.append("    Error code - error code of the process execution. The error code is always \ufffd\ufffd\ufffd0\ufffd\ufffd\ufffd if\n                 the process has been executed in asynchronous mode.\n    Standard/Error output - the combined standard output and standard error of the remote process.\n                 In case of asynchronous execution, the output is always null. There is the maximum\n                 size of the process output which will be sent back to the client. The size is\n                 equal to 10 MB. All output that exceeds that size will be ignored.");
        doc.append("\n");
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsExecute", "vcsExecute", usage, doc.toString());
        usage = "vcsRestart";
        doc = new StringBuilder();
        doc.append("Restarts VSA Cluster Service. This method always throws an exception.\nWARNING: Please be careful while using this method. If VCS is part of a cluster,\nthen restarting VCS will leave the cluster in a degraded mode until VCS rejoins,\nor it can cause reboot of a cluster if a majority of half of the VSA nodes are\nalready offline.");
        doc.append("\n");
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsRestart", "vcsRestart", usage, doc.toString());
        usage = "vcsEnterMaintenanceMode <shutdown RMI>";
        doc = new StringBuilder();
        doc.append("Parameters:\n");
        doc.append("    <shutdown RMI> - a boolean value that specifies whether RMI should be shut down.\n                     The value is ignored if the VCS is already in the maintenance mode.\n");
        doc.append("\n");
        doc.append("Sends a request to a VCS to enter the maintenance mode. Entering the maintenance mode\nwill stop ZooKeeper. If the VCS is already in the maintenance mode, the method does\nnothing and returns silently. If the VCS cannot enter the maintenance mode and is not\nable to rollback, it will restart and enter the maintenance mode when it comes up. In\nthat case the client will receive a connection error.");
        doc.append("\n");
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsEnterMaintenanceMode", "vcsEnterMaintenanceMode", usage, doc.toString());
        usage = "vcsExitMaintenanceMode";
        doc = new StringBuilder();
        doc.append("Sends a request to a VCS to exit the maintenance mode. Exiting the maintenance mode will\nstart RMI (if not already running) and ZooKeeper. If the VCS cannot exit the maintenance\nmode and is not able to rollback, it will restart and exit the maintenance mode when it\ncomes up. In that case the client will receive a connection error. The method will return\nan error if the VCS is not in the maintenance mode.");
        doc.append("\n");
        SvaWebserviceInterfaceCli.addPsvaCommand("vcsExitMaintenanceMode", "vcsExitMaintenanceMode", usage, doc.toString());
        SvaWebserviceInterfaceCli.addPsvaCommand("destroyVCS", "destroyPseudoSva", "destroyVCS", "Does a cleanup of ZooKeeper and SVA state on VSA Cluster Service.\nAfter receiving this request, the VSA Cluster Service process will\nterminate and it will delete the state when it is restarted.\nThis will result in removing VSA Cluster Service from the cluster.\nIf the process is configured as a service, the process \nwill automatically restart. Otherwise, VSA Cluster Service would need\nneed to be started manually.\n");
        versionSupportingRepair = 5.5;
        startTime = new Date();
        commandName = "";
        WARNING_TAG = "\n***************** WARNING *****************\n";
        password = "svapass";
        REPAIR_WAIT_MS = 90000L;
    }

    private static class CommandInfo {
        private static final Map<String, CommandInfo> commandMap = new HashMap<String, CommandInfo>();
        static final List<CommandInfo> commandList = new ArrayList<CommandInfo>();
        final String command;
        final CommandType commandType;
        final String usage;
        private final Method method;
        final String doc;

        CommandInfo(String command, CommandType commandType, String methodName, String usage, String doc) {
            this.command = command;
            this.commandType = commandType;
            try {
                this.method = SvaWebserviceInterfaceCli.class.getDeclaredMethod(methodName, WebServiceInterface.class, String.class, String[].class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Method " + methodName + "(WebServiceInterface, String, String[])" + " was not found");
            }
            if (Integer.TYPE != this.method.getReturnType()) {
                throw new IllegalArgumentException("Method " + methodName + " must have return type int");
            }
            if (!Modifier.isStatic(this.method.getModifiers())) {
                throw new IllegalArgumentException("Method " + methodName + " must be static");
            }
            this.method.setAccessible(true);
            this.usage = usage;
            this.doc = doc;
            commandMap.put(command.toLowerCase(), this);
            commandList.add(this);
        }

        static CommandInfo get(String command) {
            return commandMap.get(command.toLowerCase());
        }

        int call(WebServiceInterface ws, String ipAddress, String[] args) throws java.lang.Exception {
            try {
                return (Integer)this.method.invoke(null, ws, ipAddress, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof java.lang.Exception) {
                    throw (java.lang.Exception)cause;
                }
                throw e;
            }
        }
    }

    static enum CommandType {
        SAS("SAS"),
        SVA("SVA"),
        CLIENT("Client-side"),
        PSEUDOSVA("VSA Cluster Service (VCS a.k.a. PseudoSVA)");

        final String prettyName;

        private CommandType(String prettyName) {
            this.prettyName = prettyName;
        }
    }

    private static class UsageException
    extends java.lang.Exception {
        private static final long serialVersionUID = 1L;

        UsageException(String message) {
            super(message);
        }

        UsageException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class StorageEntityComparator
    implements Comparator<AbstractStorageEntity> {
        @Override
        public int compare(AbstractStorageEntity storageEntity1, AbstractStorageEntity storageEntity2) {
            return storageEntity1.getAccessInterface().getIpAddress().getIPAddress().compareTo(storageEntity2.getAccessInterface().getIpAddress().getIPAddress());
        }
    }

    public static class MemberSvaComparator
    implements Comparator<MemberSva> {
        @Override
        public int compare(MemberSva memberSva1, MemberSva memberSva2) {
            return memberSva1.getManagementInterface().getIpAddress().getIPAddress().compareTo(memberSva2.getManagementInterface().getIpAddress().getIPAddress());
        }
    }
}

