/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.util.ArrayList;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Replicator {
    private static final Log log = LogFactory.getLog(Replicator.class);

    public static void replicate(MessageContext msgContext) throws ClusteringFault {
        ServiceContext serviceContext;
        ServiceGroupContext sgContext;
        if (!Replicator.canReplicate(msgContext)) {
            return;
        }
        log.debug("Going to replicate state stored in ConfigurationContext, ServiceGroupContext, ServiceContext associated with " + msgContext + "...");
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        ContextManager contextManager = Replicator.getContextManager(msgContext);
        ArrayList<AbstractContext> contexts = new ArrayList<AbstractContext>();
        if (!configurationContext.getPropertyDifferences().isEmpty()) {
            contexts.add(configurationContext);
        }
        if ((sgContext = msgContext.getServiceGroupContext()) != null && !sgContext.getPropertyDifferences().isEmpty()) {
            contexts.add(sgContext);
        }
        if ((serviceContext = msgContext.getServiceContext()) != null && !serviceContext.getPropertyDifferences().isEmpty()) {
            contexts.add(serviceContext);
        }
        if (!contexts.isEmpty()) {
            AbstractContext[] contextArray = contexts.toArray(new AbstractContext[contexts.size()]);
            contextManager.updateContexts(contextArray);
        }
    }

    public static void replicate(AbstractContext abstractContext) throws ClusteringFault {
        if (!Replicator.canReplicate(abstractContext)) {
            return;
        }
        log.debug("Going to replicate state in " + abstractContext + "...");
        ContextManager contextManager = Replicator.getContextManager(abstractContext);
        if (!abstractContext.getPropertyDifferences().isEmpty()) {
            contextManager.updateContext(abstractContext);
        }
    }

    public static void replicate(AbstractContext abstractContext, String[] propertyNames) throws ClusteringFault {
        if (!Replicator.canReplicate(abstractContext)) {
            return;
        }
        log.debug("Going to replicate selected properties in " + abstractContext + "...");
        ContextManager contextManager = Replicator.getContextManager(abstractContext);
        contextManager.updateContext(abstractContext, propertyNames);
    }

    private static ClusterManager getClusterManager(AbstractContext abstractContext) {
        return abstractContext.getRootContext().getAxisConfiguration().getClusterManager();
    }

    private static ContextManager getContextManager(AbstractContext abstractContext) {
        return Replicator.getClusterManager(abstractContext).getContextManager();
    }

    private static boolean canReplicate(AbstractContext abstractContext) {
        ClusterManager clusterManager = abstractContext.getRootContext().getAxisConfiguration().getClusterManager();
        boolean canReplicate = false;
        if (clusterManager != null && clusterManager.getContextManager() != null) {
            canReplicate = clusterManager.getContextManager().isContextClusterable(abstractContext);
        }
        return canReplicate;
    }

    private static boolean canReplicate(MessageContext messageContext) {
        ClusterManager clusterManager = messageContext.getRootContext().getAxisConfiguration().getClusterManager();
        return clusterManager != null && clusterManager.getContextManager() != null;
    }
}

