/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.xml.namespace.QName;
import javax.xml.ws.Response;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.AttachmentType;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.description.impl.AttachmentDescriptionImpl;
import org.apache.axis2.jaxws.description.impl.HandlerChainsParser;
import org.apache.axis2.jaxws.description.impl.OperationDescriptionImpl;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionUtils {
    private static final Log log = LogFactory.getLog(DescriptionUtils.class);
    static final String NO_PACKAGE_HOST_NAME = "DefaultNamespace";

    static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    static boolean isEmpty(QName qname) {
        return qname == null || DescriptionUtils.isEmpty(qname.getLocalPart());
    }

    static boolean falseExclusionsExist(DescriptionBuilderComposite dbc) {
        MethodDescriptionComposite mdc2 = null;
        for (MethodDescriptionComposite mdc2 : dbc.getMethodDescriptionsList()) {
            WebMethodAnnot wma = mdc2.getWebMethodAnnot();
            if (wma == null || wma.exclude()) continue;
            return true;
        }
        return false;
    }

    static ArrayList<MethodDescriptionComposite> getMethodsWithFalseExclusions(DescriptionBuilderComposite dbc) {
        ArrayList<MethodDescriptionComposite> mdcList = new ArrayList<MethodDescriptionComposite>();
        Iterator<MethodDescriptionComposite> iter = dbc.getMethodDescriptionsList().iterator();
        if (DescriptionUtils.falseExclusionsExist(dbc)) {
            while (iter.hasNext()) {
                MethodDescriptionComposite mdc = iter.next();
                if (mdc.getWebMethodAnnot() == null || mdc.getWebMethodAnnot().exclude()) continue;
                mdc.setDeclaringClass(dbc.getClassName());
                mdcList.add(mdc);
            }
        }
        return mdcList;
    }

    static boolean isExcludeTrue(MethodDescriptionComposite mdc) {
        return mdc.getWebMethodAnnot() != null && mdc.getWebMethodAnnot().exclude();
    }

    static String javifyClassName(String className) {
        if (className.indexOf("/") != -1) {
            return className.replaceAll("/", ".");
        }
        return className;
    }

    static String getSimpleJavaClassName(String name) {
        String returnName = null;
        if (name != null) {
            String fqName = name;
            int endOfPackageIndex = fqName.lastIndexOf(46);
            int startOfClassIndex = endOfPackageIndex + 1;
            returnName = fqName.substring(startOfClassIndex);
        }
        return returnName;
    }

    static String getJavaPackageName(String theClassName) {
        String fqName;
        int endOfPackageIndex;
        String returnPackage = null;
        if (theClassName != null && (endOfPackageIndex = (fqName = theClassName).lastIndexOf(46)) >= 0) {
            returnPackage = fqName.substring(0, endOfPackageIndex);
        }
        return returnPackage;
    }

    static String makeNamespaceFromPackageName(String packageName, String protocol) {
        if (DescriptionUtils.isEmpty(protocol)) {
            protocol = "http";
        }
        if (DescriptionUtils.isEmpty(packageName)) {
            return protocol + "://" + NO_PACKAGE_HOST_NAME;
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString() + "/";
    }

    static boolean createOperationDescription(String methodName) {
        return !methodName.equals("<init>");
    }

    public static InputStream openHandlerConfigStream(String configFile, String className, ClassLoader classLoader) {
        InputStream configStream = null;
        if (log.isDebugEnabled()) {
            log.debug("Attempting to load @HandlerChain configuration file: " + configFile + " relative to class: " + className);
        }
        try {
            URL configURL = new URL(configFile);
            if (configURL != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found absolute @HandlerChain configuration file: " + configFile);
                }
                configStream = configURL.openStream();
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("hcConfigLoadFail", configFile, className, e.toString()));
        }
        if (configStream == null) {
            if (log.isDebugEnabled()) {
                log.debug("@HandlerChain.file attribute refers to a relative location: " + configFile);
            }
            className = className.replace(".", "/");
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Resolving @HandlerChain configuration file: " + configFile + " relative to class file: " + className);
                }
                URI uri = new URI(className);
                uri = uri.resolve(configFile);
                String resolvedPath = uri.toString();
                if (log.isDebugEnabled()) {
                    log.debug("@HandlerChain.file resolved file path location: " + resolvedPath);
                }
                configStream = DescriptionUtils.getInputStream(resolvedPath, classLoader);
            }
            catch (URISyntaxException e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("hcConfigLoadFail", configFile, className, e.toString()));
            }
        }
        if (configStream == null) {
            if (log.isDebugEnabled()) {
                log.debug("@HandlerChain configuration fail: " + configFile + " in class: " + className + " failed to load.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("@HandlerChain configuration file: " + configFile + " in class: " + className + " was successfully loaded.");
        }
        return configStream;
    }

    private static InputStream getInputStream(String path, ClassLoader classLoader) {
        ClassLoader cl;
        InputStream configStream = classLoader.getResourceAsStream(path);
        if (configStream == null && (cl = System.class.getClassLoader()) != null) {
            configStream = cl.getResourceAsStream(path);
        }
        if (configStream == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            configStream = cl.getResourceAsStream(path);
        }
        return configStream;
    }

    public static boolean isAsync(Method method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        Class<Future> returnType = method.getReturnType();
        return methodName.endsWith("Async") && (returnType.isAssignableFrom(Response.class) || returnType.isAssignableFrom(Future.class));
    }

    public static HandlerChainsType loadHandlerChains(InputStream is, ClassLoader classLoader) {
        try {
            HandlerChainsParser parser = new HandlerChainsParser();
            return parser.loadHandlerChains(is);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("loadHandlerChainErr", e.getMessage()));
        }
    }

    public static String getNamespaceFromSOAPElement(List extElements) {
        for (Object extObj : extElements) {
            MIMEMultipartRelated mime;
            List mimeParts;
            Iterator itr;
            if (extObj instanceof SOAPBody) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAPBody namespace: " + ((SOAPBody)extObj).getNamespaceURI());
                }
                return ((SOAPBody)extObj).getNamespaceURI();
            }
            if (extObj instanceof SOAP12Body) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAP12Body namespace: " + ((SOAP12Body)extObj).getNamespaceURI());
                }
                return ((SOAP12Body)extObj).getNamespaceURI();
            }
            if (extObj instanceof SOAPHeader) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAPHeader namespace: " + ((SOAPHeader)extObj).getNamespaceURI());
                }
                return ((SOAPHeader)extObj).getNamespaceURI();
            }
            if (extObj instanceof SOAP12Header) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning SOAP12Header namespace: " + ((SOAP12Header)extObj).getNamespaceURI());
                }
                return ((SOAP12Header)extObj).getNamespaceURI();
            }
            if (!(extObj instanceof MIMEMultipartRelated)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found a MIMEMultipartRelated element.  Unwrapping to get SOAP binding.");
            }
            if (!(itr = (mimeParts = (mime = (MIMEMultipartRelated)extObj).getMIMEParts()).iterator()).hasNext()) continue;
            MIMEPart mimePart = (MIMEPart)itr.next();
            List elements = mimePart.getExtensibilityElements();
            String ns = DescriptionUtils.getNamespaceFromSOAPElement(elements);
            return ns;
        }
        return null;
    }

    public static void getAttachmentFromBinding(OperationDescriptionImpl opDesc, Binding binding) {
        if (binding != null) {
            for (BindingOperation bindingOp : binding.getBindingOperations()) {
                if (!bindingOp.getName().equals(opDesc.getName().getLocalPart())) continue;
                if (bindingOp.getBindingInput() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Processing binding opertion input");
                    }
                    DescriptionUtils.processBindingForMIME(bindingOp.getBindingInput().getExtensibilityElements(), opDesc, bindingOp.getOperation(), true);
                }
                if (bindingOp.getBindingOutput() == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Processing binding output");
                }
                DescriptionUtils.processBindingForMIME(bindingOp.getBindingOutput().getExtensibilityElements(), opDesc, bindingOp.getOperation(), false);
            }
        }
    }

    private static void processBindingForMIME(List extensibilityElements, OperationDescriptionImpl opDesc, Operation operation, boolean isRequest) {
        for (Object obj : extensibilityElements) {
            if (!(obj instanceof MIMEMultipartRelated)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found a mime:multipartRelated extensiblity element.");
            }
            MIMEMultipartRelated mime = (MIMEMultipartRelated)obj;
            Iterator partIter = mime.getMIMEParts().iterator();
            while (partIter.hasNext()) {
                if (log.isDebugEnabled()) {
                    log.debug("Found a mime:part child element.");
                }
                MIMEPart mimePart = (MIMEPart)partIter.next();
                for (Object obj2 : mimePart.getExtensibilityElements()) {
                    if (obj2 instanceof MIMEContent) {
                        MIMEContent mimeContent = (MIMEContent)obj2;
                        String part = mimeContent.getPart();
                        String type = mimeContent.getType();
                        if (opDesc.getPartAttachmentDescription(part) == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Adding new AttachmentDescription for part: " + part + " on operation: " + opDesc.getOperationName());
                            }
                            AttachmentDescriptionImpl attachmentDesc = new AttachmentDescriptionImpl(AttachmentType.SWA, new String[]{type});
                            opDesc.addPartAttachmentDescription(part, attachmentDesc);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Already created AttachmentDescription for part: " + part + " of type: " + type);
                        continue;
                    }
                    if (!(obj2 instanceof SOAPBody) && !(obj2 instanceof SOAP12Body)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Found a body element with potential nested mime content");
                    }
                    if (isRequest) {
                        opDesc.setHasRequestSwaRefAttachments(true);
                        continue;
                    }
                    opDesc.setHasResponseSwaRefAttachments(true);
                }
            }
        }
    }

    public static void registerHandlerHeaders(AxisService axisService, List<Handler> handlers) {
        if (handlers == null || axisService == null) {
            return;
        }
        ArrayList<QName> understoodHeaderQNames = new ArrayList<QName>();
        for (Handler handler : handlers) {
            SOAPHandler soapHandler;
            Set<QName> headers;
            if (!(handler instanceof SOAPHandler) || (headers = (soapHandler = (SOAPHandler)handler).getHeaders()) == null) continue;
            for (QName header : headers) {
                if (understoodHeaderQNames.contains(header)) continue;
                understoodHeaderQNames.add(header);
            }
        }
        if (!understoodHeaderQNames.isEmpty()) {
            Parameter headerQNParameter = new Parameter("org.apache.axis2.jaxws.description.EndpointDescription.handlerParameterQNames", understoodHeaderQNames);
            try {
                axisService.addParameter(headerQNParameter);
            }
            catch (AxisFault e) {
                log.warn(Messages.getMessage("regHandlerHeadersErr", axisService.getName(), e.getMessage()));
            }
        }
    }

    public static String mapBindingTypeAnnotationToWsdl(String annotationBindingType) {
        String wsdlBindingType = null;
        if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(annotationBindingType) || "http://www.example.org/2006/06/soap/bindings/JMS/".equals(annotationBindingType)) {
            wsdlBindingType = "http://schemas.xmlsoap.org/wsdl/soap/";
        } else if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(annotationBindingType) || "http://www.example.org/2006/06/soap/bindings/JMS/".equals(annotationBindingType)) {
            wsdlBindingType = "http://schemas.xmlsoap.org/wsdl/soap12/";
        } else if ("http://www.w3.org/2004/08/wsdl/http".equals(annotationBindingType)) {
            wsdlBindingType = "http://schemas.xmlsoap.org/wsdl/http/";
        }
        return wsdlBindingType;
    }

    public static String mapBindingTypeWsdlToAnnotation(String wsdlBindingType, String soapTransport) {
        String soapBindingType = null;
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(wsdlBindingType)) {
            soapBindingType = "http://www.example.org/2006/06/soap/bindings/JMS/".equals(soapTransport) ? "http://www.example.org/2006/06/soap/bindings/JMS/" : "http://schemas.xmlsoap.org/wsdl/soap/http";
        } else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(wsdlBindingType)) {
            soapBindingType = "http://www.example.org/2006/06/soap/bindings/JMS/".equals(soapTransport) ? "http://www.example.org/2006/06/soap/bindings/JMS/" : "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        } else if ("http://schemas.xmlsoap.org/wsdl/http/".equals(wsdlBindingType)) {
            soapBindingType = "http://www.w3.org/2004/08/wsdl/http";
        }
        return soapBindingType;
    }
}

