/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.ft;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.BusinessLogicDomainBlcAPI;
import com.vmware.sva.bld.nonpersistent.AbstractNonPersistentDomainBlcMessage;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.BlcEventAddressInfo;
import com.vmware.sva.services.logger.LoggerRequest;
import com.vmware.sva.services.logger.LoggerService;
import java.util.UUID;
import java.util.logging.Level;

public abstract class AbstractFtBusinessLogicComponent
extends AbstractBusinessLogicComponent {
    private static final long serialVersionUID = 1L;

    public AbstractFtBusinessLogicComponent(String name, UUID parentBlcId, BusinessLogicDomainBlcAPI domain) {
        super(name, parentBlcId, domain);
    }

    public AbstractFtBusinessLogicComponent(UUID id, String name, UUID parentBlcId) {
        super(id, name, parentBlcId);
    }

    public AbstractFtBusinessLogicComponent(UUID id, String name, UUID parentBlcId, BusinessLogicDomainBlcAPI domain) {
        super(id, name, parentBlcId, domain);
    }

    @Override
    protected void sendLoggerRequest(LoggerRequest loggerRequest) {
        this.asyncServiceRequest(LoggerService.SERVICE_ID, loggerRequest);
    }

    @Override
    protected void sendMessage(BlcEventAddressInfo header, AbstractBlcMessage msg) {
        UUID destinationBld = header.getDestinationBld();
        if (!destinationBld.equals(SvaConstants.DefaultUUID)) {
            UUID destinationBldInstantiationId = this.getBldInstantiationId(destinationBld);
            msg.setBldInstantiationId(destinationBldInstantiationId);
        }
        super.sendMessage(header, msg);
    }

    @Override
    protected boolean validEvent(AbstractBlcEvent event) {
        if (event instanceof AbstractNonPersistentDomainBlcMessage) {
            AbstractNonPersistentDomainBlcMessage nonPersistentBlcMessage = (AbstractNonPersistentDomainBlcMessage)event;
            UUID srcBldId = nonPersistentBlcMessage.getHeader().getSourceBld();
            UUID currentInstantiationId = this.getBldInstantiationId(srcBldId);
            UUID msgInstantiationId = nonPersistentBlcMessage.getBldInstantiationId();
            if (currentInstantiationId == null) {
                this.log(Level.INFO, "Message from OFFLINE member domain " + srcBldId + " discarded");
                return false;
            }
            if (!currentInstantiationId.equals(msgInstantiationId)) {
                this.log(Level.INFO, "Message from rebooted member domain " + srcBldId + " discarded");
                this.log(Level.INFO, "ID from message = " + msgInstantiationId + ", current ID = " + currentInstantiationId);
                return false;
            }
        }
        return true;
    }

    private UUID getBldInstantiationId(UUID bldId) {
        return this.getBld().getBldInstantiationId(bldId);
    }
}

