/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.AbstractDbTable;
import com.vmware.sva.database.AbstractPersistentBldDatabase;
import com.vmware.sva.database.VersionDbTable;
import com.vmware.sva.util.LoggerAdapter;
import com.vmware.sva.util.SystemUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public abstract class AbstractQueueDbTable
extends AbstractDbTable {
    private static final String DB_TABLE_COLUMNS = SvaConstants.USE_XSTREAM ? "(event BIGINT, data LONG VARCHAR)" : "(event BIGINT, data BLOB)";
    protected long count;
    private long tail;
    private long head;
    private final AbstractPersistentBldDatabase database;

    public AbstractQueueDbTable(Connection connection, String tableName, AbstractPersistentBldDatabase database) throws SQLException, BldException {
        super(connection, tableName, DB_TABLE_COLUMNS);
        this.database = database;
        this.count = this.getLongAttribute("COUNT");
        if (this.count == 0L) {
            this.tail = 0L;
            this.head = 0L;
        } else {
            this.tail = this.getLongAttribute("MIN") - 1L;
            this.head = this.getLongAttribute("MAX");
        }
        if (this.head - this.tail != this.count) {
            this.forceReboot("The head and tail do not match the number of items in the persisted queue " + tableName + ", head=" + this.head + " tail=" + this.tail + " count=" + this.count);
        }
    }

    @Override
    public void upgrade(VersionDbTable versionTable) throws Exception {
        this.upgradeColumn("data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addObject(Object obj) throws Exception {
        if (this.head - this.tail != this.count) {
            this.forceReboot("Table " + this.tableName + " is inconsistent before adding object: head=" + this.head + " tail=" + this.tail + " count=" + this.count + " obj=" + obj);
        }
        PreparedStatement pstmt = this.connection.prepareStatement("INSERT INTO \"" + this.tableName + "\" VALUES(?,?)");
        try {
            pstmt.setLong(1, ++this.head);
            this.setPstmtArg(pstmt, 2, obj);
            pstmt.execute();
            ++this.count;
        }
        finally {
            pstmt.close();
        }
        if (this.head - this.tail != this.count) {
            this.forceReboot("Table " + this.tableName + " is inconsistent after adding object: head=" + this.head + " tail=" + this.tail + " count=" + this.count + " obj=" + obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTail() throws Exception {
        Statement s = this.connection.createStatement();
        try {
            Object obj;
            ResultSet rs = s.executeQuery("SELECT data FROM \"" + this.tableName + "\" WHERE event = " + (this.tail + 1L));
            if (!rs.next()) {
                this.log(Level.WARNING, "Attempt to get tail from empty queue " + this.tableName);
                Object var3_3 = null;
                return var3_3;
            }
            Object object = obj = SvaConstants.USE_XSTREAM ? BldSerialization.xmlToObject(rs.getString("data")) : BldSerialization.bytesToObject(rs.getBytes("data"));
            return object;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObject() throws SQLException {
        if (this.head - this.tail != this.count) {
            this.forceReboot("Table " + this.tableName + " is inconsistent before removing object: head=" + this.head + " tail=" + this.tail + " count=" + this.count);
        }
        if (this.head <= this.tail) {
            this.forceReboot("Attempt to remove object from empty queue " + this.tableName + ": head=" + this.head + " tail=" + this.tail + " count=" + this.count);
        }
        PreparedStatement pstmt = this.connection.prepareStatement("DELETE FROM \"" + this.tableName + "\" WHERE event = ?");
        try {
            pstmt.setLong(1, ++this.tail);
            pstmt.execute();
            if (--this.count == 0L) {
                this.tail = 0L;
                this.head = 0L;
            }
        }
        finally {
            pstmt.close();
        }
        if (this.head - this.tail != this.count) {
            this.forceReboot("Table " + this.tableName + " is inconsistent after removing object: head=" + this.head + " tail=" + this.tail + " count=" + this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="Need to iterate over keys in sorted order")
    protected List<Object> getObjects() throws Exception {
        Statement statement = this.connection.createStatement();
        try {
            HashMap<Long, Object> objMap;
            ResultSet rs = statement.executeQuery("SELECT * FROM \"" + this.tableName + "\"");
            ArrayList<Object> objs = new ArrayList<Object>();
            ArrayList<Long> sortedKeys = new ArrayList<Long>();
            if (SvaConstants.USE_XSTREAM) {
                objMap = new HashMap<Long, Object>();
                while (rs.next()) {
                    objMap.put(rs.getLong("event"), rs.getString("data"));
                }
                Set objKeys = objMap.keySet();
                for (Long key : objKeys) {
                    sortedKeys.add(key);
                }
                Collections.sort(sortedKeys);
                for (Long key : sortedKeys) {
                    objs.add(BldSerialization.xmlToObject((String)objMap.get(key)));
                }
            } else {
                objMap = new HashMap();
                while (rs.next()) {
                    objMap.put(rs.getLong("event"), rs.getBytes("data"));
                }
                Set objKeys = objMap.keySet();
                for (Long key : objKeys) {
                    sortedKeys.add(key);
                }
                Collections.sort(sortedKeys);
                for (Long key : sortedKeys) {
                    objs.add(BldSerialization.bytesToObject((byte[])objMap.get(key)));
                }
            }
            ArrayList<Object> arrayList = objs;
            return arrayList;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLongAttribute(String attr) throws SQLException, BldException {
        Statement statement = this.connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("SELECT " + attr + "(event) FROM \"" + this.tableName + "\"");
            if (!rs.next()) {
                throw new BldException("Could not get attribute");
            }
            long l = rs.getLong(1);
            return l;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        this.log(Level.FINE, "Validating database table " + this.tableName);
        try {
            long pCount = this.getLongAttribute("COUNT");
            long pHead = 0L;
            long pTail = 0L;
            if (pCount != 0L) {
                pHead = this.getLongAttribute("MAX");
                pTail = this.getLongAttribute("MIN") - 1L;
            }
            if (this.count != pCount || this.head != pHead || this.tail != pTail) {
                throw new Exception("count=" + this.count + " pCount=" + pCount + " head=" + this.head + " pHead=" + pHead + " tail=" + this.tail + " pTail=" + pTail);
            }
            if (this.count != this.head - this.tail) {
                throw new Exception("count (" + this.count + ") != head (" + this.head + ") - tail (" + this.tail + ")");
            }
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT * FROM \"" + this.tableName + "\"");
                ArrayList<Long> keys = new ArrayList<Long>();
                while (rs.next()) {
                    long key = rs.getLong("event");
                    keys.add(key);
                    if (SvaConstants.USE_XSTREAM) {
                        BldSerialization.xmlToObject(rs.getString("data"));
                    } else {
                        BldSerialization.bytesToObject(rs.getBytes("data"));
                    }
                    this.log(Level.FINE, "Validated event " + key);
                }
                Collections.sort(keys);
                Long lastKey = null;
                Iterator i$ = keys.iterator();
                while (i$.hasNext()) {
                    long key = (Long)i$.next();
                    if (lastKey != null && key != lastKey + 1L) {
                        throw new Exception("key " + key + " is not linearly increasing from key " + lastKey);
                    }
                    lastKey = key;
                }
            }
            finally {
                statement.close();
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to validate table " + this.tableName, e);
            return false;
        }
        this.log(Level.FINE, "Database table " + this.tableName + " is valid");
        return true;
    }

    protected void forceReboot(String msg) {
        try {
            this.database.setDatabaseCorrupt();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Failed to set database corrupt");
        }
        this.log(Level.SEVERE, "AbstractQueueDbTable inconsistency!", new Exception(msg));
        SystemUtils.reboot(true, null, new LoggerAdapter(logger));
    }
}

