/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.bld.BldException;
import com.vmware.sva.database.AbstractDbTable;
import com.vmware.sva.database.VersionDbTable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class GenerationDbTable
extends AbstractDbTable {
    private static final String DB_TABLE_NAME = "GENERATION_TABLE";
    private static final String DB_TABLE_COLUMNS = "(name VARCHAR(255), data BIGINT)";
    private static final String key = "GENERATION";

    public GenerationDbTable(Connection connection) throws SQLException, BldException {
        super(connection, DB_TABLE_NAME, DB_TABLE_COLUMNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable() throws SQLException, BldException {
        super.createTable();
        try {
            this.getGeneration();
            return;
        }
        catch (Exception e) {
            PreparedStatement pstmt = this.connection.prepareStatement("INSERT INTO \"" + this.tableName + "\" VALUES(?,?)");
            try {
                pstmt.setString(1, key);
                pstmt.setLong(2, 0L);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGeneration() throws BldException, SQLException {
        Statement statement = this.connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("SELECT data FROM \"" + this.tableName + "\" WHERE name = '" + key + "'");
            if (!rs.next()) {
                throw new BldException("Generation not written");
            }
            long gen = rs.getLong("data");
            if (rs.next()) {
                this.log(Level.SEVERE, "Multiple records found for generation");
            }
            long l = gen;
            return l;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        boolean bl;
        this.log(Level.FINE, "Validating database table " + this.tableName);
        Statement statement = this.connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("SELECT data FROM \"" + this.tableName + "\" WHERE name = '" + key + "'");
            if (!rs.next()) {
                throw new Exception("table " + this.tableName + " does not contain generation number");
            }
            long generation = rs.getLong("data");
            if (generation == -1L) {
                throw new Exception("Database table " + this.tableName + " is marked as corrupted");
            }
            if (rs.next()) {
                throw new Exception("Multiple records found for generation in " + this.tableName);
            }
            this.log(Level.FINE, "Database table " + this.tableName + " is valid");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Unable to validate table " + this.tableName, e);
                return false;
            }
        }
        statement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGeneration(long gen) throws SQLException, IOException {
        PreparedStatement pstmt = this.connection.prepareStatement("UPDATE \"" + this.tableName + "\" SET data = ? WHERE name = ?");
        try {
            pstmt.setLong(1, gen);
            pstmt.setString(2, key);
            pstmt.execute();
        }
        finally {
            pstmt.close();
        }
    }

    @Override
    public void upgrade(VersionDbTable versionTable) {
    }
}

