/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.domainservice;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.bld.QueueBlcEventOperation;
import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.VersionedSerializable;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.domainservice.DomainService;
import com.vmware.sva.util.BasicLoggerInterface;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@VersionedSerializable(value=false)
public abstract class AbstractDomainService
extends AbstractUniqueObject
implements DomainService,
BasicLoggerInterface {
    protected final BusinessLogicDomainServiceAPI domain;
    protected final UUID localDomainId;
    private static final long serialVersionUID = 1L;

    public AbstractDomainService(UUID id, String name, BusinessLogicDomainServiceAPI domain) throws Exception {
        super(id, name);
        this.domain = domain;
        this.localDomainId = domain.getId();
        domain.registerService(this);
    }

    @Override
    public UUID getServiceId() {
        return this.getId();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public AbstractServiceResponse syncRequest(AbstractServiceRequest request) throws Exception {
        this.log(Level.SEVERE, "Service does not implement sycnRequest");
        return null;
    }

    @Override
    public void reprocessPersistRequest(AbstractServiceRequest request) throws Exception {
    }

    @Override
    public void removeBlc(UUID blcId) {
    }

    @Override
    public final void log(LogRecord logRecord) {
        this.domain.log(logRecord);
    }

    @Override
    public final void log(Level level, String msg) {
        this.domain.log(level, msg);
    }

    @Override
    public final void log(Level level, String msg, Throwable thrown) {
        this.domain.log(level, msg, thrown);
    }

    protected void queueBlcEventFromServiceEvent(UUID blcId, AbstractBlcEvent event) {
        BldTransaction transaction = new BldTransaction();
        transaction.add(new QueueBlcEventOperation(blcId, event));
        this.domain.commitTransaction(transaction);
    }
}

