/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.faultinsertion;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.VersionedSerializable;
import com.vmware.sva.faultinsertion.AbstractFault;
import com.vmware.sva.faultinsertion.BlcEdgeFault;
import com.vmware.sva.faultinsertion.FaultFactory;
import com.vmware.sva.faultinsertion.NextPlatformFault;
import com.vmware.sva.faultinsertion.PlatformFault;
import com.vmware.sva.faultinsertion.PlatformFaultFactory;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FaultInsertion {
    private static Map<String, AbstractFault> faults = new HashMap<String, AbstractFault>();
    private static final Logger LOGGER = Logger.getLogger(FaultInsertion.class.getName());
    public static final String FAULT_INSERTION_PROPERTIES = FaultInsertion.getenv("FAULT_PROPERTIES", null);
    public static final String FAULT_INSERTION_PROPERTIES_PATH = SvaConstants.SvaConfigPath + "/fault.properties";
    public static final PlatformFault PLATFORM_AUTHENTICATION_CHANGE_PASSWORD_NO_VERIFY = FaultInsertion.getprop("platform.authentication.change_password_no_verify", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_AUTHENTICATION_CHANGE_PASSWORD = FaultInsertion.getprop("platform.authentication.change_password", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_AUTHENTICATION_AUTHENTICATE = FaultInsertion.getprop("platform.authentication.authenticate", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_DATA_PATH_FILTER_CREATE = FaultInsertion.getprop("platform.data_path_filter.create", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_DATA_PATH_FILTER_DELETE = FaultInsertion.getprop("platform.data_path_filter.delete", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_DATA_PATH_FILTER_GET = FaultInsertion.getprop("platform.data_path_filter.get", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_DATA_PATH_FILTER_RESIZE = FaultInsertion.getprop("platform.data_path_filter.resize", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_DEVICE_MAPPER_CREATE = FaultInsertion.getprop("platform.device_mapper.create", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_DEVICE_MAPPER_DELETE = FaultInsertion.getprop("platform.device_mapper.delete", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_FILESYSTEM_CREATE = FaultInsertion.getprop("platform.filesystem.create", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_FILESYSTEM_MOUNT = FaultInsertion.getprop("platform.filesystem.mount", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_FILESYSTEM_UNMOUNT = FaultInsertion.getprop("platform.filesystem.unmount", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_FILESYSTEM_RESIZE = FaultInsertion.getprop("platform.filesystem.resize", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_FILESYSTEM_GET_BLOCK_COUNT = FaultInsertion.getprop("platform.filesystem.get_block_count", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_FILESYSTEM_GET_BLOCK_SIZE = FaultInsertion.getprop("platform.filesystem.get_block_size", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_FILESYSTEM_GET_FREE_BLOCKS = FaultInsertion.getprop("platform.filesystem.get_free_blocks", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_INITIATOR_GET_REMOTE_DISK = FaultInsertion.getprop("platform.initiator.get_remote_disk", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_INITIATOR_LOGIN = FaultInsertion.getprop("platform.initiator.login", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_INITIATOR_RESCAN = FaultInsertion.getprop("platform.initiator.rescan", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_INITIATOR_REMOVE_REMOTE_DISK = FaultInsertion.getprop("platform.initiator.remove_remote_disk", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_TARGET_EXPORT_DISK = FaultInsertion.getprop("platform.target.export_disk", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_TARGET_UNEXPORT_DISK = FaultInsertion.getprop("platform.target.unexport_disk", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_TARGET_START = FaultInsertion.getprop("platform.target.start", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_TARGET_STOP = FaultInsertion.getprop("platform.target.stop", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_TARGET_UNMAP_LOGICAL_UNIT = FaultInsertion.getprop("platform.target.unmap_logical_unit", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_LOGICAL_VOLUME_START = FaultInsertion.getprop("platform.lvm.start", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_LOGICAL_VOLUME_CREATE = FaultInsertion.getprop("platform.lvm.create", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_LOGICAL_VOLUME_DELETE = FaultInsertion.getprop("platform.lvm.delete", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_LOGICAL_VOLUME_GET = FaultInsertion.getprop("platform.lvm.get", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_PHYSICAL_VOLUME_GET = FaultInsertion.getprop("platform.physicalvolume.get", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_LOGICAL_VOLUME_RESIZE = FaultInsertion.getprop("platform.lvm.resize", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NETWORK_ADD_CONFIG = FaultInsertion.getprop("platform.network.add_config", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NETWORK_REMOVE_CONFIG = FaultInsertion.getprop("platform.network.remove_config", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NETWORK_PING = FaultInsertion.getprop("platform.network.ping", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NETWORK_SEND_ARP = FaultInsertion.getprop("platform.network.send_arp", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NFS_CLOSE_CONNECTIONS = FaultInsertion.getprop("platform.nfs.close_connections", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NFS_EXPORT = FaultInsertion.getprop("platform.nfs.export", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NFS_UNEXPORT = FaultInsertion.getprop("platform.nfs.unexport", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NFS_STOP = FaultInsertion.getprop("platform.nfs.stop", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_NFS_START = FaultInsertion.getprop("platform.nfs.start", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_PING_PING = FaultInsertion.getprop("platform.ping.ping", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_PHYSICAL_VOLUME_RESIZE = FaultInsertion.getprop("platform.physicalvolume.resize", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_ADD_DISK = FaultInsertion.getprop("platform.raid.add_disk", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_ASSEMBLE = FaultInsertion.getprop("platform.raid.assemble", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_CREATE = FaultInsertion.getprop("platform.raid.create", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_FAULT_DISK = FaultInsertion.getprop("platform.raid.fault_disk", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_REMOVE_DISK = FaultInsertion.getprop("platform.raid.remove_disk", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_RESIZE = FaultInsertion.getprop("platform.raid.resize", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_GET_SIZE = FaultInsertion.getprop("platform.raid.get_size", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_STOP = FaultInsertion.getprop("platform.raid.stop", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAID_GET_DIRTY_CHUCK_COUNT = FaultInsertion.getprop("platform.raid.get.dirty_chunk_count", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAIDSTATUS_GET_FAILED_DISKS = FaultInsertion.getprop("platform.raidstatus.get_failed_disks", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_RAIDSTATUS_GET_SPARE_DISKS = FaultInsertion.getprop("platform.raidstatus.get_spare_disks", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_SYSTEMSERVICE_GET_VERSION_INFO = FaultInsertion.getprop("platform.systemservice.get_version_info", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_SYSTEMSERVICE_SVA_SUPPORT = FaultInsertion.getprop("platform.systemservice.sva_support", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_SYSTEMSERVICE_ZIP_FILES = FaultInsertion.getprop("platform.systemservice.zio_files", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_VOLUME_GROUP_GET = FaultInsertion.getprop("platform.volumegroup.volumegroup.get", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_VOLUME_GROUP_RESIZE = FaultInsertion.getprop("platform.volumegroup.resize", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_WATCHDOG_CREATE = FaultInsertion.getprop("platform.watchdog.create", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_WATCHDOG_DELETE = FaultInsertion.getprop("platform.watchdog.delete", PlatformFaultFactory.INSTANCE);
    public static final PlatformFault PLATFORM_WATCHDOG_KEEP_ALIVE = FaultInsertion.getprop("platform.watchdog.keep_alive", PlatformFaultFactory.INSTANCE);
    public static final NextPlatformFault PLATFORM_FAIL_NEXT_COMMAND = FaultInsertion.getprop("platform.fail_next_command", NextPlatformFault.FACTORY);
    public static final BlcEdgeFault BLC_EDGE = FaultInsertion.getprop("blc.edge", BlcEdgeFault.FACTORY);
    private static Properties properties = null;

    private static String getenv(String envname, String defaultValue) {
        Map<String, String> env = System.getenv();
        return env.containsKey(envname) ? env.get(envname) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadProperties() {
        if (properties == null) {
            String error = "Failure when reading Fault Insertion properties: ";
            properties = new Properties();
            FileReader in = null;
            try {
                in = new FileReader(FAULT_INSERTION_PROPERTIES_PATH);
                properties.load(in);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, error + e.getMessage(), e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            try {
                if (FAULT_INSERTION_PROPERTIES != null) {
                    properties.load(new StringReader(FAULT_INSERTION_PROPERTIES));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, error + e.getMessage(), e);
            }
        }
    }

    private static synchronized <F extends AbstractFault> F getprop(String name, FaultFactory<F> faultFactory) {
        FaultInsertion.loadProperties();
        String faultProps = properties.getProperty(name);
        List<Object> attribs = faultProps == null ? Collections.emptyList() : Arrays.asList(faultProps.split(" "));
        F fault = faultFactory.createFault(name, attribs);
        faults.put(name, (AbstractFault)fault);
        return fault;
    }

    private static String getFaultName(List<String> args) throws Exception {
        String name;
        block6: {
            name = null;
            if (args != null) {
                int nameIndex = args.indexOf("-name");
                if (nameIndex >= 0) {
                    args.remove(nameIndex);
                    try {
                        name = args.get(nameIndex);
                        args.remove(nameIndex);
                        if (!faults.containsKey(name)) {
                            throw new Exception("Fault '" + name + "' not found.");
                        }
                        break block6;
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new Exception("You must supply a fault name after the -name option.");
                    }
                }
                if (args.size() == 1) {
                    throw new Exception("You must supply the -name option when specifying a fault name.");
                }
            }
        }
        return name;
    }

    private static String clearFault(List<String> args) throws Exception {
        String result = null;
        String name2 = FaultInsertion.getFaultName(args);
        if (name2 != null) {
            AbstractFault fault = faults.get(name2);
            fault.clear();
            result = fault.list();
        } else {
            for (String name2 : faults.keySet()) {
                AbstractFault fault = faults.get(name2);
                fault.clear();
            }
            result = FaultInsertion.listFault(null);
        }
        return result;
    }

    private static String listFault(List<String> args) throws Exception {
        StringBuilder result = new StringBuilder();
        String name2 = FaultInsertion.getFaultName(args);
        if (name2 != null) {
            AbstractFault fault = faults.get(name2);
            result.append(fault.list());
        } else {
            TreeSet<String> sortedSet = new TreeSet<String>(faults.keySet());
            for (String name2 : sortedSet) {
                AbstractFault fault = faults.get(name2);
                result.append(fault.list()).append("\n");
            }
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private static String resetFault(List<String> args) throws Exception {
        String result = null;
        String name2 = FaultInsertion.getFaultName(args);
        if (name2 != null) {
            AbstractFault fault = faults.get(name2);
            fault.reset();
            result = fault.list();
        } else {
            for (String name2 : faults.keySet()) {
                AbstractFault fault = faults.get(name2);
                fault.reset();
            }
            result = FaultInsertion.listFault(null);
        }
        return result;
    }

    private static synchronized String saveAllFaults() throws Exception {
        FileWriter out = null;
        String result = null;
        SortedProperties sp = new SortedProperties();
        for (AbstractFault fault : faults.values()) {
            sp.put(fault.getName(), fault.toString());
        }
        try {
            out = new FileWriter(FAULT_INSERTION_PROPERTIES_PATH);
            sp.store(out, null);
            out.close();
            out = null;
            result = "Faults saved to " + FAULT_INSERTION_PROPERTIES_PATH;
        }
        catch (IOException e) {
            throw new Exception("Failed to save Fault Insertion properties: " + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    private static synchronized String setFault(List<String> args) throws Exception {
        String result = null;
        String name = FaultInsertion.getFaultName(args);
        if (name == null) {
            throw new Exception("You must supply a fault name and at least one attribute to set.");
        }
        if (args.size() == 0) {
            throw new Exception("You must supply at least one attribute to set.");
        }
        AbstractFault fault = faults.get(name);
        fault.set(args);
        result = fault.list();
        return result;
    }

    public static String doFaultInsertion(List<String> args) throws Exception {
        LOGGER.log(Level.INFO, "Received command: " + args.toString());
        String command = args.remove(0);
        String result = null;
        if (command.equalsIgnoreCase("clear")) {
            result = FaultInsertion.clearFault(args);
        } else if (command.equalsIgnoreCase("list")) {
            result = FaultInsertion.listFault(args);
        } else if (command.equalsIgnoreCase("reset")) {
            result = FaultInsertion.resetFault(args);
        } else if (command.equalsIgnoreCase("saveAll")) {
            result = FaultInsertion.saveAllFaults();
        } else if (command.equalsIgnoreCase("set")) {
            result = FaultInsertion.setFault(args);
        } else {
            throw new Exception("The command '" + command + "' is invalid.");
        }
        return result;
    }

    @VersionedSerializable(value=false)
    private static final class SortedProperties
    extends Properties {
        private static final Comparator<Object> STRING_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object x, Object y) {
                return ((String)x).compareTo((String)y);
            }
        };
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public Enumeration<Object> keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<Object> keyList = new Vector<Object>();
            while (keysEnum.hasMoreElements()) {
                keyList.add(keysEnum.nextElement());
            }
            Collections.sort(keyList, STRING_COMPARATOR);
            return keyList.elements();
        }
    }
}

