/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopyFileClient
implements Runnable {
    private final String localFilePath;
    private final OutputStream fileOut;
    private final Socket socket;
    private int bytesCopied = 0;
    private boolean transferComplete = false;
    private static final Logger logger = Logger.getLogger(CopyFileClient.class.getName());
    private Exception failureException = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyFileClient(String localFilePath, String host) throws IOException {
        this.localFilePath = localFilePath;
        this.fileOut = new FileOutputStream(localFilePath);
        boolean createdSocket = false;
        try {
            this.socket = new Socket(host, 2376);
            createdSocket = true;
        }
        finally {
            if (!createdSocket) {
                try {
                    this.fileOut.close();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Ignoring exception when closing file", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile() {
        byte[] buffer = new byte[4000];
        FilterInputStream in = null;
        int totalBytes = 0;
        try {
            logger.log(Level.FINE, "Connected to server");
            in = new DataInputStream(this.socket.getInputStream());
            while (true) {
                short count;
                if ((count = ((DataInputStream)in).readShort()) == 0) break;
                this.copyBytes(buffer, count, in, this.fileOut);
                totalBytes += count;
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Wrote " + count + " bytes");
            }
            this.fileOut.flush();
            logger.log(Level.FINE, "File is done");
            this.setBytesCopied(totalBytes);
            this.setTransferComplete();
            this.fileOut.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "CopyFileClient: Error while retrieving" + this.localFilePath, e);
            this.setFailureException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {}
            }
            try {
                this.fileOut.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void run() {
        this.copyFile();
    }

    private void copyBytes(byte[] buffer, int count, InputStream in, OutputStream out) throws IOException, InterruptedException {
        while (count > 0) {
            int n = in.read(buffer, 0, count);
            if (n < 0) {
                throw new EOFException("Unexpected EOF from server");
            }
            out.write(buffer, 0, n);
            count -= n;
            if (!Thread.interrupted()) continue;
            throw new InterruptedException("File copy interrupted");
        }
    }

    public synchronized boolean isTransferComplete() {
        return this.transferComplete;
    }

    private synchronized void setTransferComplete() {
        this.transferComplete = true;
    }

    public synchronized int getBytesCopied() {
        return this.bytesCopied;
    }

    private synchronized void setBytesCopied(int nBytes) {
        this.bytesCopied = nBytes;
    }

    public synchronized Exception getFailureException() {
        return this.failureException;
    }

    private synchronized void setFailureException(Exception e) {
        this.failureException = e;
    }
}

