/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.blc;

import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.AbstractBusinessLogicDomain;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.BlcEventAddressInfo;
import com.vmware.sva.services.watchdog.WatchdogTimer;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
public abstract class AbstractBlcJUnitTestNew<D extends AbstractBusinessLogicDomain, C extends AbstractBusinessLogicComponent> {
    protected C blc;
    protected D domain;
    protected WatchdogTimer watchdogTimer;
    private UUID id = null;
    private String name = null;
    protected static final UUID domainId = AbstractBlcJUnitTestNew.debugUUID('d');
    protected static final UUID domainBldInstantiationId = AbstractBlcJUnitTestNew.debugUUID('e');
    protected static final UUID requestBlc = UUID.fromString("66666666-abcd-abcd-abcd-abcdabcdabcd");
    protected static final UUID UUID_1 = AbstractBlcJUnitTestNew.debugUUID('1');
    protected static final UUID UUID_2 = AbstractBlcJUnitTestNew.debugUUID('2');
    protected static final UUID UUID_3 = AbstractBlcJUnitTestNew.debugUUID('3');
    protected static final UUID UUID_4 = AbstractBlcJUnitTestNew.debugUUID('4');
    protected static final UUID UUID_5 = AbstractBlcJUnitTestNew.debugUUID('5');
    protected static final UUID UUID_6 = AbstractBlcJUnitTestNew.debugUUID('6');
    private static final Class[] invokeTypeWithUUID = new Class[]{UUID.class, AbstractBlcMessage.class};
    private static final Class[] invokeTypeWithAddress = new Class[]{BlcEventAddressInfo.class, AbstractBlcMessage.class};

    @Before
    public void setUp() {
        this.blc = this.createPartialBlc();
        this.initializeDomain();
        this.setBlcFields(this.id, this.name);
        Assert.assertNotNull((Object)Whitebox.getInternalState(this.blc, (String)"domain"));
        Assert.assertNotNull((Object)Whitebox.getInternalState(this.blc, (String)"edgeWatchdog"));
    }

    protected void initializeDomain() {
        EasyMock.expect((Object)this.domain.getId()).andStubReturn((Object)domainId);
        EasyMock.expect((Object)this.domain.getName()).andStubReturn((Object)("Test-Domain-" + domainId));
        EasyMock.expect((Object)this.domain.getBldInstantiationId((UUID)EasyMock.isA(UUID.class))).andStubReturn((Object)domainBldInstantiationId);
    }

    protected abstract C createPartialBlc();

    protected void setBlcFields(UUID blcId, String name) {
        Assert.assertNotNull((String)"mock BLC is not created", this.blc);
        Assert.assertNotNull((String)"mock domain is not created", this.domain);
        assert (blcId != null);
        Whitebox.setInternalState(this.blc, (String)"domain", this.domain);
        Whitebox.setInternalState(this.blc, (String)"id", (Object)blcId);
        Whitebox.setInternalState(this.blc, (String)"name", (Object)name);
        this.watchdogTimer = (WatchdogTimer)PowerMock.createStrictMock(WatchdogTimer.class);
        Whitebox.setInternalState(this.blc, (String)"edgeWatchdog", (Object)this.watchdogTimer);
        ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.INFO), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().asStub();
        ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.FINE), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().asStub();
        ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.FINER), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().asStub();
        ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.FINEST), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().asStub();
    }

    protected void sendMessage(UUID dstBld, UUID dstBlc, Class<?> messageClass) throws Exception {
        Whitebox.invokeMethod(this.blc, (String)"sendMessage", (Object[])new Object[]{EasyMock.eq((Object)dstBld), EasyMock.eq((Object)dstBlc), EasyMock.isA(messageClass)});
    }

    protected void sendMessage(UUID dstBlc, Class<?> messageClass) throws Exception {
        Whitebox.invokeMethod(this.blc, (String)"sendMessage", (Class[])invokeTypeWithUUID, (Object[])new Object[]{EasyMock.eq((Object)dstBlc), EasyMock.isA(messageClass)});
    }

    protected void sendMessage(BlcEventAddressInfo header, Class<?> messageClass) throws Exception {
        Whitebox.invokeMethod(this.blc, (String)"sendMessage", (Class[])invokeTypeWithAddress, (Object[])new Object[]{EasyMock.eq((Object)((Object)header)), EasyMock.isA(messageClass)});
    }

    protected void sendMessage(Class<?> messageClass) throws Exception {
        Whitebox.invokeMethod(this.blc, (String)"sendMessage", (Class[])invokeTypeWithAddress, (Object[])new Object[]{EasyMock.isA(BlcEventAddressInfo.class), EasyMock.isA(messageClass)});
    }

    protected void sendResponse(AbstractBlcMessage request, Class<?> responseClass) throws Exception {
        Whitebox.invokeMethod(this.blc, (String)"sendResponse", (Object[])new Object[]{EasyMock.eq((Object)((Object)request)), EasyMock.isA(responseClass)});
    }

    protected void resetEdgeWatchdog(int newInterval) throws Exception {
        Whitebox.invokeMethod(this.blc, (String)"resetEdgeWatchdog", (Object[])new Object[]{newInterval});
    }

    protected void logWarning() {
        ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.WARNING), (String)EasyMock.isA(String.class));
    }

    protected void logWarning(Throwable exp) {
        if (exp != null) {
            ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.WARNING), (String)EasyMock.isA(String.class), (Throwable)EasyMock.eq((Object)exp));
        } else {
            ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.WARNING), (String)EasyMock.isA(String.class), (Throwable)EasyMock.isA(Exception.class));
        }
    }

    protected void logSevere() {
        ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.SEVERE), (String)EasyMock.isA(String.class));
    }

    protected void logSevere(Throwable exp) {
        if (exp != null) {
            ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.SEVERE), (String)EasyMock.isA(String.class), (Throwable)EasyMock.eq((Object)exp));
        } else {
            ((AbstractBusinessLogicComponent)this.blc).log((Level)EasyMock.eq((Object)Level.SEVERE), (String)EasyMock.isA(String.class), (Throwable)EasyMock.isA(Exception.class));
        }
    }

    protected static <M extends AbstractBlcMessage> M setHeader(M message, UUID srcBld, UUID srcBlc, UUID dstBld, UUID dstBlc) {
        message.setHeader(new BlcEventAddressInfo(srcBld, srcBlc, dstBld, dstBlc));
        return message;
    }

    private static UUID debugUUID(char c) {
        char[] array = new char[36];
        Arrays.fill(array, c);
        array[8] = 45;
        array[13] = 45;
        array[18] = 45;
        array[23] = 45;
        return UUID.fromString(new String(array));
    }
}

