/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld;

import com.vmware.sva.bld.BldEventWatcher;
import com.vmware.sva.bld.BldException;
import com.vmware.sva.common.util.NamedThreadFactory;
import com.vmware.sva.util.SvaHelper;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBldEvent {
    protected static final Logger logger = Logger.getLogger(AbstractBldEvent.class.getName());
    private static final Executor executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("BLD-Event-Send-Thread-"));

    public final void send(BldEventWatcher watcher) {
        if (watcher == null) {
            try {
                throw new BldException("watcher is null");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }
        executor.execute(new SendEvent(this, watcher));
    }

    public static class SendEvent
    implements Runnable {
        private final AbstractBldEvent event;
        private final BldEventWatcher watcher;

        public SendEvent(AbstractBldEvent event, BldEventWatcher watcher) {
            if (event == null || watcher == null) {
                try {
                    throw new Exception("event or watcher is null");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage());
                    e.printStackTrace();
                }
            }
            this.event = event;
            this.watcher = watcher;
        }

        @Override
        public void run() {
            try {
                this.watcher.handleBldEvent(this.event);
            }
            catch (AssertionError e) {
                SvaHelper.handleAssertionError("AbstractBldEvent.SendEvent", e, logger);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception while handling BLD event: " + e.getMessage(), e);
            }
        }
    }
}

