/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.ft;

import com.vmware.sva.bld.AbstractBldEvent;
import com.vmware.sva.bld.BldEventWatcher;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.bld.ServiceRequestOperation;
import com.vmware.sva.bld.ft.FtBldDatabase;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.ResetBldSequenceNumberMessage;
import com.vmware.sva.services.messaging.BlcMessageRequest;
import com.vmware.sva.zkservice.BldMessagesAvailableEvent;
import com.vmware.sva.zkservice.ZkClient;
import com.vmware.sva.zkservice.ZkOfflineException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.zookeeper.KeeperException;

public class FtMessageService
extends AbstractDomainService
implements BldEventWatcher {
    private static final long serialVersionUID = 1L;
    private Map<UUID, Long> liveReceiveSequenceNumberMap;
    private Map<UUID, Long> transmitSequenceNumberMap = null;
    private final FtBldDatabase database;
    private final ZkClient zkClient;

    public FtMessageService(BusinessLogicDomainServiceAPI domain, ZkClient zkClient) throws Exception {
        super(SvaConstants.MESSAGE_SERVICE_ID, "Message Service", domain);
        this.database = (FtBldDatabase)domain.getDatabase();
        this.zkClient = zkClient;
    }

    @Override
    public void start() throws Exception {
        this.liveReceiveSequenceNumberMap = this.database.getReceiveSeqNumMap();
        super.start();
    }

    public void restoreFromPersistent() throws Exception {
        this.liveReceiveSequenceNumberMap = this.database.getReceiveSeqNumMap();
    }

    @Override
    public final void persistRequest(AbstractServiceRequest request) throws Exception {
        if (request instanceof BlcMessageRequest) {
            BlcMessageRequest blcMessageRequest = (BlcMessageRequest)request;
            AbstractBlcMessage msg = blcMessageRequest.getMessage();
            if (msg.isSourceLocal(this.localDomainId)) {
                if (msg.isDestinationLocal(this.localDomainId)) {
                    UUID destintationBlc = msg.getHeader().getDestinationBlc();
                    this.logMessage(msg, " Sending ");
                    this.database.addBlcEvent(destintationBlc, msg);
                } else if (this.domain.isMaster()) {
                    UUID destinationBld = msg.getHeader().getDestinationBld();
                    msg.setSequenceNumber(this.nextTransmitSequenceNumber(destinationBld));
                    this.logMessage(msg, " Sending ");
                    this.zkClient.sendMessage(msg);
                }
            } else {
                UUID sourceBld = msg.getHeader().getSourceBld();
                if (msg instanceof ResetBldSequenceNumberMessage) {
                    this.log(Level.INFO, "Resetting sequence number for domain " + sourceBld.toString());
                    this.database.setReceiveSeqNumTable(sourceBld, 0L);
                } else {
                    long lastSequenceNumber;
                    long sequenceNumber = msg.getSequenceNumber();
                    if (sequenceNumber > (lastSequenceNumber = this.database.getReceiveSeqNum(sourceBld))) {
                        UUID destinationBlc = msg.getHeader().getDestinationBlc();
                        if (sequenceNumber != lastSequenceNumber + 1L) {
                            this.log(Level.WARNING, "Fault-tolerant domain missing messages between " + lastSequenceNumber + " and " + sequenceNumber + " from domain " + sourceBld.toString());
                        }
                        if (SvaDebug.LOG_FT_MESSAGES) {
                            this.log(Level.INFO, "Received message seq " + sequenceNumber + " for BLC " + destinationBlc + " from " + sourceBld + "/" + msg.getHeader().getSourceBlc());
                        }
                        this.database.setReceiveSeqNumTable(sourceBld, sequenceNumber);
                        this.database.addBlcEvent(destinationBlc, msg);
                    } else {
                        this.log(Level.WARNING, "Discarding duplicate message " + sequenceNumber);
                    }
                }
            }
        } else {
            String errorMsg = "Invalid request received by fault-tolerant message service: " + ((Object)((Object)request)).getClass().toString();
            assert (false) : errorMsg;
            this.log(Level.SEVERE, errorMsg);
        }
    }

    @Override
    public void reprocessPersistRequest(AbstractServiceRequest request) throws Exception {
        if (request instanceof BlcMessageRequest) {
            BlcMessageRequest blcMessageRequest = (BlcMessageRequest)request;
            AbstractBlcMessage msg = blcMessageRequest.getMessage();
            this.log(Level.INFO, "Reprocessing message request: seq=" + msg.getSequenceNumber() + " source=" + msg.getHeader().getSourceBld() + "/" + msg.getHeader().getSourceBlc() + " destination=" + msg.getHeader().getDestinationBld() + "/" + msg.getHeader().getDestinationBlc());
            if (msg.isSourceLocal(this.localDomainId) && !msg.isDestinationLocal(this.localDomainId)) {
                UUID destinationBld = msg.getHeader().getDestinationBld();
                msg.setSequenceNumber(this.nextTransmitSequenceNumber(destinationBld));
                this.logMessage(msg, " Resending ");
                this.zkClient.sendMessage(msg);
            }
        } else {
            String errorMsg = "Invalid request received by fault-tolerant message service: " + ((Object)((Object)request)).getClass().toString();
            assert (false) : errorMsg;
            this.log(Level.SEVERE, errorMsg);
        }
    }

    @Override
    public final void postpersistRequest(AbstractServiceRequest request) {
        if (request instanceof BlcMessageRequest) {
            BlcMessageRequest blcMessageRequest = (BlcMessageRequest)request;
            AbstractBlcMessage msg = blcMessageRequest.getMessage();
            if (msg.isSourceLocal(this.localDomainId)) {
                if (msg.isDestinationLocal(this.localDomainId)) {
                    UUID destintationBlc = msg.getHeader().getDestinationBlc();
                    this.logMessage(msg, " Sending ");
                    this.domain.queueLiveBlcEvent(destintationBlc, msg);
                }
            } else {
                UUID sourceBld = msg.getHeader().getSourceBld();
                if (msg instanceof ResetBldSequenceNumberMessage) {
                    this.log(Level.INFO, "Resetting sequence number for domain " + sourceBld.toString());
                    this.liveReceiveSequenceNumberMap.put(sourceBld, 0L);
                } else {
                    long lastSequenceNumber;
                    long sequenceNumber = msg.getSequenceNumber();
                    long l = lastSequenceNumber = !this.liveReceiveSequenceNumberMap.containsKey(sourceBld) ? 0L : this.liveReceiveSequenceNumberMap.get(sourceBld);
                    if (sequenceNumber > lastSequenceNumber) {
                        UUID destinationBlc = msg.getHeader().getDestinationBlc();
                        if (sequenceNumber != lastSequenceNumber + 1L) {
                            this.log(Level.WARNING, "Fault-tolerant domain missing messages between " + lastSequenceNumber + " and " + sequenceNumber + " from domain " + sourceBld.toString());
                        }
                        if (SvaDebug.LOG_FT_MESSAGES) {
                            this.log(Level.INFO, "Received message seq " + sequenceNumber + " for BLC " + destinationBlc + " from " + sourceBld + "/" + msg.getHeader().getSourceBlc());
                        }
                        this.liveReceiveSequenceNumberMap.put(sourceBld, sequenceNumber);
                        this.domain.queueLiveBlcEvent(destinationBlc, msg);
                    } else {
                        this.log(Level.WARNING, "Discarding duplicate message " + sequenceNumber);
                    }
                }
            }
        } else {
            String errorMsg = "Invalid request received by fault-tolerant message service: " + ((Object)((Object)request)).getClass().toString();
            assert (false) : errorMsg;
            this.log(Level.SEVERE, errorMsg);
        }
    }

    private long nextTransmitSequenceNumber(UUID bldId) {
        long nextSequenceNumber = 1L;
        if (this.transmitSequenceNumberMap.containsKey(bldId)) {
            nextSequenceNumber = this.transmitSequenceNumberMap.get(bldId) + 1L;
        }
        this.transmitSequenceNumberMap.put(bldId, nextSequenceNumber);
        return nextSequenceNumber;
    }

    public void startCheckingForMessages() throws Exception {
        this.checkForMessages();
    }

    @Override
    public void handleBldEvent(AbstractBldEvent bldEvent) {
        if (bldEvent instanceof BldMessagesAvailableEvent) {
            this.checkForMessages();
        } else {
            assert (false) : "Fault-tolerant message service received unknown BLC event: " + bldEvent.getClass().toString();
            this.log(Level.SEVERE, "Fault-tolerant message service received unknown BLC event: " + bldEvent.getClass().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForMessages() {
        FtMessageService ftMessageService = this;
        synchronized (ftMessageService) {
            try {
                List<String> messageIds = this.zkClient.getMessageList(this);
                for (String messageId : messageIds) {
                    BldTransaction transaction = new BldTransaction();
                    AbstractBlcMessage blcMessage = this.zkClient.getMessage(messageId);
                    if (blcMessage == null) {
                        this.log(Level.SEVERE, "Unable to read message from fault-tolerant domain zookeeper queue: " + messageId);
                        continue;
                    }
                    if (SvaDebug.LOG_FT_MESSAGES) {
                        this.log(Level.INFO, this.domain.getId() + " Received remote message " + ((Object)((Object)blcMessage)).getClass().getSimpleName() + " seq " + blcMessage.getSequenceNumber() + " from " + blcMessage.getHeader().getSourceBld() + "/" + blcMessage.getHeader().getSourceBlc());
                    }
                    BlcMessageRequest blcMessageRequest = new BlcMessageRequest(blcMessage);
                    ServiceRequestOperation operation = new ServiceRequestOperation(SvaConstants.MESSAGE_SERVICE_ID, blcMessageRequest);
                    transaction.add(operation);
                    this.domain.commitTransaction(transaction);
                    this.zkClient.deleteMessage(messageId);
                }
            }
            catch (KeeperException e) {
                this.log(Level.WARNING, "Could not get inter-domain messages for fault-tolerant domain: assuming replica has gone offline", e);
            }
            catch (ZkOfflineException e) {
                this.log(Level.WARNING, "Could not get inter-domain messages for fault-tolerant domain: assuming replica has gone offline", (Throwable)((Object)e));
            }
            catch (Exception e) {
                String errorMsg = "Exception while receiving inter-domain messages for fault-tolerant domain: " + e.getMessage();
                assert (false) : errorMsg;
                this.log(Level.SEVERE, errorMsg);
                e.printStackTrace();
            }
        }
    }

    private void logMessage(AbstractBlcMessage msg, String prefixMsg) {
        if (SvaDebug.LOG_FT_MESSAGES) {
            this.log(Level.INFO, this.domain.getId() + prefixMsg + ((Object)((Object)msg)).getClass().getSimpleName() + " seq " + msg.getSequenceNumber() + " to " + msg.getHeader().getDestinationBld() + "/" + msg.getHeader().getDestinationBlc());
        }
    }

    public Map<UUID, Long> getTransmitSequenceNumberMap() {
        return this.transmitSequenceNumberMap;
    }

    public void setTransmitSequenceNumberMap(Map<UUID, Long> transmitSequenceNumberMap) {
        this.transmitSequenceNumberMap = transmitSequenceNumberMap;
    }
}

