/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.persistent;

import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.bld.persistent.PersistentBldDatabase;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.messaging.BlcMessageRequest;
import java.util.UUID;
import java.util.logging.Level;

public class PersistentMessageService
extends AbstractDomainService {
    private static final long serialVersionUID = 1L;
    private final PersistentBldDatabase database;

    public PersistentMessageService(BusinessLogicDomainServiceAPI domain) throws Exception {
        super(SvaConstants.MESSAGE_SERVICE_ID, "Message Service", domain);
        this.database = (PersistentBldDatabase)domain.getDatabase();
    }

    @Override
    public void persistRequest(AbstractServiceRequest request) throws Exception {
        if (!(request instanceof BlcMessageRequest)) {
            String errorStr = "MessageService recieved an object that was not a BlcMessageRequest";
            this.log(Level.SEVERE, errorStr);
            assert (false) : errorStr;
        } else {
            BlcMessageRequest blcMessageRequest = (BlcMessageRequest)request;
            AbstractBlcMessage msg = blcMessageRequest.getMessage();
            if (msg.isSourceLocal(this.localDomainId)) {
                UUID destintationBlc = msg.getHeader().getDestinationBlc();
                this.database.addBlcEvent(destintationBlc, msg);
            } else {
                String errorStr = "Persistent domain does not support inter-domain messaging";
                this.log(Level.SEVERE, errorStr);
                assert (false) : errorStr;
            }
        }
    }

    @Override
    public void postpersistRequest(AbstractServiceRequest request) {
        if (!(request instanceof BlcMessageRequest)) {
            String errorStr = "MessageServiced recieved an object that was not a BlcMessageRequest";
            this.log(Level.SEVERE, errorStr);
            assert (false) : errorStr;
        } else {
            BlcMessageRequest blcMessageRequest = (BlcMessageRequest)request;
            AbstractBlcMessage msg = blcMessageRequest.getMessage();
            if (msg.isSourceLocal(this.localDomainId)) {
                UUID destintationBlc = msg.getHeader().getDestinationBlc();
                this.domain.queueLiveBlcEvent(destintationBlc, msg);
            } else {
                String errorStr = "Persistent domain does not support inter-domain messaging";
                this.log(Level.SEVERE, errorStr);
                assert (false) : errorStr;
            }
        }
    }
}

