/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.bld.AbstractBldEvent;
import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.VersionDbTable;
import com.vmware.sva.util.BasicLoggerInterface;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractDbTable
implements BasicLoggerInterface {
    protected Connection connection = null;
    protected String tableName;
    protected String tableColumns;
    protected static final Logger logger = Logger.getLogger(AbstractBldEvent.class.getName());

    public AbstractDbTable(Connection connection, String tableName, String tableColumns) throws SQLException, BldException {
        this.connection = connection;
        this.tableName = tableName;
        this.tableColumns = tableColumns;
        this.createTable();
    }

    public abstract boolean validate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTable() throws SQLException, BldException {
        if (!this.tableExists()) {
            Statement statement = this.connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE \"" + this.tableName + "\" " + this.tableColumns);
            }
            finally {
                statement.close();
            }
        }
    }

    public void deleteTable() throws SQLException {
        AbstractDbTable.deleteTable(this.connection, this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void deleteTable(Connection connection, String tableName) throws SQLException {
        if (AbstractDbTable.tableExists(connection, tableName)) {
            logger.log(Level.INFO, "Deleting table " + tableName);
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate("DROP TABLE \"" + tableName + "\"");
            }
            finally {
                statement.close();
            }
        }
    }

    @Override
    public void log(LogRecord logRecord) {
        logger.log(logRecord);
    }

    @Override
    public void log(Level level, String message) {
        logger.log(level, message);
    }

    @Override
    public void log(Level level, String msg, Throwable exception) {
        logger.log(level, msg, exception);
    }

    public abstract void upgrade(VersionDbTable var1) throws Exception;

    /*
     * Exception decompiling
     */
    protected final void upgradeColumn(String columnName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean safeEquals(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    protected void setPstmtArg(PreparedStatement pstmt, int arg, Object obj) throws SQLException, Exception {
        if (SvaConstants.USE_XSTREAM) {
            pstmt.setString(arg, BldSerialization.objectToXml(obj));
        } else {
            pstmt.setBytes(arg, BldSerialization.objectToBytes(obj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCount(String key) throws SQLException, BldException {
        Statement statement = this.connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("SELECT COUNT(*) FROM \"" + this.tableName + "\" WHERE name = '" + key + "'");
            if (!rs.next()) {
                throw new BldException("Could not get attribute");
            }
            long l = rs.getLong(1);
            return l;
        }
        finally {
            statement.close();
        }
    }

    private boolean tableExists() throws SQLException {
        return AbstractDbTable.tableExists(this.connection, this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableExists(Connection connection, String tableName) throws SQLException {
        ResultSet rs = connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
        boolean foundTable = false;
        try {
            while (rs.next()) {
                if (!rs.getString("TABLE_NAME").equals(tableName)) continue;
                foundTable = true;
            }
            boolean bl = foundTable;
            return bl;
        }
        finally {
            rs.close();
        }
    }
}

