/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.database.AbstractBldDatabase;
import com.vmware.sva.database.BlcDbTable;
import com.vmware.sva.database.BlcEventQueueDbTable;
import com.vmware.sva.database.SharedObjectDbTable;
import com.vmware.sva.database.VersionDbTable;
import com.vmware.sva.services.blcevents.controlevent.BlcStartEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public abstract class AbstractPersistentBldDatabase
extends AbstractBldDatabase {
    private BlcDbTable blcTable;
    private Map<UUID, BlcEventQueueDbTable> eventQueueMap;
    private SharedObjectDbTable sharedObjectTable;

    public AbstractPersistentBldDatabase(String dbName) throws Exception {
        super(dbName);
    }

    public List<AbstractBusinessLogicComponent> getBlcList() throws Exception {
        return this.blcTable.getBlcList();
    }

    public AbstractBusinessLogicComponent getBlc(UUID blcId) throws Exception {
        try {
            return this.blcTable.getBlc(blcId);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Exception while getting BLC: " + e.getMessage());
            return null;
        }
    }

    public void addBlc(AbstractBusinessLogicComponent blc) throws Exception {
        this.blcTable.addBlc(blc);
        UUID blcId = blc.getId();
        BlcEventQueueDbTable beqdt = new BlcEventQueueDbTable(this.connection, blcId, this);
        this.eventQueueMap.put(blcId, beqdt);
        beqdt.addEvent(new BlcStartEvent(blc.getId()));
    }

    public void updateBlc(AbstractBusinessLogicComponent blc) throws Exception {
        this.blcTable.updateBlc(blc);
    }

    public void deleteBlc(UUID blcId) throws SQLException, BldException {
        this.blcTable.deleteBlc(blcId);
        this.eventQueueMap.get(blcId).deleteTable();
        this.eventQueueMap.remove(blcId);
    }

    public List<AbstractBlcEvent> getBlcEventQueue(UUID blcId) throws Exception {
        if (!this.eventQueueMap.containsKey(blcId)) {
            this.eventQueueMap.put(blcId, new BlcEventQueueDbTable(this.connection, blcId, this));
        }
        return this.eventQueueMap.get(blcId).getEvents();
    }

    public boolean addBlcEvent(UUID blcId, AbstractBlcEvent event) throws Exception {
        BlcEventQueueDbTable eq = this.eventQueueMap.get(blcId);
        if (eq == null) {
            this.log(Level.WARNING, "Attempt to deliver message to unknown BLC ID=" + blcId.toString());
            return false;
        }
        eq.addEvent(event);
        return true;
    }

    public void removeBlcEvent(UUID blcId, UUID eventId) throws SQLException {
        this.eventQueueMap.get(blcId).removeEvent(eventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSharedObject(String key, Serializable obj) throws Exception {
        SharedObjectDbTable sharedObjectDbTable = this.sharedObjectTable;
        synchronized (sharedObjectDbTable) {
            this.sharedObjectTable.writeObject(key, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSharedObject(String key) throws SQLException, BldException {
        SharedObjectDbTable sharedObjectDbTable = this.sharedObjectTable;
        synchronized (sharedObjectDbTable) {
            this.sharedObjectTable.deleteObject(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getSharedObject(String key) throws Exception {
        Serializable obj = null;
        SharedObjectDbTable sharedObjectDbTable = this.sharedObjectTable;
        synchronized (sharedObjectDbTable) {
            obj = this.sharedObjectTable.getSharedObject(key);
        }
        return obj;
    }

    public boolean reloadContents(byte[] contents) throws Exception {
        try {
            File pathFile;
            String dbTmpPath;
            File tmpPathFile;
            this.close();
            File tmpBasePathFile = new File(DB_BACKUP_PATH);
            if (!tmpBasePathFile.exists() && !tmpBasePathFile.mkdirs()) {
                this.log(Level.SEVERE, "Could not create " + DB_BACKUP_PATH);
            }
            if ((tmpPathFile = new File(dbTmpPath = DB_BACKUP_PATH + "/" + this.dbName + ".db")).exists()) {
                this.deleteTree(tmpPathFile);
            }
            BldSerialization.UnzipFiles(DB_BACKUP_PATH, contents);
            File basePathFile = new File(DB_PATH);
            if (!basePathFile.exists() && !basePathFile.mkdirs()) {
                this.log(Level.SEVERE, "Could not create " + DB_PATH);
            }
            if ((pathFile = new File(this.dbPath)).exists()) {
                this.deleteTree(pathFile);
            }
            this.initializeTables(true);
            this.maybeUpgradeTables();
            this.connection.commit();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to reload database from replica copy: " + e.getMessage());
            return false;
        }
    }

    @Override
    protected void initializeTables(boolean restore) throws Exception {
        super.initializeTables(restore);
        this.blcTable = new BlcDbTable(this.connection);
        this.eventQueueMap = new HashMap<UUID, BlcEventQueueDbTable>();
        for (AbstractBusinessLogicComponent blc : this.blcTable.getBlcList()) {
            UUID blcId = blc.getId();
            this.eventQueueMap.put(blcId, new BlcEventQueueDbTable(this.connection, blcId, this));
        }
        this.sharedObjectTable = new SharedObjectDbTable(this.connection);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (!this.blcTable.validate()) {
            return false;
        }
        if (!this.sharedObjectTable.validate()) {
            return false;
        }
        return this.validateBlcEventQueues();
    }

    public boolean validateBlcEventQueues() {
        try {
            for (AbstractBusinessLogicComponent blc : this.blcTable.getBlcList()) {
                if (this.eventQueueMap.get(blc.getId()).validate()) continue;
                return false;
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to validate BLC event queues", e);
            return false;
        }
        return true;
    }

    @Override
    protected void upgradeTables() throws Exception {
        super.upgradeTables();
        VersionDbTable versionTable = this.getVersionTable();
        this.blcTable.upgrade(versionTable);
        for (BlcEventQueueDbTable eventQueueTable : this.eventQueueMap.values()) {
            eventQueueTable.upgrade(versionTable);
        }
        this.sharedObjectTable.upgrade(versionTable);
    }

    public abstract void setDatabaseCorrupt() throws SQLException, IOException;
}

