/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.AbstractDbTable;
import com.vmware.sva.database.VersionDbTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class BlcDbTable
extends AbstractDbTable {
    private static final String DB_TABLE_NAME = "BLC_TABLE";
    private static final String DB_TABLE_COLUMNS = SvaConstants.USE_XSTREAM ? "(name VARCHAR(255), data LONG VARCHAR)" : "(name VARCHAR(255), data BLOB)";

    public BlcDbTable(Connection connection) throws SQLException, BldException {
        super(connection, DB_TABLE_NAME, DB_TABLE_COLUMNS);
    }

    public AbstractBusinessLogicComponent getBlc(UUID bldId) throws Exception {
        if (SvaConstants.USE_XSTREAM) {
            return (AbstractBusinessLogicComponent)BldSerialization.xmlToObject(this.getDbObjectString(bldId.toString()));
        }
        return (AbstractBusinessLogicComponent)BldSerialization.bytesToObject(this.getDbObjectBytes(bldId.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlc(AbstractBusinessLogicComponent blc) throws Exception {
        String key = blc.getId().toString();
        if (this.getCount(key) > 0L) {
            this.log(Level.SEVERE, "Attempt to create a database object that already exists");
            this.updateBlc(blc);
        } else {
            PreparedStatement pstmt = this.connection.prepareStatement("INSERT INTO \"" + this.tableName + "\" VALUES(?,?)");
            try {
                pstmt.setString(1, key);
                this.setPstmtArg(pstmt, 2, blc);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlc(AbstractBusinessLogicComponent blc) throws Exception {
        String key = blc.getId().toString();
        if (this.getCount(key) == 0L) {
            this.log(Level.SEVERE, "Attempt to update a database object that does not exist");
            this.addBlc(blc);
        } else {
            PreparedStatement pstmt = this.connection.prepareStatement("UPDATE \"" + this.tableName + "\" SET data = ? WHERE name = ?");
            try {
                this.setPstmtArg(pstmt, 1, blc);
                pstmt.setString(2, key);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlc(UUID blcId) throws SQLException, BldException {
        String key = blcId.toString();
        if (this.getCount(key) == 0L) {
            this.log(Level.SEVERE, "Attempt to delete a database object that does not exist");
        } else {
            PreparedStatement pstmt = this.connection.prepareStatement("DELETE FROM \"" + this.tableName + "\" WHERE name = ?");
            try {
                pstmt.setString(1, key);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractBusinessLogicComponent> getBlcList() throws Exception {
        Statement statement = this.connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery("SELECT * FROM \"" + this.tableName + "\"");
            ArrayList<AbstractBusinessLogicComponent> blcs = new ArrayList<AbstractBusinessLogicComponent>();
            while (rs.next()) {
                AbstractBusinessLogicComponent blc = SvaConstants.USE_XSTREAM ? (AbstractBusinessLogicComponent)BldSerialization.xmlToObject(rs.getString("data")) : (AbstractBusinessLogicComponent)BldSerialization.bytesToObject(rs.getBytes("data"));
                blcs.add(blc);
            }
            ArrayList<AbstractBusinessLogicComponent> arrayList = blcs;
            return arrayList;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        this.log(Level.FINE, "Validating database table " + this.tableName);
        try {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT * FROM \"" + this.tableName + "\"");
                HashSet<UUID> blcIds = new HashSet<UUID>();
                while (rs.next()) {
                    AbstractBusinessLogicComponent blc = SvaConstants.USE_XSTREAM ? (AbstractBusinessLogicComponent)BldSerialization.xmlToObject(rs.getString("data")) : (AbstractBusinessLogicComponent)BldSerialization.bytesToObject(rs.getBytes("data"));
                    UUID blcId = blc.getId();
                    if (blcIds.contains(blcId)) {
                        throw new Exception("Duplicate BLC " + blcId + " found in " + this.tableName);
                    }
                    blcIds.add(blcId);
                    this.log(Level.FINE, "Validated BLC ID " + blcId);
                }
            }
            finally {
                statement.close();
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to validate table " + this.tableName, e);
            return false;
        }
        this.log(Level.FINE, "Database table " + this.tableName + " is valid");
        return true;
    }

    @Override
    public void upgrade(VersionDbTable versionTable) throws Exception {
        this.upgradeColumn("data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getDbObjectBytes(String key) {
        try {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT data FROM \"" + this.tableName + "\" WHERE name = '" + key + "'");
                if (!rs.next()) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] data = rs.getBytes("data");
                if (rs.next()) {
                    this.log(Level.SEVERE, "Multiple records found for DB object");
                }
                byte[] byArray = data;
                return byArray;
            }
            finally {
                statement.close();
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Exception while getting DB object: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDbObjectString(String key) {
        try {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT data FROM \"" + this.tableName + "\" WHERE name = '" + key + "'");
                if (!rs.next()) {
                    String string = null;
                    return string;
                }
                String data = rs.getString("data");
                if (rs.next()) {
                    this.log(Level.SEVERE, "Multiple records found for DB object");
                }
                String string = data;
                return string;
            }
            finally {
                statement.close();
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Exception while getting DB object: " + e);
            return null;
        }
    }
}

