/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.logger;

import com.vmware.sva.bld.BldType;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.services.logger.LoggerRequest;
import com.vmware.sva.services.logger.LoggerResponse;
import com.vmware.sva.services.logger.SvaLogFormatter;
import java.util.UUID;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;
import java.util.logging.XMLFormatter;

public class LoggerService
extends AbstractDomainService {
    private static final long serialVersionUID = 1L;
    public static final UUID SERVICE_ID = UUID.fromString("be1ec3b9-4d74-484c-8456-442cf22dc29f");
    private transient Logger logger = null;

    public LoggerService(BusinessLogicDomainServiceAPI domain) throws Exception {
        super(SERVICE_ID, "LoggerService", domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        super.start();
        LoggerService loggerService = this;
        synchronized (loggerService) {
            this.logger = Logger.getLogger(this.domain.getClass().getName());
            this.logger.setUseParentHandlers(false);
            this.logger.setLevel(SvaConstants.logLevel);
            FileHandler fileXml = new FileHandler(SvaConstants.LogPath + "/" + this.domain.getName() + "-BLC.xml", SvaConstants.MAX_LOG_FILE_SIZE, SvaConstants.MAX_LOG_FILES, true);
            FileHandler fileLog = new FileHandler(SvaConstants.LogPath + "/" + this.domain.getName() + "-BLC.log", SvaConstants.MAX_LOG_FILE_SIZE, SvaConstants.MAX_LOG_FILES, true);
            fileXml.setFormatter(new XMLFormatter());
            fileLog.setFormatter(new SvaLogFormatter());
            this.logger.addHandler(fileXml);
            this.logger.addHandler(fileLog);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new SvaLogFormatter());
            this.logger.addHandler(consoleHandler);
            if (!SvaConstants.LogServer.equals("")) {
                try {
                    String server = SvaConstants.LogServer;
                    Integer port = SvaConstants.LogServerPort;
                    SocketHandler handler = new SocketHandler(server, port);
                    if (SvaConstants.LogServerFormat.equals("xml")) {
                        handler.setFormatter(new XMLFormatter());
                    } else {
                        handler.setFormatter(new SvaLogFormatter());
                    }
                    this.logger.addHandler(handler);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Failed to use log server " + SvaConstants.LogServer + ":" + SvaConstants.LogServerPort, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        LoggerService loggerService = this;
        synchronized (loggerService) {
            for (Handler handler : this.logger.getHandlers()) {
                handler.close();
            }
            this.logger = null;
        }
        super.stop();
    }

    private synchronized void loggerLog(LogRecord record) {
        assert (this.logger != null);
        this.logger.log(record);
    }

    @Override
    public AbstractServiceResponse syncRequest(AbstractServiceRequest request) {
        if (!(request instanceof LoggerRequest)) {
            this.log(Level.SEVERE, "Invalid request type passed to LoggerServce");
        } else {
            this.loggerLog(((LoggerRequest)request).getLogRecord());
        }
        return new LoggerResponse(request.getRequestId(), this.getServiceId());
    }

    @Override
    public void persistRequest(AbstractServiceRequest request) {
        if (!(request instanceof LoggerRequest)) {
            this.log(Level.SEVERE, "Invalid request type passed to LoggerServce");
        } else if (this.domain.getType() != BldType.Nonpersistent) {
            this.loggerLog(((LoggerRequest)request).getLogRecord());
        }
    }

    @Override
    public void postpersistRequest(AbstractServiceRequest request) {
        if (!(request instanceof LoggerRequest)) {
            this.log(Level.SEVERE, "Invalid request type passed to LoggerServce");
        } else if (this.domain.getType() == BldType.Nonpersistent) {
            this.loggerLog(((LoggerRequest)request).getLogRecord());
        }
    }

    @Override
    public void removeBlc(UUID blcId) {
    }
}

