/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.util;

import com.vmware.sva.common.util.SystemCommand;
import com.vmware.sva.util.BasicLoggerInterface;
import com.vmware.sva.util.LoggerAdapter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SvaHelper {
    private static final String pattern = "^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{1,63}(?<!-)$";

    private SvaHelper() {
    }

    public static UUID readIdFile(String idFile) throws Exception {
        UUID id = null;
        File f = new File(idFile);
        if (f.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String value = br.readLine();
                if (value == null) {
                    throw new Exception("Unable to read ID file \"" + idFile + "\": " + "File is empty");
                }
                id = UUID.fromString(value);
            }
            catch (IOException e) {
                throw new Exception("Unable to read ID file \"" + idFile + "\": " + e.getMessage());
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        id = UUID.randomUUID();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(f));
            bw.write(id.toString());
            bw.close();
        }
        catch (IOException e) {
            throw new Exception("Unable to write ID file \"" + idFile + "\": " + e.getMessage());
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
        }
        return id;
    }

    public static String formatDevice(String device) {
        assert (device != null);
        return "/dev/" + device;
    }

    public static String[] getAttributeFromStdout(String attribute, String delimiter, String ... command) throws Exception {
        String line;
        if (delimiter == null) {
            delimiter = " ";
        }
        String output = SystemCommand.executePlatformCommand((String[])command);
        if (attribute == null) {
            return output.trim().split(delimiter);
        }
        String[] outStr = null;
        BufferedReader br = new BufferedReader(new StringReader(output));
        while ((line = br.readLine()) != null) {
            if (!line.contains(attribute)) continue;
            outStr = line.split(delimiter);
            break;
        }
        if (outStr == null || outStr.length == 0) {
            throw new Exception("getAttributeFromStdout: attribute not found");
        }
        return outStr;
    }

    public static Map<String, String> getAttributesFromStdout(String[] attributes, String delimiter, String ... command) throws Exception {
        String line;
        if (delimiter == null) {
            delimiter = " ";
        }
        String output = SystemCommand.executePlatformCommand((String[])command);
        HashMap<String, String> commandOutputMap = new HashMap<String, String>();
        String[] outStr = null;
        BufferedReader br = new BufferedReader(new StringReader(output));
        while ((line = br.readLine()) != null) {
            outStr = line.split(delimiter, 2);
            String key = outStr[0];
            String value = outStr[1];
            commandOutputMap.put(key.trim(), value.trim());
        }
        if (attributes == null || attributes.length == 0) {
            return commandOutputMap;
        }
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String key : attributes) {
            attributeMap.put(key, (String)commandOutputMap.get(key));
        }
        return attributeMap;
    }

    public static String[] getAttributeFromFile(String attribute, String delimiter, String file) throws Exception {
        String[] outStr = null;
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            if (delimiter == null) {
                delimiter = " ";
            }
            if (attribute == null) {
                String value = br.readLine();
                outStr = value != null ? value.split(delimiter) : null;
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains(attribute)) continue;
                    outStr = line.split(delimiter);
                    break;
                }
                if (outStr == null) {
                    throw new Exception("getAttributeFromFile: attribute not found");
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Unable to get attribute: " + e.getMessage());
        }
        finally {
            br.close();
        }
        return outStr;
    }

    public static String getSimpleClassName(Object object) {
        return object != null ? object.getClass().getSimpleName() : "null";
    }

    public static boolean isNameValid(String name) {
        return Pattern.matches(pattern, name);
    }

    @SuppressWarnings(value={"DM_EXIT"}, justification="System exit is intended")
    public static void handleAssertionError(String componentName, AssertionError error, BasicLoggerInterface logger) {
        if (componentName == null) {
            throw new NullPointerException("The componentName must not be null");
        }
        String errorMessage = componentName + ": ASSERTION ERROR! stopping virtual machine: " + ((Throwable)((Object)error)).getMessage();
        if (logger != null) {
            logger.log(Level.SEVERE, errorMessage, (Throwable)((Object)error));
        }
        System.err.println(errorMessage);
        ((Throwable)((Object)error)).printStackTrace();
        System.err.flush();
        System.exit(-1);
    }

    public static void handleAssertionError(String componentName, AssertionError error, Logger logger) {
        SvaHelper.handleAssertionError(componentName, error, logger != null ? new LoggerAdapter(logger) : null);
    }

    public static <T extends Throwable> T initCause(T exception, Throwable cause) {
        exception.initCause(cause);
        return exception;
    }
}

